/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import org.eclipse.cdt.internal.ui.text.CTextTools;
import org.eclipse.cdt.internal.ui.text.IColorManager;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProcessor2;
import org.eclipse.cdt.internal.ui.text.util.CColorManager;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public class ContentAssistPreference {
    public static final String AUTOACTIVATION_DELAY = "content_assist_autoactivation_delay";
    public static final String TIMEOUT_DELAY = "content_assist_timeout_delay";
    public static final String PROPOSALS_FOREGROUND = "content_assist_proposals_foreground";
    public static final String PROPOSALS_BACKGROUND = "content_assist_proposals_background";
    public static final String PARAMETERS_FOREGROUND = "content_assist_parameters_foreground";
    public static final String PARAMETERS_BACKGROUND = "content_assist_parameters_background";
    public static final String AUTOINSERT = "content_assist_autoinsert";
    public static final String CODEASSIST_PREFIX_COMPLETION = "content_assist_prefix_completion";
    public static final String AUTOACTIVATION_TRIGGERS_DOT = "content_assist_autoactivation_trigger_dot";
    public static final String AUTOACTIVATION_TRIGGERS_ARROW = "content_assist_autoactivation_trigger_arrow";
    public static final String AUTOACTIVATION_TRIGGERS_DOUBLECOLON = "content_assist_autoactivation_trigger_doublecolon";
    public static final String SHOW_DOCUMENTED_PROPOSALS = "content_assist_show_visible_proposals";
    public static final String ORDER_PROPOSALS = "content_assist_order_proposals";
    public static final String ADD_INCLUDE = "content_assist_add_import";
    public static final String CURRENT_FILE_SEARCH_SCOPE = "content_assist_current_file_search_scope";
    public static final String PROJECT_SEARCH_SCOPE = "content_assist_project_search_scope";
    public static final String PROPOSALS_FILTER = "content_assist_proposal_filter";

    private static Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    private static Color getColor(IPreferenceStore store, String key) {
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        return ContentAssistPreference.getColor(store, key, textTools.getColorManager());
    }

    private static CCompletionProcessor2 getCProcessor(ContentAssistant assistant) {
        IContentAssistProcessor p = assistant.getContentAssistProcessor("__dftl_partition_content_type");
        if (p instanceof CCompletionProcessor2) {
            return (CCompletionProcessor2)p;
        }
        return null;
    }

    private static void configureCProcessor(ContentAssistant assistant, IPreferenceStore store) {
        boolean useDoubleColonAsTrigger;
        boolean useArrowAsTrigger;
        CCompletionProcessor2 jcp = ContentAssistPreference.getCProcessor(assistant);
        if (jcp == null) {
            return;
        }
        String triggers = "";
        boolean useDotAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
        if (useDotAsTrigger) {
            triggers = ".";
        }
        if (useArrowAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW)) {
            triggers = String.valueOf(triggers) + ">";
        }
        if (useDoubleColonAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON)) {
            triggers = String.valueOf(triggers) + ":";
        }
        jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        boolean enabled = store.getBoolean(SHOW_DOCUMENTED_PROPOSALS);
        enabled = store.getBoolean(ORDER_PROPOSALS);
        jcp.orderProposalsAlphabetically(enabled);
        enabled = store.getBoolean(ADD_INCLUDE);
        jcp.allowAddingIncludes(enabled);
    }

    public static void configure(ContentAssistant assistant, IPreferenceStore store) {
        CTextTools textTools = CUIPlugin.getDefault().getTextTools();
        CColorManager manager = textTools.getColorManager();
        boolean enabledDot = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
        boolean enabledArrow = store.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
        boolean enabledDoubleColon = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
        boolean enabled = enabledDot || enabledArrow || enabledDoubleColon;
        assistant.enableAutoActivation(enabled);
        int delay = store.getInt(AUTOACTIVATION_DELAY);
        assistant.setAutoActivationDelay(delay);
        delay = store.getInt(TIMEOUT_DELAY);
        Color c1 = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND, manager);
        assistant.setProposalSelectorForeground(c1);
        Color c2 = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND, manager);
        assistant.setProposalSelectorBackground(c2);
        Color c3 = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND, manager);
        assistant.setContextInformationPopupForeground(c3);
        assistant.setContextSelectorForeground(c3);
        Color c4 = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND, manager);
        assistant.setContextInformationPopupBackground(c4);
        assistant.setContextSelectorBackground(c4);
        enabled = store.getBoolean(AUTOINSERT);
        assistant.enableAutoInsert(enabled);
        enabled = store.getBoolean(CODEASSIST_PREFIX_COMPLETION);
        assistant.enablePrefixCompletion(enabled);
        ContentAssistPreference.configureCProcessor(assistant, store);
    }

    private static void changeCProcessor(ContentAssistant assistant, IPreferenceStore store, String key) {
        CCompletionProcessor2 jcp = ContentAssistPreference.getCProcessor(assistant);
        if (jcp == null) {
            return;
        }
        if (AUTOACTIVATION_TRIGGERS_DOT.equals(key) || AUTOACTIVATION_TRIGGERS_ARROW.equals(key) || AUTOACTIVATION_TRIGGERS_DOUBLECOLON.equals(key)) {
            boolean useDotAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
            boolean useArrowAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
            boolean useDoubleColonAsTrigger = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
            String triggers = "";
            if (useDotAsTrigger) {
                triggers = String.valueOf(triggers) + ".";
            }
            if (useArrowAsTrigger) {
                triggers = String.valueOf(triggers) + ">";
            }
            if (useDoubleColonAsTrigger) {
                triggers = String.valueOf(triggers) + ":";
            }
            jcp.setCompletionProposalAutoActivationCharacters(triggers.toCharArray());
        } else if (!SHOW_DOCUMENTED_PROPOSALS.equals(key)) {
            if (ORDER_PROPOSALS.equals(key)) {
                boolean enable = store.getBoolean(ORDER_PROPOSALS);
                jcp.orderProposalsAlphabetically(enable);
            } else if (ADD_INCLUDE.equals(key)) {
                boolean enabled = store.getBoolean(ADD_INCLUDE);
                jcp.allowAddingIncludes(enabled);
            }
        }
    }

    public static void changeConfiguration(ContentAssistant assistant, IPreferenceStore store, PropertyChangeEvent event) {
        String p = event.getProperty();
        if (AUTOACTIVATION_TRIGGERS_DOT.equals(p) || AUTOACTIVATION_TRIGGERS_ARROW.equals(p) || AUTOACTIVATION_TRIGGERS_DOUBLECOLON.equals(p)) {
            boolean enabledDot = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOT);
            boolean enabledArrow = store.getBoolean(AUTOACTIVATION_TRIGGERS_ARROW);
            boolean enabledDoubleColon = store.getBoolean(AUTOACTIVATION_TRIGGERS_DOUBLECOLON);
            boolean enabled = enabledDot || enabledArrow || enabledDoubleColon;
            assistant.enableAutoActivation(enabled);
        } else if (AUTOACTIVATION_DELAY.equals(p)) {
            int delay = store.getInt(AUTOACTIVATION_DELAY);
            assistant.setAutoActivationDelay(delay);
        } else if (PROPOSALS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_FOREGROUND);
            assistant.setProposalSelectorForeground(c);
        } else if (PROPOSALS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PROPOSALS_BACKGROUND);
            assistant.setProposalSelectorBackground(c);
        } else if (PARAMETERS_FOREGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_FOREGROUND);
            assistant.setContextInformationPopupForeground(c);
            assistant.setContextSelectorForeground(c);
        } else if (PARAMETERS_BACKGROUND.equals(p)) {
            Color c = ContentAssistPreference.getColor(store, PARAMETERS_BACKGROUND);
            assistant.setContextInformationPopupBackground(c);
            assistant.setContextSelectorBackground(c);
        } else if (AUTOINSERT.equals(p)) {
            boolean enabled = store.getBoolean(AUTOINSERT);
            assistant.enableAutoInsert(enabled);
        }
        ContentAssistPreference.changeCProcessor(assistant, store, p);
    }
}

