/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.contentassist;

import java.util.List;
import org.eclipse.cdt.core.dom.ast.ASTCompletionNode;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.ui.text.contentassist.CCompletionProposal;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.contentassist.ICompletionContributor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.swt.graphics.Image;

public class KeywordCompletionContributor
implements ICompletionContributor {
    private static String[] ckeywords = new String[]{"break", "const", "continue", "default", "double", "extern", "float", "inline", "register", "restrict", "return", "short", "signed", "sizeof", "static", "struct", "switch", "typedef", "union", "unsigned", "volatile", "while", "_Bool", "_Complex", "_Imaginary"};
    private static String[] cppkeywords = new String[]{"break", "catch", "class", "const", "const_cast", "continue", "default", "delete", "double", "dynamic_cast", "explicit", "export", "extern", "false", "float", "friend", "inline", "mutable", "namespace", "operator", "private", "protected", "public", "register", "reinterpret_cast", "return", "short", "signed", "sizeof", "static", "static_cast", "struct", "switch", "template", "throw", "typedef", "typeid", "typename", "union", "unsigned", "using", "virtual", "volatile", "wchar_t", "while"};

    public void contributeCompletionProposals(ITextViewer viewer, int offset, IWorkingCopy workingCopy, ASTCompletionNode completionNode, String prefix, List proposals) {
        if (prefix.length() == 0) {
            return;
        }
        if (!this.validContext(completionNode)) {
            return;
        }
        String[] keywords = cppkeywords;
        if (workingCopy != null && workingCopy.isCLanguage()) {
            keywords = ckeywords;
        }
        if (prefix.length() > 0) {
            int i = 0;
            while (i < keywords.length) {
                if (keywords[i].startsWith(prefix)) {
                    ImageDescriptor imagedesc = CElementImageProvider.getKeywordImageDescriptor();
                    Image image = imagedesc != null ? CUIPlugin.getImageDescriptorRegistry().get(imagedesc) : null;
                    int repLength = prefix.length();
                    int repOffset = offset - repLength;
                    proposals.add(new CCompletionProposal(keywords[i], repOffset, repLength, image, keywords[i], 1, viewer));
                }
                ++i;
            }
        }
    }

    private boolean validContext(ASTCompletionNode completionNode) {
        if (completionNode == null) {
            return true;
        }
        boolean valid = true;
        IASTName[] names = completionNode.getNames();
        int i = 0;
        while (i < names.length) {
            IASTName name = names[i];
            if (name.getTranslationUnit() != null) {
                if (name.getParent() instanceof IASTFieldReference) {
                    valid = false;
                } else {
                    return true;
                }
            }
            ++i;
        }
        return valid;
    }
}

