/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.folding;

import org.eclipse.cdt.internal.ui.text.folding.EmptyCFoldingPreferenceBlock;
import org.eclipse.cdt.ui.text.folding.ICFoldingPreferenceBlock;
import org.eclipse.cdt.ui.text.folding.ICFoldingStructureProvider;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.text.Assert;

public final class CFoldingStructureProviderDescriptor {
    private static final String PREFERENCES_CLASS = "preferencesClass";
    private static final String CLASS = "class";
    private static final String NAME = "name";
    private static final String ID = "id";
    private String fId;
    private String fName;
    private String fClass;
    private boolean fHasPreferences;
    private IConfigurationElement fElement;

    CFoldingStructureProviderDescriptor(IConfigurationElement element) {
        this.fElement = element;
        this.fId = element.getAttributeAsIs(ID);
        Assert.isLegal((this.fId != null ? 1 : 0) != 0);
        this.fName = element.getAttribute(NAME);
        if (this.fName == null) {
            this.fName = this.fId;
        }
        this.fClass = element.getAttributeAsIs(CLASS);
        Assert.isLegal((this.fClass != null ? 1 : 0) != 0);
        this.fHasPreferences = element.getAttributeAsIs(PREFERENCES_CLASS) != null;
    }

    public ICFoldingStructureProvider createProvider() throws CoreException {
        ICFoldingStructureProvider prov = (ICFoldingStructureProvider)this.fElement.createExecutableExtension(CLASS);
        return prov;
    }

    public ICFoldingPreferenceBlock createPreferences() throws CoreException {
        if (this.fHasPreferences) {
            ICFoldingPreferenceBlock prefs = (ICFoldingPreferenceBlock)this.fElement.createExecutableExtension(PREFERENCES_CLASS);
            return prefs;
        }
        return new EmptyCFoldingPreferenceBlock();
    }

    public String getId() {
        return this.fId;
    }

    public String getName() {
        return this.fName;
    }
}

