/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.viewsupport;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICContainer;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IMethod;
import org.eclipse.cdt.core.model.ISourceRoot;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.internal.corext.util.CModelUtil;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class CElementLabels {
    public static final int M_PARAMETER_TYPES = 1;
    public static final int M_PARAMETER_NAMES = 2;
    public static final int M_EXCEPTIONS = 4;
    public static final int M_APP_RETURNTYPE = 8;
    public static final int M_PRE_RETURNTYPE = 16;
    public static final int M_FULLY_QUALIFIED = 32;
    public static final int M_POST_QUALIFIED = 64;
    public static final int I_FULLY_QUALIFIED = 128;
    public static final int I_POST_QUALIFIED = 256;
    public static final int F_APP_TYPE_SIGNATURE = 512;
    public static final int F_PRE_TYPE_SIGNATURE = 1024;
    public static final int F_FULLY_QUALIFIED = 2048;
    public static final int F_POST_QUALIFIED = 4096;
    public static final int T_FULLY_QUALIFIED = 8192;
    public static final int T_CONTAINER_QUALIFIED = 16384;
    public static final int T_POST_QUALIFIED = 32768;
    public static final int D_QUALIFIED = 65536;
    public static final int D_POST_QUALIFIED = 131072;
    public static final int CF_QUALIFIED = 262144;
    public static final int CF_POST_QUALIFIED = 524288;
    public static final int CU_QUALIFIED = 0x100000;
    public static final int CU_POST_QUALIFIED = 0x200000;
    public static final int P_QUALIFIED = 0x400000;
    public static final int P_POST_QUALIFIED = 0x800000;
    public static final int ROOT_VARIABLE = 0x1000000;
    public static final int ROOT_QUALIFIED = 0x2000000;
    public static final int ROOT_POST_QUALIFIED = 0x4000000;
    public static final int APPEND_ROOT_PATH = 0x8000000;
    public static final int PREPEND_ROOT_PATH = 0x10000000;
    public static final int P_COMPRESSED = 0x20000000;
    public static final int REFERENCED_ROOT_POST_QUALIFIED = 0x40000000;
    public static final int ALL_FULLY_QUALIFIED = 39135392;
    public static final int ALL_POST_QUALIFIED = 78287168;
    public static final int ALL_DEFAULT = 1;
    public static final int DEFAULT_QUALIFIED = 1386656;
    public static final int DEFAULT_POST_QUALIFIED = 2789696;
    public static final String CONCAT_STRING = CUIMessages.getString("CElementLabels.concat_string");
    public static final String COMMA_STRING = CUIMessages.getString("CElementLabels.comma_string");
    public static final String DECL_STRING = CUIMessages.getString("CElementLabels.declseparator_string");
    static /* synthetic */ Class class$0;

    public static String getTextLabel(Object obj, int flags) {
        if (obj instanceof ICElement) {
            return CElementLabels.getElementLabel((ICElement)obj, flags);
        }
        if (obj instanceof IAdaptable) {
            IWorkbenchAdapter wbadapter;
            IAdaptable iAdaptable = (IAdaptable)obj;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbadapter = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return wbadapter.getLabel(obj);
            }
        }
        return "";
    }

    public static String getElementLabel(ICElement element, int flags) {
        StringBuffer buf = new StringBuffer(60);
        CElementLabels.getElementLabel(element, flags, buf);
        return buf.toString();
    }

    public static void getElementLabel(ICElement element, int flags, StringBuffer buf) {
        int type = element.getElementType();
        ISourceRoot root = null;
        if (!(type == 10 || type == 11 || type == 12 && element instanceof ISourceRoot)) {
            root = CModelUtil.getSourceRoot(element);
        }
        if (root != null && CElementLabels.getFlag(flags, 0x10000000)) {
            CElementLabels.getSourceRootLabel(root, 0x2000000, buf);
            buf.append(CONCAT_STRING);
        }
        switch (type) {
            case 70: {
                CElementLabels.getMethodLabel((IMethod)element, flags, buf);
                break;
            }
            case 63: 
            case 65: 
            case 67: 
            case 69: {
                CElementLabels.getTypeLabel(element, flags, buf);
                break;
            }
            case 60: {
                CElementLabels.getTranslationUnitLabel((ITranslationUnit)element, flags, buf);
                break;
            }
            case 12: {
                ICContainer container = (ICContainer)element;
                if (container instanceof ISourceRoot) {
                    CElementLabels.getSourceRootLabel((ISourceRoot)container, flags, buf);
                    break;
                }
                CElementLabels.getContainerLabel(container, flags, buf);
                break;
            }
            case 10: 
            case 11: {
                buf.append(element.getElementName());
                break;
            }
            default: {
                buf.append(element.getElementName());
            }
        }
        if (root != null && CElementLabels.getFlag(flags, 0x8000000)) {
            buf.append(CONCAT_STRING);
            CElementLabels.getSourceRootLabel(root, 0x2000000, buf);
        }
        if (element instanceof IBinary) {
            IBinary bin = (IBinary)element;
            buf.append(" - [" + bin.getCPU() + (bin.isLittleEndian() ? "le" : "be") + "]");
        }
    }

    public static void getMethodLabel(IMethod method, int flags, StringBuffer buf) {
        try {
            String[] types;
            ICElement parent;
            if (CElementLabels.getFlag(flags, 16) && method.exists() && !method.isConstructor()) {
                buf.append(method.getReturnType());
                buf.append(' ');
            }
            if (CElementLabels.getFlag(flags, 32) && (parent = method.getParent()) != null && parent.exists()) {
                CElementLabels.getTypeLabel(parent, 0x2000 | flags & 0x20000000, buf);
                buf.append("::");
            }
            buf.append(method.getElementName());
            if (CElementLabels.getFlag(flags, 3)) {
                buf.append('(');
                types = CElementLabels.getFlag(flags, 1) ? method.getParameterTypes() : null;
                String[] names = null;
                int nParams = types != null ? types.length : names.length;
                int i = 0;
                while (i < nParams) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    if (types != null) {
                        buf.append(types[i]);
                    }
                    if (names != null) {
                        if (types != null) {
                            buf.append(' ');
                        }
                        buf.append(names[i]);
                    }
                    ++i;
                }
                buf.append(')');
            }
            if (CElementLabels.getFlag(flags, 4) && method.exists() && (types = method.getExceptions()).length > 0) {
                buf.append(" throw( ");
                int i = 0;
                while (i < types.length) {
                    if (i > 0) {
                        buf.append(COMMA_STRING);
                    }
                    buf.append(types[i]);
                    ++i;
                }
                buf.append(" )");
            }
            if (CElementLabels.getFlag(flags, 8) && method.exists() && !method.isConstructor()) {
                buf.append(DECL_STRING);
                buf.append(method.getReturnType());
            }
            if (CElementLabels.getFlag(flags, 64)) {
                buf.append(CONCAT_STRING);
                CElementLabels.getTypeLabel(method.getParent(), 0x2000 | flags & 0x20000000, buf);
            }
        }
        catch (CModelException e) {
            CUIPlugin.getDefault().log(e);
        }
    }

    public static void getSourceRootLabel(ISourceRoot root, int flags, StringBuffer buf) {
        CElementLabels.getFolderLabel((ICContainer)root, flags, buf);
    }

    public static void getContainerLabel(ICContainer container, int flags, StringBuffer buf) {
        CElementLabels.getFolderLabel(container, flags, buf);
    }

    private static void getFolderLabel(ICContainer container, int flags, StringBuffer buf) {
        boolean referencedQualified;
        IResource resource = container.getResource();
        boolean rootQualified = CElementLabels.getFlag(flags, 0x2000000);
        boolean bl = referencedQualified = CElementLabels.getFlag(flags, 0x40000000) && container instanceof ISourceRoot && CModelUtil.isReferenced((ISourceRoot)container) && resource != null;
        if (rootQualified) {
            buf.append(container.getPath().makeRelative().toString());
        } else {
            buf.append(container.getElementName());
            if (referencedQualified) {
                buf.append(CONCAT_STRING);
                buf.append(resource.getProject().getName());
            } else if (CElementLabels.getFlag(flags, 0x4000000)) {
                buf.append(CONCAT_STRING);
                buf.append(container.getParent().getElementName());
            }
        }
    }

    public static void getTranslationUnitLabel(ITranslationUnit tu, int flags, StringBuffer buf) {
        if (CElementLabels.getFlag(flags, 0x100000)) {
            ISourceRoot root = CModelUtil.getSourceRoot((ICElement)tu);
            buf.append(root.getElementName());
            buf.append('.');
        }
        buf.append(tu.getElementName());
        if (CElementLabels.getFlag(flags, 0x200000)) {
            buf.append(CONCAT_STRING);
            CElementLabels.getSourceRootLabel((ISourceRoot)tu.getParent(), 0, buf);
        }
    }

    public static void getTypeLabel(ICElement elem, int flags, StringBuffer buf) {
        String typeName;
        ISourceRoot root;
        if (CElementLabels.getFlag(flags, 8192) && (root = CModelUtil.getSourceRoot(elem)) != null) {
            CElementLabels.getSourceRootLabel(root, flags & 0x20000000, buf);
            buf.append(root.getElementName());
            buf.append('.');
        }
        if ((typeName = elem.getElementName()).length() == 0) {
            typeName = CUIMessages.getString("CElementLabels.anonymous");
        }
        buf.append(typeName);
    }

    private static boolean getFlag(int flags, int flag) {
        return (flags & flag) != 0;
    }
}

