/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.classwizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.browser.ITypeInfo;
import org.eclipse.cdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardMessages;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardPrefs;
import org.eclipse.cdt.internal.ui.wizards.classwizard.NewClassWizardUtil;
import org.eclipse.cdt.ui.browser.typeinfo.TypeSelectionDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class NewBaseClassSelectionDialog
extends TypeSelectionDialog {
    private static final String DIALOG_SETTINGS;
    private static final int[] VISIBLE_TYPES;
    private static final int ADD_ID = 1025;
    private List fTypeList;
    private List fTypeListeners;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.cdt.internal.ui.wizards.classwizard.NewBaseClassSelectionDialog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DIALOG_SETTINGS = clazz.getName();
        VISIBLE_TYPES = new int[]{65, 67};
    }

    public NewBaseClassSelectionDialog(Shell parent) {
        super(parent);
        this.setTitle(NewClassWizardMessages.getString("NewBaseClassSelectionDialog.title"));
        this.setMessage(NewClassWizardMessages.getString("NewBaseClassSelectionDialog.message"));
        this.setDialogSettings(DIALOG_SETTINGS);
        this.setVisibleTypes(VISIBLE_TYPES);
        this.setFilter("*", true);
        this.setStatusLineAboveButtons(true);
        this.fTypeList = new ArrayList();
        this.fTypeListeners = new ArrayList();
    }

    public void addListener(ITypeSelectionListener listener) {
        if (!this.fTypeListeners.contains(listener)) {
            this.fTypeListeners.add(listener);
        }
    }

    public void removeListener(ITypeSelectionListener listener) {
        this.fTypeListeners.remove(listener);
    }

    private void notifyTypeAddedListeners(ITypeInfo type) {
        ArrayList list = new ArrayList(this.fTypeListeners);
        Iterator i = list.iterator();
        while (i.hasNext()) {
            ITypeSelectionListener listener = (ITypeSelectionListener)i.next();
            listener.typeAdded(type);
        }
    }

    public ITypeInfo[] getAddedTypes() {
        return this.fTypeList.toArray(new ITypeInfo[this.fTypeList.size()]);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, NewClassWizardMessages.getString("NewBaseClassSelectionDialog.addButton.label"), true);
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.addType(this.getLowerSelectedElement());
        }
        super.buttonPressed(buttonId);
    }

    protected void okPressed() {
        this.addType(this.getLowerSelectedElement());
        super.okPressed();
    }

    private void addType(Object elem) {
        if (elem instanceof ITypeInfo) {
            ITypeInfo type = (ITypeInfo)elem;
            if (this.fTypeList.contains(type)) {
                String qualifiedName = type.getQualifiedTypeName().getFullyQualifiedName();
                String message = NewClassWizardMessages.getFormattedString("NewBaseClassSelectionDialog.classalreadyadded.info", qualifiedName);
                this.updateStatus(new StatusInfo(1, message));
            } else {
                String qualifiedName = type.getQualifiedTypeName().getFullyQualifiedName();
                String message = NewClassWizardMessages.getFormattedString("NewBaseClassSelectionDialog.addingclass.info", qualifiedName);
                this.updateStatus(new StatusInfo(1, message));
                boolean canAdd = true;
                if (this.verifyBaseClasses()) {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    NewClassWizardUtil.resolveClassLocation(type, (IRunnableContext)service);
                    boolean bl = canAdd = type.getResolvedReference() != null;
                }
                if (canAdd) {
                    this.fTypeList.add(type);
                    message = NewClassWizardMessages.getFormattedString("NewBaseClassSelectionDialog.classadded.info", qualifiedName);
                    this.updateStatus(new StatusInfo(1, message));
                    this.notifyTypeAddedListeners(type);
                } else {
                    message = NewClassWizardMessages.getFormattedString("NewBaseClassSelectionDialog.error.classnotadded", qualifiedName);
                    this.updateStatus(new StatusInfo(4, message));
                }
            }
        }
    }

    public boolean verifyBaseClasses() {
        return NewClassWizardPrefs.verifyBaseClasses();
    }

    protected void handleDefaultSelected() {
        if (this.validateCurrentSelection()) {
            this.buttonPressed(1025);
        }
    }

    public static interface ITypeSelectionListener {
        public void typeAdded(ITypeInfo var1);
    }
}

