/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.IBinary;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.IFunctionDeclaration;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ITemplate;
import org.eclipse.cdt.core.model.ITypeDef;
import org.eclipse.cdt.core.model.IVariableDeclaration;
import org.eclipse.cdt.internal.ui.viewsupport.CElementImageProvider;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class CElementLabelProvider
extends LabelProvider {
    public static final int SHOW_RETURN_TYPE = 1;
    public static final int SHOW_PARAMETERS = 2;
    public static final int SHOW_EXCEPTION = 4;
    public static final int SHOW_SMALL_ICONS = 256;
    public static final int SHOW_OVERLAY_ICONS = 16;
    public static final int SHOW_QUALIFIED = 1024;
    public static final int SHOW_POST_QUALIFIED = 2048;
    public static final int SHOW_BASICS = 0;
    public static final int SHOW_DEFAULT = new Integer(18);
    private WorkbenchLabelProvider fWorkbenchLabelProvider = new WorkbenchLabelProvider();
    protected CElementImageProvider fImageLabelProvider = new CElementImageProvider();
    private int fFlags;
    private int fImageFlags;
    private int fTextFlags;

    public CElementLabelProvider() {
        this(SHOW_DEFAULT);
    }

    public CElementLabelProvider(int flags) {
        this.fFlags = flags;
    }

    public String getText(Object element) {
        if (element instanceof ICElement) {
            try {
                ICElement celem = (ICElement)element;
                StringBuffer name = new StringBuffer();
                switch (celem.getElementType()) {
                    case 72: 
                    case 76: 
                    case 77: {
                        IVariableDeclaration vDecl = (IVariableDeclaration)celem;
                        name.append(vDecl.getElementName());
                        if (vDecl.getTypeName() == null || vDecl.getTypeName().length() <= 0) break;
                        name.append(" : ");
                        name.append(vDecl.getTypeName());
                        break;
                    }
                    case 70: 
                    case 71: 
                    case 73: 
                    case 74: {
                        IFunctionDeclaration fDecl = (IFunctionDeclaration)celem;
                        name.append(fDecl.getSignature());
                        if (fDecl.getReturnType() == null || fDecl.getReturnType().length() <= 0) break;
                        name.append(" : ");
                        name.append(fDecl.getReturnType());
                        break;
                    }
                    case 63: 
                    case 67: 
                    case 69: {
                        if (celem.getElementName() != null && celem.getElementName().length() > 0) {
                            name.append(celem.getElementName());
                            break;
                        }
                        if (!(celem instanceof IVariableDeclaration)) break;
                        IVariableDeclaration varDecl = (IVariableDeclaration)celem;
                        name.append(varDecl.getTypeName());
                        break;
                    }
                    case 80: {
                        ITypeDef tDecl = (ITypeDef)celem;
                        name.append(tDecl.getElementName());
                        if (tDecl.getTypeName() == null || tDecl.getTypeName().length() <= 0) break;
                        name.append(" : ");
                        name.append(tDecl.getTypeName());
                        break;
                    }
                    case 61: {
                        if (celem.getElementName() != null && celem.getElementName().length() > 0) {
                            name.append(celem.getElementName());
                            break;
                        }
                        if (!(celem instanceof INamespace)) break;
                        INamespace nDecl = (INamespace)celem;
                        name.append(nDecl.getTypeName());
                        break;
                    }
                    case 83: 
                    case 85: 
                    case 87: 
                    case 89: 
                    case 91: 
                    case 92: {
                        ITemplate template = (ITemplate)celem;
                        String signature = template.getTemplateSignature();
                        name.append(signature);
                        break;
                    }
                    default: {
                        name.append(celem.getElementName());
                    }
                }
                if (celem instanceof IBinary) {
                    IBinary bin = (IBinary)celem;
                    name.append(" - [" + bin.getCPU() + (bin.isLittleEndian() ? "le" : "be") + "]");
                }
                return name.toString();
            }
            catch (CModelException e) {
                CUIPlugin.getDefault().log(e);
            }
        }
        return this.fWorkbenchLabelProvider.getText(element);
    }

    public Image getImage(Object element) {
        return this.fImageLabelProvider.getImageLabel(element, this.getImageFlags());
    }

    public void dispose() {
        if (this.fWorkbenchLabelProvider != null) {
            this.fWorkbenchLabelProvider.dispose();
            this.fWorkbenchLabelProvider = null;
        }
        if (this.fImageLabelProvider != null) {
            this.fImageLabelProvider.dispose();
        }
    }

    private boolean getFlag(int flag) {
        return (this.fFlags & flag) != 0;
    }

    public int getImageFlags() {
        this.fImageFlags = 0;
        if (this.getFlag(16)) {
            this.fImageFlags |= 1;
        }
        if (this.getFlag(256)) {
            this.fImageFlags |= 2;
        }
        return this.fImageFlags;
    }

    public int getTextFlags() {
        this.fTextFlags = 0;
        if (this.getFlag(1)) {
            this.fTextFlags |= 8;
        }
        if (this.getFlag(2)) {
            this.fTextFlags |= 1;
        }
        if (this.getFlag(4)) {
            this.fTextFlags |= 4;
        }
        if (this.getFlag(2048)) {
            this.fTextFlags |= 0x40;
        }
        return this.fTextFlags;
    }
}

