/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.search.IMatch;
import org.eclipse.cdt.internal.ui.CPluginImages;
import org.eclipse.cdt.internal.ui.search.CSearchMessages;
import org.eclipse.cdt.internal.ui.search.CSearchResultPage;
import org.eclipse.cdt.ui.CElementImageDescriptor;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class CSearchResultLabelProvider
extends LabelProvider {
    public static final int SHOW_NAME_ONLY = 0;
    public static final int SHOW_ELEMENT_CONTAINER = 1;
    public static final int SHOW_CONTAINER_ELEMENT = 2;
    public static final int SHOW_PATH = 3;
    public static final String POTENTIAL_MATCH = CSearchMessages.getString("CSearchResultLabelProvider.potentialMatch");
    private int _sortOrder;
    private int _textFlags;
    private int _imageFlags;
    private static final Point SMALL_SIZE = new Point(16, 16);

    public CSearchResultLabelProvider() {
        this._sortOrder = 3;
    }

    public CSearchResultLabelProvider(CSearchResultPage page) {
    }

    public Image getImage(Object element) {
        IMatch match = null;
        int elementType = -1;
        int visibility = -1;
        if (element instanceof IMatch) {
            match = (IMatch)element;
            if (match == null) {
                return null;
            }
            elementType = match.getElementType();
            visibility = match.getVisibility();
        } else if (element instanceof ICElement) {
            elementType = ((ICElement)element).getElementType();
        } else if (element instanceof String) {
            String eleString = (String)element;
            int elIndex = eleString.indexOf("ELEMENTTYPE:");
            int vizIndex = eleString.indexOf("VISIBILITY:");
            String elType = eleString.substring(elIndex + 12, vizIndex);
            String elViz = eleString.substring(vizIndex + 11, eleString.length());
            elementType = new Integer(elType);
            visibility = new Integer(elViz);
        } else if (element instanceof IPath) {
            elementType = 60;
        }
        int flags = 0;
        Object imageDescriptor = null;
        block0 : switch (elementType) {
            case 11: {
                imageDescriptor = CPluginImages.DESC_OBJS_SEARCHHIERPROJECT;
                break;
            }
            case 12: {
                imageDescriptor = CPluginImages.DESC_OBJS_SEARCHHIERFODLER;
                break;
            }
            case 65: {
                imageDescriptor = CPluginImages.DESC_OBJS_CLASS;
                break;
            }
            case 67: {
                imageDescriptor = CPluginImages.DESC_OBJS_STRUCT;
                break;
            }
            case 69: {
                imageDescriptor = CPluginImages.DESC_OBJS_UNION;
                break;
            }
            case 61: {
                imageDescriptor = CPluginImages.DESC_OBJS_NAMESPACE;
                break;
            }
            case 63: {
                imageDescriptor = CPluginImages.DESC_OBJS_ENUMERATION;
                break;
            }
            case 79: {
                imageDescriptor = CPluginImages.DESC_OBJS_MACRO;
                break;
            }
            case 74: {
                imageDescriptor = CPluginImages.DESC_OBJS_FUNCTION;
                break;
            }
            case 76: {
                imageDescriptor = CPluginImages.DESC_OBJS_VARIABLE;
                break;
            }
            case 81: {
                imageDescriptor = CPluginImages.DESC_OBJS_ENUMERATOR;
                break;
            }
            case 80: {
                imageDescriptor = CPluginImages.DESC_OBJS_TYPEDEF;
                break;
            }
            case 60: {
                imageDescriptor = CPluginImages.DESC_OBJS_TUNIT;
                break;
            }
            case 72: {
                switch (visibility) {
                    case 8192: {
                        imageDescriptor = CPluginImages.DESC_OBJS_PUBLIC_FIELD;
                        break block0;
                    }
                    case 4096: {
                        imageDescriptor = CPluginImages.DESC_OBJS_PRIVATE_FIELD;
                        break block0;
                    }
                }
                imageDescriptor = CPluginImages.DESC_OBJS_PROTECTED_FIELD;
                break;
            }
            case 70: {
                switch (visibility) {
                    case 8192: {
                        imageDescriptor = CPluginImages.DESC_OBJS_PUBLIC_METHOD;
                        break block0;
                    }
                    case 4096: {
                        imageDescriptor = CPluginImages.DESC_OBJS_PRIVATE_METHOD;
                        break block0;
                    }
                }
                imageDescriptor = CPluginImages.DESC_OBJS_PROTECTED_METHOD;
                break;
            }
            case 83: {
                imageDescriptor = CPluginImages.DESC_OBJS_CLASS;
                flags |= 1;
                break;
            }
            default: {
                imageDescriptor = CPluginImages.DESC_OBJS_UNKNOWN;
            }
        }
        if (match != null) {
            if (match.isStatic()) {
                flags |= 8;
            }
            if (match.isConst()) {
                flags |= 2;
            }
            if (match.isVolatile()) {
                flags |= 4;
            }
        }
        imageDescriptor = new CElementImageDescriptor((ImageDescriptor)imageDescriptor, flags, SMALL_SIZE);
        Image image = CUIPlugin.getImageDescriptorRegistry().get((ImageDescriptor)imageDescriptor);
        return image;
    }

    public String getText(Object element) {
        IMatch match = null;
        if (element instanceof IMatch) {
            match = (IMatch)element;
        } else {
            if (element instanceof ICElement) {
                return this.getElementText((ICElement)element);
            }
            if (element instanceof String) {
                String elString = (String)element;
                int parentIndex = elString.indexOf("PARENT:");
                int nameIndex = elString.indexOf("NAME:");
                int locationIndex = elString.indexOf("LOCATION:");
                int elementIndex = elString.indexOf("ELEMENTTYPE:");
                String elParent = elString.substring(parentIndex + 7, nameIndex);
                String elName = elString.substring(nameIndex + 5, locationIndex);
                String elPath = elString.substring(locationIndex + 9, elementIndex);
                return this.getCSearchSortElementText(elParent, elName, elPath);
            }
            if (element instanceof IPath) {
                return ((IPath)element).toOSString();
            }
        }
        if (match == null) {
            return "";
        }
        IResource resource = match.getResource();
        String result = "";
        String path = "";
        if (resource != null) {
            path = resource.isLinked() ? match.getLocation().toOSString() : resource.getFullPath().toOSString();
        }
        switch (this.getOrder()) {
            case 0: {
                result = match.getName();
            }
            case 1: {
                if (!match.getParentName().equals("")) {
                    result = String.valueOf(match.getName()) + " - " + match.getParentName() + " ( " + path + " )";
                    break;
                }
                result = String.valueOf(match.getName()) + " ( " + path + " )";
                break;
            }
            case 3: {
                result = String.valueOf(path) + " - " + match.getParentName() + "::" + match.getName();
                break;
            }
            case 2: {
                result = String.valueOf(match.getParentName()) + "::" + match.getName() + " ( " + path + " )";
            }
        }
        return result;
    }

    private String getCSearchSortElementText(String parentName, String name, String path) {
        String result = "";
        switch (this.getOrder()) {
            case 0: {
                result = name;
            }
            case 1: {
                if (!parentName.equals("")) {
                    result = String.valueOf(name) + " - " + parentName + " ( " + path + " )";
                    break;
                }
                result = String.valueOf(name) + " ( " + path + " )";
                break;
            }
            case 3: {
                result = String.valueOf(path) + " - " + parentName + "::" + name;
                break;
            }
            case 2: {
                result = String.valueOf(parentName) + "::" + name + " ( " + path + " )";
            }
        }
        return result;
    }

    private String getElementText(ICElement element) {
        String result = "";
        element.getParent();
        result = String.valueOf(element.getElementName()) + " ( " + element.getPath() + " )";
        return result;
    }

    public int getOrder() {
        return this._sortOrder;
    }

    public void setOrder(int orderFlag) {
        this._sortOrder = orderFlag;
    }
}

