/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.INamespace;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.ui.CElementGrouping;
import org.eclipse.cdt.ui.IncludesGrouping;

public class NamespacesGrouping
extends CElementGrouping {
    protected ITranslationUnit fUnit;
    protected String fName;
    protected INamespace[] fNamespaces;

    public NamespacesGrouping(ITranslationUnit unit, INamespace namespace) {
        super(16);
        this.fUnit = unit;
        this.fNamespaces = new INamespace[]{namespace};
        this.fName = namespace.getElementName();
    }

    public String getLabel(Object object) {
        return this.fName;
    }

    public Object[] getChildren(Object object) {
        ArrayList<ICElement> list = new ArrayList<ICElement>();
        int i = 0;
        while (i < this.fNamespaces.length) {
            INamespace nspace = this.fNamespaces[i];
            try {
                ICElement[] objs = nspace.getChildren();
                list.addAll(Arrays.asList(objs));
            }
            catch (CModelException cModelException) {}
            ++i;
        }
        return list.toArray();
    }

    public Object getParent(Object object) {
        return this.fUnit;
    }

    public void addNamespace(INamespace nspace) {
        INamespace[] newNS = new INamespace[this.fNamespaces.length + 1];
        System.arraycopy(this.fNamespaces, 0, newNS, 0, this.fNamespaces.length);
        newNS[this.fNamespaces.length] = nspace;
        this.fNamespaces = newNS;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IncludesGrouping) {
            return this.fUnit.equals(((IncludesGrouping)((Object)obj)).getParent(obj));
        }
        if (obj instanceof NamespacesGrouping) {
            NamespacesGrouping other = (NamespacesGrouping)((Object)obj);
            return this.fUnit.equals(other.getParent(obj)) && this.fName.equals(other.getLabel(obj));
        }
        return super.equals(obj);
    }
}

