/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.actions;

import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.internal.ui.actions.SelectionConverter;
import org.eclipse.cdt.internal.ui.editor.CEditorMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.texteditor.ITextEditor;

public class ShowInCViewAction
extends SelectionProviderAction {
    private IWorkbenchPage page;
    private ITextEditor fEditor;

    public ShowInCViewAction(IWorkbenchSite site) {
        this(site.getPage(), site.getSelectionProvider());
    }

    public ShowInCViewAction(ITextEditor editor) {
        this(editor.getEditorSite().getWorkbenchWindow().getActivePage(), editor.getSelectionProvider());
        this.fEditor = editor;
    }

    public ShowInCViewAction(IWorkbenchPage page, ISelectionProvider viewer) {
        super(viewer, CEditorMessages.getString("ShowInCView.label"));
        this.setToolTipText(CEditorMessages.getString("ShowInCView.tooltip"));
        this.setDescription(CEditorMessages.getString("ShowInCView.description"));
        this.page = page;
        this.setDescription(CEditorMessages.getString("ShowInCView.toolTip"));
    }

    public void run() {
        ISelection selection = this.getSelection();
        if (selection instanceof ITextSelection) {
            this.run(this.fEditor);
        } else if (selection instanceof IStructuredSelection) {
            this.run((IStructuredSelection)selection);
        }
    }

    public void run(IStructuredSelection selection) {
        if (this.page == null) {
            this.page = CUIPlugin.getActivePage();
            if (this.page == null) {
                return;
            }
        }
        try {
            IViewPart part = this.page.showView("org.eclipse.cdt.ui.CView");
            if (part instanceof ISetSelectionTarget) {
                ((ISetSelectionTarget)part).selectReveal((ISelection)selection);
            }
        }
        catch (PartInitException partInitException) {}
    }

    public void run(ITextEditor editor) {
        if (editor != null) {
            try {
                ICElement celement = SelectionConverter.getElementAtOffset(editor);
                if (celement != null) {
                    this.run((IStructuredSelection)new StructuredSelection((Object)celement));
                }
            }
            catch (CModelException cModelException) {}
        }
    }

    public void selectionChanged(IStructuredSelection selection) {
        this.setEnabled(!this.getSelection().isEmpty());
    }
}

