/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.ICDescriptor;
import org.eclipse.cdt.core.ICDescriptorOperation;
import org.eclipse.cdt.core.dom.PDOM;
import org.eclipse.cdt.internal.core.index.domsourceindexer.DOMSourceIndexer;
import org.eclipse.cdt.internal.core.index.nullindexer.NullIndexer;
import org.eclipse.cdt.internal.ui.CUIMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.dialogs.AbstractCOptionPage;
import org.eclipse.cdt.ui.dialogs.ICOptionContainer;
import org.eclipse.cdt.ui.dialogs.ICOptionPage;
import org.eclipse.cdt.ui.index.AbstractIndexerPage;
import org.eclipse.cdt.utils.ui.controls.ControlFactory;
import org.eclipse.cdt.utils.ui.controls.TabFolderLayout;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class IndexerBlock
extends AbstractCOptionPage {
    public static final String INDEX_UI_ID = "org.eclipse.cdt.ui.cdtindexers";
    public static final String INDEXERUIID = "indexerUIID";
    public static final QualifiedName indexerUIIDKey = new QualifiedName("org.eclipse.cdt.ui.cdtindexers", "indexerUIID");
    public static final String INDEXER_UI = "indexerUI";
    public static final String INDEXER_UI_VALUE = "indexerUIValue";
    private static final String INDEXER_LABEL = CUIPlugin.getResourceString("BaseIndexerBlock.label");
    private static final String INDEXER_DESCRIPTION = CUIPlugin.getResourceString("BaseIndexerBlock.desc");
    private static final String INDEXER_COMBO_LABEL = CUIPlugin.getResourceString("BaseIndexerBlock.comboLabel");
    private static final String INDEXER_USE_PDOM = CUIPlugin.getResourceString("BaseIndexerBlock.usePDOM");
    private Button indexerUsePDOM;
    private Combo indexersComboBox;
    private HashMap indexerPageMap;
    private List indexerPageList;
    private String selectedIndexerId = null;
    private Composite parentComposite;
    private ICOptionPage currentPage;
    int nullIndexerIndex;
    String initialSelected;
    private IPreferenceStore prefStore = CUIPlugin.getDefault().getPreferenceStore();
    boolean initialPDOMChecked;
    boolean pdomChecked;

    public IndexerBlock() {
        super(INDEXER_LABEL);
        this.setDescription(INDEXER_DESCRIPTION);
        this.initializeIndexerPageMap();
    }

    public void createControl(Composite parent) {
        Composite composite = ControlFactory.createComposite(parent, 1);
        Font font = parent.getFont();
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 768;
        composite.setLayoutData(null);
        composite.setFont(font);
        this.setControl((Control)composite);
        Composite scComp = ControlFactory.createComposite(composite, 1);
        ((GridLayout)scComp.getLayout()).marginHeight = 0;
        ((GridLayout)scComp.getLayout()).marginTop = 5;
        scComp.setFont(font);
        if (this.createIndexerControls(scComp)) {
            Composite indexPageComposite = ControlFactory.createComposite(composite, 1);
            indexPageComposite.setFont(font);
            indexPageComposite.setLayoutData((Object)new GridData(4, 4, true, true));
            indexPageComposite.setLayout((Layout)new TabFolderLayout());
            this.parentComposite = indexPageComposite;
            this.setPage();
        }
        parent.layout(true);
    }

    private void setPage() {
        String profileId = this.getCurrentIndexPageId();
        if (profileId == null) {
            return;
        }
        ICOptionPage page = this.getIndexerPage(profileId);
        if (page != null) {
            if (page.getControl() == null) {
                page.setContainer(this.getContainer());
                page.createControl(this.parentComposite);
                this.parentComposite.layout(true);
            }
            if (this.currentPage != null) {
                this.currentPage.setVisible(false);
            }
            page.setVisible(true);
        }
        this.setCurrentPage(page);
        if (page instanceof AbstractIndexerPage) {
            ((AbstractIndexerPage)page).loadPreferences();
        }
    }

    private void setCurrentPage(ICOptionPage page) {
        this.currentPage = page;
    }

    protected String getCurrentIndexPageId() {
        String selectedIndexPageName = this.getSelectedIndexerID();
        if (selectedIndexPageName == null) {
            return null;
        }
        String selectedIndexPageId = this.getIndexerPageId(selectedIndexPageName);
        return selectedIndexPageId;
    }

    private boolean createIndexerControls(Composite parent) {
        this.indexerUsePDOM = new Button(parent, 32);
        this.indexerUsePDOM.setText(INDEXER_USE_PDOM);
        this.indexerUsePDOM.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (IndexerBlock.this.indexerUsePDOM.getSelection()) {
                    IndexerBlock.this.pdomChecked = true;
                    IndexerBlock.this.indexersComboBox.select(IndexerBlock.this.nullIndexerIndex);
                    IndexerBlock.this.setPage();
                    IndexerBlock.this.indexersComboBox.setEnabled(false);
                } else {
                    IndexerBlock.this.pdomChecked = false;
                    IndexerBlock.this.indexersComboBox.setEnabled(true);
                }
            }
        });
        this.pdomChecked = this.initialPDOMChecked = this.prefStore.getBoolean("usePDOM");
        this.indexerUsePDOM.setSelection(this.initialPDOMChecked);
        Group group = ControlFactory.createGroup(parent, INDEXER_COMBO_LABEL, 2);
        this.indexersComboBox = ControlFactory.createSelectCombo((Composite)group, "", "");
        this.indexersComboBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IndexerBlock.this.setPage();
            }
        });
        GridData gridData = (GridData)this.indexersComboBox.getLayoutData();
        gridData.verticalSpan = 2;
        Iterator items = this.getIndexerPageIdList().iterator();
        while (items.hasNext()) {
            String profileId = (String)items.next();
            String pageName = this.getIndexerPageName(profileId);
            if (pageName == null) continue;
            this.indexersComboBox.add(pageName);
        }
        String indexerId = this.prefStore.getString("indexer");
        String preferredIndexer = null;
        preferredIndexer = indexerId.equals("") ? this.getIndexerPageName(DOMSourceIndexer.ID) : this.getIndexerPageName(indexerId);
        String[] indexerList = this.indexersComboBox.getItems();
        int selectedIndex = 0;
        int i = 0;
        while (i < indexerList.length) {
            if (indexerList[i].equals(preferredIndexer)) {
                selectedIndex = i;
            }
            ++i;
        }
        this.indexersComboBox.select(selectedIndex);
        return true;
    }

    private void initializeIndexerPageMap() {
        this.indexerPageMap = new HashMap(5);
        this.indexerPageList = new ArrayList(5);
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(CUIPlugin.getPluginId(), "IndexerPage");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < infos.length) {
            if (infos[i].getName().equals(INDEXER_UI)) {
                String id = infos[i].getAttribute("indexerID");
                if (NullIndexer.ID.equals(id)) {
                    this.nullIndexerIndex = i;
                }
                this.indexerPageMap.put(id, new IndexerPageConfiguration(infos[i]));
                this.indexerPageList.add(id);
            }
            ++i;
        }
    }

    protected List getIndexerPageIdList() {
        return this.indexerPageList;
    }

    protected String getIndexerPageName(String indexerPageId) {
        IndexerPageConfiguration configElement = (IndexerPageConfiguration)this.indexerPageMap.get(indexerPageId);
        if (configElement != null) {
            return configElement.getName();
        }
        return null;
    }

    protected String getIndexerPageId(String indexerPageName) {
        Iterator I = this.indexerPageMap.keySet().iterator();
        while (I.hasNext()) {
            String indexerPageId = (String)I.next();
            String tempPageName = this.getIndexerPageName(indexerPageId);
            if (!indexerPageName.equals(tempPageName)) continue;
            return indexerPageId;
        }
        return null;
    }

    protected ICOptionPage getIndexerPage(String indexerPageId) {
        IndexerPageConfiguration configElement = (IndexerPageConfiguration)this.indexerPageMap.get(indexerPageId);
        if (configElement != null) {
            try {
                return configElement.getPage();
            }
            catch (CoreException coreException) {}
        }
        return null;
    }

    protected String getIndexerIdName(String indexerPageId) {
        IndexerPageConfiguration configElement = (IndexerPageConfiguration)this.indexerPageMap.get(indexerPageId);
        if (configElement != null) {
            return configElement.getIndexerID();
        }
        return null;
    }

    public void performApply(IProgressMonitor monitor) throws CoreException {
        String indexerName = this.getSelectedIndexerID();
        if (indexerName == null) {
            return;
        }
        String indexerPageID = this.getIndexerPageId(indexerName);
        if (indexerPageID == null) {
            return;
        }
        final String indexerID = this.getIndexerIdName(indexerPageID);
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(CUIMessages.getString("IndexerOptions.task.savingAttributes"), 2);
        final String selected = indexerID;
        if (indexerID != null) {
            IProject project;
            ICOptionContainer container = this.getContainer();
            IProject iProject = project = container != null ? container.getProject() : ((AbstractIndexerPage)this.currentPage).getCurrentProject();
            if (project != null) {
                ICDescriptorOperation op = new ICDescriptorOperation(){

                    public void execute(ICDescriptor descriptor, IProgressMonitor monitor) throws CoreException {
                        if (IndexerBlock.this.initialPDOMChecked != IndexerBlock.this.pdomChecked) {
                            PDOM.setEnabled((IProject)project, (boolean)IndexerBlock.this.pdomChecked);
                        }
                        if (IndexerBlock.this.initialSelected == null || !selected.equals(IndexerBlock.this.initialSelected)) {
                            descriptor.remove("org.eclipse.cdt.core.CIndexer");
                            descriptor.create("org.eclipse.cdt.core.CIndexer", indexerID);
                        }
                        monitor.worked(1);
                        ICOptionPage page = IndexerBlock.this.currentPage;
                        if (page != null && page.getControl() != null) {
                            page.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        }
                    }
                };
                CCorePlugin.getDefault().getCDescriptorManager().runDescriptorOperation(project, op, monitor);
                if (this.initialSelected == null || !selected.equals(this.initialSelected)) {
                    CCorePlugin.getDefault().getCoreModel().getIndexManager().indexerChangeNotification(project);
                }
            } else {
                if (!(this.initialSelected != null && selected.equals(this.initialSelected) || this.prefStore == null)) {
                    this.prefStore.setValue("usePDOM", this.pdomChecked);
                    String indexerId = this.prefStore.getString("indexer");
                    ICOptionPage tempPage = this.getIndexerPage(indexerId);
                    if (tempPage instanceof AbstractIndexerPage) {
                        ((AbstractIndexerPage)tempPage).removePreferences();
                    }
                    this.prefStore.setValue("indexer", indexerID);
                }
                monitor.worked(1);
                ICOptionPage page = this.currentPage;
                if (page != null && page.getControl() != null) {
                    page.performApply((IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
            }
            this.initialSelected = selected;
        }
        monitor.done();
    }

    public void persistIndexerSettings(IProject project, IProgressMonitor monitor) throws CoreException {
        if (this.currentPage instanceof AbstractIndexerPage) {
            ((AbstractIndexerPage)this.currentPage).setCurrentProject(project);
        }
        this.performApply(monitor);
    }

    public void resetIndexerPageSettings(IProject project) {
        if (this.currentPage instanceof AbstractIndexerPage) {
            ((AbstractIndexerPage)this.currentPage).setCurrentProject(project);
        }
        this.performDefaults();
    }

    public void performDefaults() {
        ICOptionPage page = this.currentPage;
        if (page != null && page.getControl() != null) {
            page.performDefaults();
        }
    }

    public boolean isIndexEnabled() {
        return false;
    }

    public void setIndexerID(String indexerID, IProject project) {
        if (PDOM.isInitialized((IProject)project)) {
            this.initialPDOMChecked = this.pdomChecked = PDOM.isEnabled((IProject)project);
            this.indexerUsePDOM.setSelection(this.initialPDOMChecked);
        }
        this.selectedIndexerId = this.getIndexerPageName(indexerID);
        this.initialSelected = indexerID;
        if (this.selectedIndexerId == null) {
            CCorePlugin.getDefault().getPluginPreferences().setValue("indexer", "org.eclipse.cdt.core.domsourceindexer");
            this.selectedIndexerId = "org.eclipse.cdt.core.domsourceindexer";
        }
        this.indexersComboBox.setText(this.selectedIndexerId);
        this.setPage();
        if (this.currentPage instanceof AbstractIndexerPage) {
            ((AbstractIndexerPage)this.currentPage).initialize(project);
        }
    }

    public String getSelectedIndexerID() {
        String indexerID = null;
        int selIndex = this.indexersComboBox.getSelectionIndex();
        if (selIndex != -1) {
            indexerID = this.indexersComboBox.getItem(selIndex);
        }
        return indexerID;
    }

    public IProject getProject() {
        ICOptionContainer container = this.getContainer();
        if (container != null) {
            return container.getProject();
        }
        return ((AbstractIndexerPage)this.currentPage).getCurrentProject();
    }

    protected static class IndexerPageConfiguration {
        ICOptionPage page;
        IConfigurationElement element;

        public IndexerPageConfiguration(IConfigurationElement _element) {
            this.element = _element;
        }

        public ICOptionPage getPage() throws CoreException {
            if (this.page == null) {
                this.page = (ICOptionPage)this.element.createExecutableExtension("class");
            }
            return this.page;
        }

        public String getName() {
            return this.element.getAttribute("name");
        }

        public String getIndexerID() {
            return this.element.getAttribute("indexerID");
        }
    }
}

