/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentsEList;
import org.eclipse.emf.ecore.util.ECrossReferenceEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

public class ECrossReferenceAdapter
implements Adapter.Internal {
    protected Set unloadedResources = new HashSet();
    protected InverseCrossReferencer inverseCrossReferencer = this.createInverseCrossReferencer();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static ECrossReferenceAdapter getCrossReferenceAdapter(Notifier notifier) {
        EList adapters = notifier.eAdapters();
        int i = 0;
        int size = adapters.size();
        while (i < size) {
            Object adapter = adapters.get(i);
            if (adapter instanceof ECrossReferenceAdapter) {
                return (ECrossReferenceAdapter)adapter;
            }
            ++i;
        }
        return null;
    }

    public Collection getNonNavigableInverseReferences(EObject eObject) {
        Collection result = (Collection)this.inverseCrossReferencer.get(eObject);
        if (result == null) {
            result = Collections.EMPTY_LIST;
        }
        return result;
    }

    public Collection getInverseReferences(EObject eObject) {
        Collection nonNavigableInverseReferences;
        ArrayList<EStructuralFeature.Setting> result = new ArrayList<EStructuralFeature.Setting>();
        EObject eContainer = eObject.eContainer();
        if (eContainer != null) {
            result.add(((InternalEObject)eContainer).eSetting(eObject.eContainmentFeature()));
        }
        if ((nonNavigableInverseReferences = (Collection)this.inverseCrossReferencer.get(eObject)) != null) {
            result.addAll(nonNavigableInverseReferences);
        }
        Iterator i = eObject.eClass().getEAllReferences().iterator();
        while (i.hasNext()) {
            EReference eReference = (EReference)i.next();
            EReference eOpposite = eReference.getEOpposite();
            if (eOpposite == null || eReference.isContainer() || eReference.isContainment() || !eObject.eIsSet(eReference)) continue;
            if (eReference.isMany()) {
                Iterator j = ((Collection)eObject.eGet(eReference)).iterator();
                while (j.hasNext()) {
                    InternalEObject referencingEObject = (InternalEObject)j.next();
                    result.add(referencingEObject.eSetting(eOpposite));
                }
                continue;
            }
            result.add(((InternalEObject)eObject.eGet(eReference)).eSetting(eOpposite));
        }
        return result;
    }

    protected boolean isIncluded(EReference eReference) {
        return eReference.getEOpposite() == null && !eReference.isDerived();
    }

    protected InverseCrossReferencer createInverseCrossReferencer() {
        return new InverseCrossReferencer();
    }

    public void notifyChanged(Notification notification) {
        this.selfAdapt(notification);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void selfAdapt(Notification notification) {
        Object notifier = notification.getNotifier();
        if (notifier instanceof EObject) {
            Object feature = notification.getFeature();
            if (!(feature instanceof EReference)) return;
            EReference reference = (EReference)feature;
            if (reference.isContainment()) {
                this.handleContainment(notification);
                return;
            } else {
                if (!this.isIncluded(reference)) return;
                this.handleCrossReference(reference, notification);
            }
            return;
        }
        if (notifier instanceof Resource) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.ecore.resource.Resource");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            switch (notification.getFeatureID((Class)clazz)) {
                case 2: {
                    if (this.unloadedResources.contains(notifier)) return;
                    this.handleContainment(notification);
                    return;
                }
                case 4: {
                    if (notification.getNewBooleanValue()) {
                        this.unloadedResources.remove(notifier);
                        Iterator i = ((Resource)notifier).getContents().iterator();
                        while (i.hasNext()) {
                            Notifier child = (Notifier)i.next();
                            this.addAdapter(child);
                        }
                        return;
                    }
                    this.unloadedResources.add(notifier);
                }
                default: {
                    return;
                }
            }
        }
        if (!(notifier instanceof ResourceSet)) return;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.emf.ecore.resource.ResourceSet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (notification.getFeatureID((Class)clazz) != 0) return;
        this.handleContainment(notification);
    }

    protected void handleContainment(Notification notification) {
        switch (notification.getEventType()) {
            case 9: {
                Notifier oldValue = (Notifier)notification.getOldValue();
                this.removeAdapter(oldValue);
                Notifier newValue = (Notifier)notification.getNewValue();
                this.addAdapter(newValue);
                break;
            }
            case 1: 
            case 2: {
                Notifier newValue = (Notifier)notification.getNewValue();
                if (newValue == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 3: {
                Notifier newValue = (Notifier)notification.getNewValue();
                if (newValue == null) break;
                this.addAdapter(newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                Iterator i = newValues.iterator();
                while (i.hasNext()) {
                    Notifier newValue = (Notifier)i.next();
                    this.addAdapter(newValue);
                }
                break;
            }
        }
    }

    protected void handleCrossReference(EReference reference, Notification notification) {
        switch (notification.getEventType()) {
            case 1: 
            case 2: 
            case 9: {
                EObject newValue;
                EObject oldValue = (EObject)notification.getOldValue();
                if (oldValue != null) {
                    this.inverseCrossReferencer.remove((EObject)notification.getNotifier(), (EReference)notification.getFeature(), oldValue);
                }
                if ((newValue = (EObject)notification.getNewValue()) == null) break;
                this.inverseCrossReferencer.add((EObject)notification.getNotifier(), (EReference)notification.getFeature(), newValue);
                break;
            }
            case 3: {
                EObject newValue = (EObject)notification.getNewValue();
                if (newValue == null) break;
                this.inverseCrossReferencer.add((EObject)notification.getNotifier(), (EReference)notification.getFeature(), newValue);
                break;
            }
            case 5: {
                Collection newValues = (Collection)notification.getNewValue();
                Iterator i = newValues.iterator();
                while (i.hasNext()) {
                    EObject newValue = (EObject)i.next();
                    this.inverseCrossReferencer.add((EObject)notification.getNotifier(), (EReference)notification.getFeature(), newValue);
                }
                break;
            }
            case 4: {
                EObject oldValue = (EObject)notification.getOldValue();
                if (oldValue == null) break;
                this.inverseCrossReferencer.remove((EObject)notification.getNotifier(), (EReference)notification.getFeature(), oldValue);
                break;
            }
            case 6: {
                Collection oldValues = (Collection)notification.getOldValue();
                Iterator i = oldValues.iterator();
                while (i.hasNext()) {
                    EObject oldValue = (EObject)i.next();
                    this.inverseCrossReferencer.remove((EObject)notification.getNotifier(), (EReference)notification.getFeature(), oldValue);
                }
                break;
            }
        }
    }

    public void setTarget(Notifier target) {
        block5: {
            block6: {
                block4: {
                    if (!(target instanceof EObject)) break block4;
                    EObject eObject = (EObject)target;
                    this.inverseCrossReferencer.add(eObject);
                    Iterator i = this.resolve() ? eObject.eContents().iterator() : ((InternalEList)eObject.eContents()).basicIterator();
                    while (i.hasNext()) {
                        Notifier notifier = (Notifier)i.next();
                        this.addAdapter(notifier);
                    }
                    break block5;
                }
                if (!(target instanceof Resource)) break block6;
                Resource resource = (Resource)target;
                if (!resource.isLoaded()) {
                    this.unloadedResources.add(resource);
                }
                EList contents = resource.getContents();
                int i = 0;
                int size = contents.size();
                while (i < size) {
                    Notifier notifier = (Notifier)contents.get(i);
                    this.addAdapter(notifier);
                    ++i;
                }
                break block5;
            }
            if (!(target instanceof ResourceSet)) break block5;
            EList resources = ((ResourceSet)target).getResources();
            int i = 0;
            while (i < resources.size()) {
                Notifier notifier = (Notifier)resources.get(i);
                this.addAdapter(notifier);
                ++i;
            }
        }
    }

    public void unsetTarget(Notifier target) {
        block5: {
            block6: {
                block4: {
                    if (!(target instanceof EObject)) break block4;
                    EObject eObject = (EObject)target;
                    this.inverseCrossReferencer.remove(eObject);
                    Iterator i = this.inverseCrossReferencer.getCrossReferences(eObject);
                    while (i.hasNext()) {
                        EObject crossReferencedEObject = (EObject)i.next();
                        this.inverseCrossReferencer.remove(eObject, (EReference)i.feature(), crossReferencedEObject);
                    }
                    i = this.resolve() ? eObject.eContents().iterator() : ((InternalEList)eObject.eContents()).basicIterator();
                    while (i.hasNext()) {
                        Notifier notifier = (Notifier)i.next();
                        this.removeAdapter(notifier);
                    }
                    break block5;
                }
                if (!(target instanceof Resource)) break block6;
                EList contents = ((Resource)target).getContents();
                int i = 0;
                int size = contents.size();
                while (i < size) {
                    Notifier notifier = (Notifier)contents.get(i);
                    this.removeAdapter(notifier);
                    ++i;
                }
                break block5;
            }
            if (!(target instanceof ResourceSet)) break block5;
            EList resources = ((ResourceSet)target).getResources();
            int i = 0;
            while (i < resources.size()) {
                Notifier notifier = (Notifier)resources.get(i);
                this.removeAdapter(notifier);
                ++i;
            }
        }
    }

    protected void addAdapter(Notifier notifier) {
        EList eAdapters = notifier.eAdapters();
        if (!eAdapters.contains(this)) {
            eAdapters.add(this);
        }
    }

    protected void removeAdapter(Notifier notifier) {
        notifier.eAdapters().remove((Object)this);
    }

    public void dump() {
        EcoreUtil.CrossReferencer.print(System.out, this.inverseCrossReferencer);
    }

    public Notifier getTarget() {
        return null;
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    protected boolean resolve() {
        return true;
    }

    protected class InverseCrossReferencer
    extends EcoreUtil.CrossReferencer {
        protected InverseCrossReferencer() {
            super((Collection)null);
        }

        protected EContentsEList.FeatureIterator getCrossReferences(EObject eObject) {
            return new ECrossReferenceEList.FeatureIteratorImpl(this, eObject){
                final /* synthetic */ InverseCrossReferencer this$1;
                {
                    this.this$1 = inverseCrossReferencer;
                }

                protected boolean isIncluded(EStructuralFeature eStructuralFeature) {
                    return FeatureMapUtil.isFeatureMap(eStructuralFeature) || InverseCrossReferencer.access$0(this.this$1).isIncluded((EReference)eStructuralFeature);
                }

                protected boolean resolve() {
                    return this.this$1.resolve();
                }
            };
        }

        protected boolean crossReference(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            return ECrossReferenceAdapter.this.isIncluded(eReference);
        }

        protected Collection newCollection() {
            return new ArrayList(this){
                final /* synthetic */ InverseCrossReferencer this$1;
                {
                    this.this$1 = inverseCrossReferencer;
                }

                public boolean add(Object object) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)object;
                    EObject eObject = setting.getEObject();
                    EStructuralFeature eStructuralFeature = setting.getEStructuralFeature();
                    Iterator<E> i = this.iterator();
                    while (i.hasNext()) {
                        EStructuralFeature.Setting containedSetting = (EStructuralFeature.Setting)i.next();
                        if (containedSetting.getEObject() != eObject || containedSetting.getEStructuralFeature() != eStructuralFeature) continue;
                        return false;
                    }
                    return super.add(object);
                }
            };
        }

        public void add(EObject eObject) {
            this.handleCrossReference(eObject);
        }

        public void add(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            this.getCollection(crossReferencedEObject).add(((InternalEObject)eObject).eSetting(eReference));
        }

        public void remove(EObject eObject, EReference eReference, EObject crossReferencedEObject) {
            Collection collection = (Collection)this.get(crossReferencedEObject);
            if (collection != null) {
                Iterator i = collection.iterator();
                while (i.hasNext()) {
                    EStructuralFeature.Setting setting = (EStructuralFeature.Setting)i.next();
                    if (setting.getEObject() != eObject || setting.getEStructuralFeature() != eReference) continue;
                    if (collection.size() == 1) {
                        this.remove(crossReferencedEObject);
                        break;
                    }
                    i.remove();
                    break;
                }
            }
        }

        protected boolean resolve() {
            return ECrossReferenceAdapter.this.resolve();
        }

        static /* synthetic */ ECrossReferenceAdapter access$0(InverseCrossReferencer inverseCrossReferencer) {
            return inverseCrossReferencer.ECrossReferenceAdapter.this;
        }
    }
}

