/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction;

import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;

public abstract class RecordingCommand
extends AbstractCommand {
    private final TransactionalEditingDomain domain;
    private Transaction transaction;
    private TransactionChangeDescription change;

    public RecordingCommand(TransactionalEditingDomain domain) {
        this.domain = domain;
    }

    public RecordingCommand(TransactionalEditingDomain domain, String label) {
        super(label);
        this.domain = domain;
    }

    public RecordingCommand(TransactionalEditingDomain domain, String label, String description) {
        super(label, description);
        this.domain = domain;
    }

    protected boolean prepare() {
        return true;
    }

    public final void execute() {
        this.doExecute();
        this.transaction = ((InternalTransactionalEditingDomain)this.domain).getActiveTransaction();
    }

    public boolean canUndo() {
        if (this.change == null && this.transaction != null) {
            this.change = this.transaction.getChangeDescription();
        }
        return this.change != null && this.change.canApply();
    }

    public final void undo() {
        this.change.applyAndReverse();
    }

    public final void redo() {
        this.change.applyAndReverse();
    }

    protected abstract void doExecute();
}

