/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.emf.transaction.impl.TransactionValidator;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.internal.Tracing;
import org.eclipse.emf.transaction.internal.l10n.Messages;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.IValidator;
import org.eclipse.emf.validation.service.ModelValidationService;

public class ReadWriteValidatorImpl
implements TransactionValidator {
    static final int VALIDATION = 1;
    static final int PRECOMMIT = 2;
    static final int POSTCOMMIT = 3;
    private TransactionTree tree = null;
    private TransactionTree transactionToPrecommit = null;
    static /* synthetic */ Class class$0;

    public void add(InternalTransaction transaction) {
        TransactionTree parent = this.findTree(transaction.getParent());
        TransactionTree newTree = parent == null ? (this.tree = new TransactionTree(transaction)) : parent.addChild(transaction);
        if (this.transactionToPrecommit == null && !transaction.isReadOnly()) {
            this.transactionToPrecommit = newTree;
        }
    }

    public void remove(InternalTransaction transaction) {
        TransactionTree parent = this.findTree(transaction.getParent());
        if (parent != null) {
            parent.removeChild(transaction);
        }
    }

    public synchronized List getNotificationsForValidation(Transaction tx) {
        TransactionTree nested;
        List result = null;
        if (this.tree != null && (nested = this.tree.find(tx)) != null) {
            result = nested.collectNotifications(1);
        }
        return result;
    }

    public synchronized List getNotificationsForPrecommit(Transaction tx) {
        List result = null;
        if (this.transactionToPrecommit != null && tx == this.transactionToPrecommit.getTransaction()) {
            result = this.transactionToPrecommit.collectNotifications(2);
            this.transactionToPrecommit = null;
        }
        return result;
    }

    public synchronized List getNotificationsForPostcommit(Transaction tx) {
        TransactionTree nested;
        List result = null;
        if (this.tree != null && (nested = this.tree.find(tx)) != null) {
            result = nested.collectNotifications(3);
        }
        return result;
    }

    private TransactionTree findTree(Transaction tx) {
        TransactionTree result = null;
        if (this.tree != null) {
            result = this.tree.find(tx);
        }
        return result;
    }

    public IStatus validate(Transaction tx) {
        IStatus result;
        try {
            IValidator validator = ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
            result = validator.validate((Collection)this.getNotificationsForValidation(tx));
        }
        catch (Exception e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.ReadWriteValidatorImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.catching(clazz, "validate", e);
            result = new Status(4, EMFTransactionPlugin.getPluginId(), 30, Messages.validationFailure, (Throwable)e);
        }
        return result;
    }

    public void dispose() {
        this.tree = null;
    }

    private static class TransactionTree {
        private final InternalTransaction transaction;
        private final List children = new ArrayList();
        private final int parentNotificationCount;

        TransactionTree(InternalTransaction transaction) {
            this.transaction = transaction;
            InternalTransaction parent = (InternalTransaction)transaction.getParent();
            this.parentNotificationCount = parent == null ? 0 : parent.getNotifications().size();
        }

        TransactionTree addChild(InternalTransaction child) {
            TransactionTree result = new TransactionTree(child);
            this.children.add(result);
            return result;
        }

        void removeChild(InternalTransaction child) {
            Iterator iter = this.children.iterator();
            while (iter.hasNext()) {
                if (((TransactionTree)iter.next()).getTransaction() != child) continue;
                iter.remove();
                break;
            }
        }

        TransactionTree find(Transaction tx) {
            TransactionTree result = null;
            if (this.transaction == tx) {
                result = this;
            } else {
                Iterator iter = this.children.iterator();
                while (iter.hasNext() && result == null) {
                    result = ((TransactionTree)iter.next()).find(tx);
                }
            }
            return result;
        }

        InternalTransaction getTransaction() {
            return this.transaction;
        }

        List getChildren() {
            return this.children;
        }

        List collectNotifications(int purpose) {
            ArrayList result;
            if (this.canCollectNotificationsFor(purpose)) {
                result = new ArrayList();
                this.collectNotifications(result, purpose);
            } else {
                result = Collections.EMPTY_LIST;
            }
            return result;
        }

        private boolean canCollectNotificationsFor(int purpose) {
            boolean result;
            switch (purpose) {
                case 1: {
                    result = TransactionImpl.isValidationEnabled(this.transaction);
                    break;
                }
                case 2: {
                    result = TransactionImpl.isTriggerEnabled(this.transaction);
                    break;
                }
                case 3: {
                    result = TransactionImpl.isNotificationEnabled(this.transaction);
                    break;
                }
                default: {
                    result = false;
                }
            }
            return result;
        }

        private void collectNotifications(List notifications, int purpose) {
            if (this.canCollectNotificationsFor(purpose)) {
                int lastIndex = 0;
                List parentNotifications = this.transaction.getNotifications();
                Iterator iter = this.children.iterator();
                while (iter.hasNext()) {
                    TransactionTree next = (TransactionTree)iter.next();
                    notifications.addAll(parentNotifications.subList(lastIndex, next.parentNotificationCount));
                    lastIndex = next.parentNotificationCount;
                    next.collectNotifications(notifications, purpose);
                }
                notifications.addAll(parentNotifications.subList(lastIndex, parentNotifications.size()));
            }
        }
    }
}

