/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.impl;

import java.util.Collections;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.ResourceSetManager;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.internal.Tracing;
import org.eclipse.emf.transaction.internal.l10n.Messages;

public class TransactionChangeRecorder
extends ChangeRecorder {
    private final InternalTransactionalEditingDomain domain;
    static /* synthetic */ Class class$0;

    public TransactionChangeRecorder(InternalTransactionalEditingDomain domain, ResourceSet rset) {
        super(rset);
        this.domain = domain;
        this.endRecording();
        ResourceSetManager.getInstance().observe(rset);
    }

    public final InternalTransactionalEditingDomain getEditingDomain() {
        return this.domain;
    }

    public void beginRecording() {
        this.beginRecording(Collections.singleton(this.getEditingDomain().getResourceSet()));
    }

    public ChangeDescription endRecording() {
        ChangeDescription result = super.endRecording();
        this.changeDescription = null;
        return result;
    }

    public void setTarget(Notifier target) {
        EList contents;
        Object object = target instanceof EObject ? ((EObject)target).eContents() : (target instanceof ResourceSet ? ((ResourceSet)target).getResources() : (contents = target instanceof Resource ? ((Resource)target).getContents() : null));
        if (contents != null) {
            Iterator i = contents.iterator();
            while (i.hasNext()) {
                Notifier notifier = (Notifier)i.next();
                this.addAdapter(notifier);
            }
        }
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        if (notification.getEventType() != 8) {
            Object notifier = notification.getNotifier();
            if (notifier instanceof ResourceSet) {
                this.processResourceSetNotification(notification);
            } else if (notifier instanceof Resource) {
                this.processResourceNotification(notification);
            } else {
                this.processObjectNotification(notification);
            }
        }
    }

    protected void processResourceSetNotification(Notification notification) {
        ResourceSetManager.getInstance().observe((ResourceSet)notification.getNotifier(), notification);
        this.appendNotification(notification);
    }

    protected void processResourceNotification(Notification notification) {
        ResourceSetManager.getInstance().observe((Resource)notification.getNotifier(), notification);
        this.appendNotification(notification);
    }

    protected void processObjectNotification(Notification notification) {
        this.appendNotification(notification);
    }

    protected void appendNotification(Notification notification) {
        InternalTransaction tx;
        if (!NotificationFilter.READ.matches(notification)) {
            this.assertWriting();
        }
        if ((tx = this.getEditingDomain().getActiveTransaction()) != null) {
            tx.add(notification);
        } else {
            this.getEditingDomain().broadcastUnbatched(notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void assertWriting() {
        InternalTransaction tx = this.domain.getActiveTransaction();
        if (tx == null || tx.isReadOnly() || tx.getOwner() != Thread.currentThread()) {
            InternalTransactionalEditingDomain internalTransactionalEditingDomain = this.domain;
            synchronized (internalTransactionalEditingDomain) {
                tx = this.domain.getActiveTransaction();
                if (tx != null) {
                    tx.abort((IStatus)new Status(4, EMFTransactionPlugin.getPluginId(), 40, Messages.concurrentWrite, null));
                }
            }
            IllegalStateException ise = new IllegalStateException(Messages.noWriteTx);
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionChangeRecorder");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "assertWriting", ise);
            throw ise;
        }
    }
}

