/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionChangeDescription;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.internal.EMFTransactionDebugOptions;
import org.eclipse.emf.transaction.internal.Tracing;
import org.eclipse.emf.transaction.util.CompositeChangeDescription;

public class TransactionImpl
implements InternalTransaction {
    private static long nextId;
    final long id;
    private final TransactionalEditingDomain domain;
    private final Thread owner;
    private final boolean readOnly;
    private final Map options;
    private InternalTransaction parent;
    private InternalTransaction root;
    private boolean active;
    private boolean closing;
    private boolean rollingBack;
    protected final CompositeChangeDescription change;
    protected final List notifications = new ArrayList();
    private boolean aborted;
    private IStatus status = Status.OK_STATUS;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        nextId = 0L;
    }

    public TransactionImpl(TransactionalEditingDomain domain, boolean readOnly) {
        this(domain, readOnly, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionImpl(TransactionalEditingDomain domain, boolean readOnly, Map options) {
        this.domain = domain;
        this.readOnly = readOnly;
        this.owner = Thread.currentThread();
        this.options = options == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(new HashMap(options));
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            this.id = nextId++;
            // ** MonitorExit[var4_4] (shouldn't be in output)
            this.change = TransactionImpl.isUndoEnabled(this) ? new CompositeChangeDescription() : null;
            return;
        }
    }

    public synchronized void start() throws InterruptedException {
        if (Thread.currentThread() != this.getOwner()) {
            IllegalStateException exc = new IllegalStateException("Not transaction owner");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "start", exc);
            throw exc;
        }
        if (this.isActive()) {
            IllegalStateException exc = new IllegalStateException("Transaction is already active");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "start", exc);
            throw exc;
        }
        this.getInternalDomain().activate(this);
        this.active = true;
        if (this != this.getInternalDomain().getActiveTransaction()) {
            IllegalStateException exc = new IllegalStateException("Activated transaction while another is active");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "start", exc);
            throw exc;
        }
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
            int depth = 1;
            Transaction tx = this.getParent();
            while (tx != null) {
                ++depth;
                tx = tx.getParent();
            }
            Tracing.trace("*** Started " + TransactionalEditingDomainImpl.getDebugID(this) + " read-only=" + this.isReadOnly() + " owner=" + this.getOwner().getName() + " depth=" + depth + " options=" + this.getOptions() + " at " + Tracing.now());
        }
        if (this.parent != null) {
            this.parent.pause();
        }
        this.startRecording();
    }

    public final TransactionalEditingDomain getEditingDomain() {
        return this.domain;
    }

    public final Transaction getParent() {
        return this.parent;
    }

    public final void setParent(InternalTransaction parent) {
        this.parent = parent;
        this.root = parent != null ? parent.getRoot() : this;
    }

    public final InternalTransaction getRoot() {
        return this.root;
    }

    public final Thread getOwner() {
        return this.owner;
    }

    public final boolean isReadOnly() {
        return this.readOnly;
    }

    public final Map getOptions() {
        return this.options;
    }

    public synchronized boolean isActive() {
        return this.active;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public void setStatus(IStatus status) {
        if (status == null) {
            status = Status.OK_STATUS;
        }
        this.status = status;
    }

    public synchronized void abort(IStatus status) {
        if (!$assertionsDisabled && status == null) {
            throw new AssertionError();
        }
        this.aborted = true;
        this.status = status;
        if (this.parent != null) {
            this.parent.abort(status);
        }
    }

    protected boolean isAborted() {
        return this.aborted;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void commit() throws RollbackException {
        if (Thread.currentThread() != this.getOwner()) {
            IllegalStateException exc = new IllegalStateException("Not transaction owner");
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            Tracing.throwing(clazz, "commit", exc);
            throw exc;
        }
        if (this.closing) {
            IllegalStateException exc = new IllegalStateException("Transaction is already closing");
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz3;
            }
            Tracing.throwing(clazz, "commit", exc);
            throw exc;
        }
        if (!this.isActive()) {
            IllegalStateException exc = new IllegalStateException("Transaction is already closed");
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz4;
            }
            Tracing.throwing(clazz, "commit", exc);
            throw exc;
        }
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
            Tracing.trace("*** Committing " + TransactionalEditingDomainImpl.getDebugID(this) + " at " + Tracing.now());
        }
        try {
            if (this.isAborted()) {
                this.closing = false;
                this.rollback();
                RollbackException exc = new RollbackException(this.getStatus());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz5;
                    try {
                        clazz5 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz5;
                }
                Tracing.throwing(clazz, "commit", exc);
                throw exc;
            }
            this.closing = true;
            if (TransactionImpl.isTriggerEnabled(this)) {
                try {
                    this.getInternalDomain().precommit(this);
                }
                catch (RollbackException e) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz6;
                        try {
                            clazz6 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz6;
                    }
                    Tracing.catching(clazz, "commit", e);
                    this.closing = false;
                    this.rollback();
                    Class<?> clazz7 = class$0;
                    if (clazz7 == null) {
                        Class<?> clazz8;
                        try {
                            clazz8 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz7 = class$0 = clazz8;
                    }
                    Tracing.throwing(clazz7, "commit", e);
                    throw e;
                }
            }
            if (this.getRoot() == this && TransactionImpl.isValidationEnabled(this)) {
                IStatus validationStatus = this.validate();
                this.setStatus(validationStatus);
                if (validationStatus.getSeverity() >= 4) {
                    this.closing = false;
                    this.rollback();
                    RollbackException exc = new RollbackException(validationStatus);
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz9;
                        try {
                            clazz9 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz9;
                    }
                    Tracing.throwing(clazz, "commit", exc);
                    throw exc;
                }
            }
        }
        catch (Throwable throwable) {
            Object var3_9 = null;
            this.stopRecording();
            this.close();
            throw throwable;
        }
        {
            Object var3_10 = null;
            this.stopRecording();
            this.close();
            return;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void rollback() {
        if (Thread.currentThread() != this.getOwner()) {
            IllegalStateException exc = new IllegalStateException("Not transaction owner");
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz2;
                try {
                    clazz2 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz2;
            }
            Tracing.throwing(clazz, "rollback", exc);
            throw exc;
        }
        if (this.closing) {
            IllegalStateException exc = new IllegalStateException("Transaction is already closing");
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz3;
                try {
                    clazz3 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz3;
            }
            Tracing.throwing(clazz, "rollback", exc);
            throw exc;
        }
        if (!this.isActive()) {
            IllegalStateException exc = new IllegalStateException("Transaction is already closed");
            Class<?> clazz = class$0;
            if (clazz == null) {
                Class<?> clazz4;
                try {
                    clazz4 = Class.forName("org.eclipse.emf.transaction.impl.TransactionImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                clazz = class$0 = clazz4;
            }
            Tracing.throwing(clazz, "rollback", exc);
            throw exc;
        }
        this.closing = true;
        this.rollingBack = true;
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
            Tracing.trace("*** Rolling back " + TransactionalEditingDomainImpl.getDebugID(this) + " at " + Tracing.now());
        }
        try {
            if (TransactionImpl.isValidationEnabled(this)) {
                this.getInternalDomain().getValidator().remove(this);
                this.stopRecording();
                if (TransactionImpl.isUndoEnabled(this)) {
                    this.change.apply();
                }
            }
            if (TransactionImpl.isUndoEnabled(this)) {
                this.change.clear();
            }
        }
        catch (Throwable throwable) {
            Object var1_4 = null;
            this.rollingBack = false;
            this.close();
            throw throwable;
        }
        {
            Object var1_5 = null;
            this.rollingBack = false;
            this.close();
            return;
        }
    }

    public void yield() {
        this.getEditingDomain().yield();
    }

    public TransactionChangeDescription getChangeDescription() {
        return this.isActive() && !this.closing ? null : this.change;
    }

    protected InternalTransactionalEditingDomain getInternalDomain() {
        return (InternalTransactionalEditingDomain)this.getEditingDomain();
    }

    private void startRecording() {
        TransactionChangeRecorder recorder = this.getInternalDomain().getChangeRecorder();
        if (TransactionImpl.isUndoEnabled(this) && !recorder.isRecording()) {
            recorder.beginRecording();
        }
    }

    private void stopRecording() {
        TransactionChangeRecorder recorder = this.getInternalDomain().getChangeRecorder();
        if (TransactionImpl.isUndoEnabled(this) && recorder.isRecording()) {
            this.change.add(recorder.endRecording());
        }
    }

    public void pause() {
        if (!this.isRollingBack()) {
            this.stopRecording();
        }
    }

    public void resume(TransactionChangeDescription nestedChanges) {
        if (!this.isRollingBack()) {
            if (TransactionImpl.isUndoEnabled(this) && nestedChanges != null) {
                this.change.add(nestedChanges);
            }
            this.startRecording();
        }
    }

    public boolean isRollingBack() {
        return this.rollingBack || this.parent != null && this.parent.isRollingBack();
    }

    protected synchronized void close() {
        if (this.isActive()) {
            this.active = false;
            this.closing = false;
            this.getInternalDomain().deactivate(this);
            if (this.parent != null) {
                this.parent.resume(this.change);
            }
            if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
                Tracing.trace("*** Closed " + TransactionalEditingDomainImpl.getDebugID(this) + " at " + Tracing.now());
            }
        }
    }

    public void add(Notification notification) {
        this.notifications.add(notification);
    }

    public List getNotifications() {
        return this.notifications;
    }

    protected IStatus validate() {
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
            Tracing.trace("*** Validating " + TransactionalEditingDomainImpl.getDebugID(this) + " at " + Tracing.now());
        }
        return this.getInternalDomain().getValidator().validate(this);
    }

    public String toString() {
        return "Transaction[active=" + this.isActive() + ", read-only=" + this.isReadOnly() + ", owner=" + this.getOwner().getName() + ']';
    }

    protected static boolean isUndoEnabled(Transaction tx) {
        return !tx.isReadOnly() && !TransactionImpl.hasOption(tx, "no_undo") && !TransactionImpl.hasOption(tx, "unprotected");
    }

    protected static boolean isValidationEnabled(Transaction tx) {
        return !tx.isReadOnly() && !TransactionImpl.hasOption(tx, "no_validation") && !TransactionImpl.hasOption(tx, "unprotected");
    }

    protected static boolean isTriggerEnabled(Transaction tx) {
        return !tx.isReadOnly() && !TransactionImpl.hasOption(tx, "no_triggers") && !TransactionImpl.hasOption(tx, "unprotected");
    }

    protected static boolean isNotificationEnabled(Transaction tx) {
        return !TransactionImpl.hasOption(tx, "silent");
    }

    protected static boolean isUnprotected(Transaction tx) {
        return !tx.isReadOnly() && TransactionImpl.hasOption(tx, "unprotected");
    }

    protected static boolean hasOption(Transaction tx, String option) {
        return Boolean.TRUE.equals(tx.getOptions().get(option));
    }
}

