/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.EMFCommandTransaction;
import org.eclipse.emf.transaction.impl.EditingDomainManager;
import org.eclipse.emf.transaction.impl.FilterManager;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalCommandStack;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.ReadOnlyValidatorImpl;
import org.eclipse.emf.transaction.impl.ReadWriteValidatorImpl;
import org.eclipse.emf.transaction.impl.TransactionChangeRecorder;
import org.eclipse.emf.transaction.impl.TransactionImpl;
import org.eclipse.emf.transaction.impl.TransactionValidator;
import org.eclipse.emf.transaction.impl.TransactionalCommandStackImpl;
import org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl;
import org.eclipse.emf.transaction.internal.EMFTransactionDebugOptions;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.internal.Tracing;
import org.eclipse.emf.transaction.internal.l10n.Messages;
import org.eclipse.emf.transaction.util.Lock;
import org.eclipse.osgi.util.NLS;

public class TransactionalEditingDomainImpl
extends AdapterFactoryEditingDomain
implements InternalTransactionalEditingDomain {
    private String id;
    private TransactionChangeRecorder recorder;
    private volatile InternalTransaction activeTransaction;
    private TransactionValidator validator;
    private final Lock transactionLock = new Lock();
    private final Lock writeLock = new Lock();
    private final List precommitListeners = new ArrayList();
    private final List aggregatePrecommitListeners = new ArrayList();
    private final List postcommitListeners = new ArrayList();
    private final List unbatchedNotifications = new ArrayList(1);
    private final ResourceSetChangeEvent unbatchedChangeEvent = new ResourceSetChangeEvent(this, null, this.unbatchedNotifications);
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TransactionalEditingDomainImpl(AdapterFactory adapterFactory, TransactionalCommandStack stack, ResourceSet resourceSet) {
        super(adapterFactory, (CommandStack)stack, resourceSet);
        this.initialize();
    }

    public TransactionalEditingDomainImpl(AdapterFactory adapterFactory, TransactionalCommandStack stack) {
        super(adapterFactory, (CommandStack)stack);
        this.initialize();
    }

    public TransactionalEditingDomainImpl(AdapterFactory adapterFactory, ResourceSet resourceSet) {
        this(adapterFactory, new TransactionalCommandStackImpl(), resourceSet);
    }

    public TransactionalEditingDomainImpl(AdapterFactory adapterFactory) {
        this(adapterFactory, new TransactionalCommandStackImpl());
    }

    private void initialize() {
        ((InternalTransactionalCommandStack)this.commandStack).setEditingDomain(this);
        this.recorder = this.createChangeRecorder(this.resourceSet);
        this.validator = TransactionValidator.NULL;
    }

    protected TransactionChangeRecorder createChangeRecorder(ResourceSet rset) {
        return new TransactionChangeRecorder(this, rset);
    }

    public final synchronized String getID() {
        return this.id;
    }

    public final synchronized void setID(String id) {
        boolean reregister = false;
        if (id != this.id && this.id != null) {
            boolean bl = reregister = TransactionalEditingDomain.Registry.INSTANCE.remove(this.id) == this;
        }
        if (reregister && id != null) {
            TransactionalEditingDomain.Registry.INSTANCE.add(id, this);
        }
        this.id = id;
    }

    protected static String getDebugID(TransactionalEditingDomain domain) {
        return domain.getID() == null ? "<anonymous>" : domain.getID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addResourceSetListener(ResourceSetListener l) {
        if (l.isPrecommitOnly() && l.isPostcommitOnly()) {
            throw new IllegalArgumentException("conflicting isPrecommitOnly() and isPostcommitOnly()");
        }
        List list = this.precommitListeners;
        synchronized (list) {
            List list2 = this.aggregatePrecommitListeners;
            synchronized (list2) {
                List list3 = this.postcommitListeners;
                synchronized (list3) {
                    if (!l.isPostcommitOnly()) {
                        if (!l.isAggregatePrecommitListener() && !this.precommitListeners.contains(l)) {
                            this.precommitListeners.add(l);
                        } else if (l.isAggregatePrecommitListener() && !this.aggregatePrecommitListeners.contains(l)) {
                            this.aggregatePrecommitListeners.add(l);
                        }
                    }
                    if (!l.isPrecommitOnly() && !this.postcommitListeners.contains(l)) {
                        this.postcommitListeners.add(l);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeResourceSetListener(ResourceSetListener l) {
        List list = this.precommitListeners;
        synchronized (list) {
            List list2 = this.aggregatePrecommitListeners;
            synchronized (list2) {
                List list3 = this.postcommitListeners;
                synchronized (list3) {
                    this.precommitListeners.remove(l);
                    this.aggregatePrecommitListeners.remove(l);
                    this.postcommitListeners.remove(l);
                }
            }
        }
    }

    protected InternalTransactionalCommandStack getTransactionalCommandStack() {
        return (InternalTransactionalCommandStack)this.getCommandStack();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object runExclusive(Runnable read) throws InterruptedException {
        block12: {
            tx = this.startTransaction(true, null);
            rwr = read instanceof RunnableWithResult != false ? (RunnableWithResult)read : null;
            try {
                read.run();
            }
            catch (Throwable var5_4) {
                var4_5 = null;
                if (tx == null) throw var5_4;
                if (tx.isActive() == false) throw var5_4;
                try {
                    tx.commit();
                    if (rwr == null) throw var5_4;
                    rwr.setStatus(Status.OK_STATUS);
                    throw var5_4;
                }
                catch (RollbackException e) {
                    v0 = TransactionalEditingDomainImpl.class$0;
                    if (v0 == null) {
                        try {
                            v1 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                        }
                        catch (ClassNotFoundException v2) {
                            throw new NoClassDefFoundError(v2.getMessage());
                        }
                        v0 = TransactionalEditingDomainImpl.class$0 = v1;
                    }
                    Tracing.catching(v0, "runExclusive", e);
                    EMFTransactionPlugin.INSTANCE.log(new MultiStatus(EMFTransactionPlugin.getPluginId(), 41, new IStatus[]{e.getStatus()}, Messages.readTxRollback, null));
                    if (rwr == null) throw var5_4;
                    rwr.setStatus(e.getStatus());
                }
                throw var5_4;
            }
            {
                var4_6 = null;
                if (tx == null || !tx.isActive()) break block12;
            }
            ** try [egrp 1[TRYBLOCK] [2 : 55->77)] { 
lbl34:
            // 1 sources

            tx.commit();
            if (rwr != null) {
                rwr.setStatus(Status.OK_STATUS);
            }
            break block12;
lbl38:
            // 1 sources

            catch (RollbackException e) {
                block13: {
                    v3 = TransactionalEditingDomainImpl.class$0;
                    if (v3 != null) break block13;
                    try {}
                    catch (ClassNotFoundException v4) {
                        throw new NoClassDefFoundError(v4.getMessage());
                    }
                    v3 = TransactionalEditingDomainImpl.class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                }
                Tracing.catching(v3, "runExclusive", e);
                EMFTransactionPlugin.INSTANCE.log(new MultiStatus(EMFTransactionPlugin.getPluginId(), 41, new IStatus[]{e.getStatus()}, Messages.readTxRollback, null));
                if (rwr == null) break block12;
                rwr.setStatus(e.getStatus());
            }
        }
        if (rwr == null) return null;
        v5 = rwr.getResult();
        return v5;
    }

    public void yield() {
        Thread current = Thread.currentThread();
        if (this.transactionLock.getOwner() != current) {
            IllegalStateException exc = new IllegalStateException("Only the active transaction may yield");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "yield", exc);
            throw exc;
        }
        if (this.writeLock.getOwner() == null && this.transactionLock.yield()) {
            if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
                Tracing.trace(">>> Yielding " + TransactionalEditingDomainImpl.getDebugID(this.activeTransaction) + " at " + Tracing.now());
            }
            InternalTransaction transactionToRestore = this.activeTransaction;
            TransactionValidator validatorToRestore = this.validator;
            this.activeTransaction = null;
            this.validator = TransactionValidator.NULL;
            int depth = this.transactionLock.getDepth();
            int i = 0;
            while (i < depth) {
                this.transactionLock.release();
                ++i;
            }
            i = 0;
            while (i < depth) {
                while (true) {
                    try {
                        this.transactionLock.uiSafeAcquire(false);
                    }
                    catch (InterruptedException e) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        Tracing.catching(clazz, "yield", e);
                        continue;
                    }
                    break;
                }
                ++i;
            }
            this.activeTransaction = transactionToRestore;
            this.validator = validatorToRestore;
            if (!$assertionsDisabled && this.activeTransaction == null) {
                throw new AssertionError();
            }
            if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
                Tracing.trace(">>> Resuming " + TransactionalEditingDomainImpl.getDebugID(this.activeTransaction) + " at " + Tracing.now());
            }
        }
    }

    public InternalTransaction startTransaction(boolean readOnly, Map options) throws InterruptedException {
        TransactionImpl result = new TransactionImpl(this, readOnly, options);
        result.start();
        return result;
    }

    protected static String getDebugID(Transaction tx) {
        return String.valueOf(TransactionalEditingDomainImpl.getDebugID(tx.getEditingDomain())) + "::" + (tx instanceof TransactionImpl ? Long.toString(((TransactionImpl)tx).id) : "<anonymous>");
    }

    public TransactionChangeRecorder getChangeRecorder() {
        return this.recorder;
    }

    public TransactionValidator getValidator() {
        return this.validator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResourceSetListener[] getPrecommitListeners() {
        List list = this.precommitListeners;
        synchronized (list) {
            return this.precommitListeners.toArray(new ResourceSetListener[this.precommitListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResourceSetListener[] getAggregatePrecommitListeners() {
        List list = this.aggregatePrecommitListeners;
        synchronized (list) {
            return this.aggregatePrecommitListeners.toArray(new ResourceSetListener[this.aggregatePrecommitListeners.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final ResourceSetListener[] getPostcommitListeners() {
        List list = this.postcommitListeners;
        synchronized (list) {
            return this.postcommitListeners.toArray(new ResourceSetListener[this.postcommitListeners.size()]);
        }
    }

    public InternalTransaction getActiveTransaction() {
        return this.activeTransaction;
    }

    public void activate(InternalTransaction tx) throws InterruptedException {
        if (!$assertionsDisabled && tx == null) {
            throw new AssertionError((Object)"Cannot activate a null transaction");
        }
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
            Tracing.trace(">>> Activating   " + TransactionalEditingDomainImpl.getDebugID(tx) + " at " + Tracing.now());
        }
        this.acquire(tx);
        tx.setParent(this.activeTransaction);
        if (this.activeTransaction == null) {
            this.validator = tx.isReadOnly() ? new ReadOnlyValidatorImpl() : new ReadWriteValidatorImpl();
        }
        this.activeTransaction = tx;
        this.validator.add(tx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate(InternalTransaction tx) {
        if (!$assertionsDisabled && tx == null) {
            throw new AssertionError((Object)"Cannot deactivate a null transaction");
        }
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
            Tracing.trace(">>> Deactivating " + TransactionalEditingDomainImpl.getDebugID(tx) + " at " + Tracing.now());
        }
        Lock lock = this.transactionLock;
        synchronized (lock) {
            if (this.activeTransaction != tx) {
                IllegalArgumentException exc = new IllegalArgumentException("Can only deactivate the active transaction");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.throwing(clazz, "deactivate", exc);
                throw exc;
            }
            this.activeTransaction = (InternalTransaction)tx.getParent();
            if (this.activeTransaction == null) {
                this.postcommit(tx);
                this.validator.dispose();
                this.validator = TransactionValidator.NULL;
            }
            this.release(tx);
        }
    }

    private void acquire(InternalTransaction tx) throws InterruptedException {
        Thread current = Thread.currentThread();
        if (this.transactionLock.getOwner() == current && this.activeTransaction != null && this.activeTransaction.getOwner() == current && this.activeTransaction.isReadOnly() && !tx.isReadOnly() && !TransactionImpl.isUnprotected(tx)) {
            throw new IllegalStateException("Cannot activate read/write transaction in read-only transaction context");
        }
        this.transactionLock.uiSafeAcquire(!tx.isReadOnly());
        if (!tx.isReadOnly()) {
            this.writeLock.acquire(false);
        }
    }

    private void release(InternalTransaction tx) {
        if (!tx.isReadOnly()) {
            this.writeLock.release();
        }
        this.transactionLock.release();
    }

    public void precommit(InternalTransaction tx) throws RollbackException {
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
            Tracing.trace(">>> Precommitting " + TransactionalEditingDomainImpl.getDebugID(tx) + " at " + Tracing.now());
        }
        class PrecommitRunnable
        implements Runnable {
            private final List notifications;
            private final ResourceSetListener[] listeners;
            private final List triggers;
            private RollbackException rollback;
            final /* synthetic */ TransactionalEditingDomainImpl this$0;
            private final /* synthetic */ InternalTransaction val$tx;

            PrecommitRunnable(TransactionalEditingDomainImpl transactionalEditingDomainImpl, ResourceSetListener[] listeners, List notifications, InternalTransaction internalTransaction) {
                this.this$0 = transactionalEditingDomainImpl;
                this.val$tx = internalTransaction;
                this.triggers = new ArrayList<E>();
                this.listeners = listeners;
                this.notifications = notifications;
            }

            void runExclusive() throws InterruptedException {
                if (this.listeners.length > 0 && !this.notifications.isEmpty()) {
                    this.this$0.runExclusive(this);
                }
            }

            RollbackException getRollback() {
                return this.rollback;
            }

            List getTriggers() {
                return this.triggers;
            }

            public void run() {
                ArrayList<E> cache = new ArrayList<E>(this.notifications.size());
                int i = 0;
                while (i < this.listeners.length) {
                    block10: {
                        try {
                            Command cmd;
                            List filtered = FilterManager.getInstance().select(this.notifications, this.listeners[i].getFilter(), cache);
                            if (filtered.isEmpty() || (cmd = this.listeners[i].transactionAboutToCommit(new ResourceSetChangeEvent(this.this$0, this.val$tx, filtered))) == null) break block10;
                            this.triggers.add(cmd);
                        }
                        catch (RollbackException e) {
                            this.rollback = e;
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Tracing.catching(clazz, "precommit", e);
                            break;
                        }
                        catch (Exception e) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Tracing.catching(clazz, "precommit", e);
                            Status status = new Status(4, EMFTransactionPlugin.getPluginId(), 43, Messages.precommitFailed, (Throwable)e);
                            EMFTransactionPlugin.INSTANCE.log(status);
                            this.rollback = new RollbackException((IStatus)status);
                            break;
                        }
                    }
                    ++i;
                }
            }
        }
        PrecommitRunnable runnable = new PrecommitRunnable(this, this.getPrecommitListeners(), tx.getNotifications(), tx);
        while (runnable != null) {
            try {
                runnable.runExclusive();
                if (runnable.getRollback() != null) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    Tracing.throwing(clazz, "precommit", runnable.getRollback());
                    throw runnable.getRollback();
                }
                Command command = tx instanceof EMFCommandTransaction ? ((EMFCommandTransaction)tx).getCommand() : null;
                this.getTransactionalCommandStack().executeTriggers(command, runnable.getTriggers(), tx.getOptions());
                List notifications = this.validator.getNotificationsForPrecommit(tx);
                if (notifications == null || notifications.isEmpty()) {
                    runnable = null;
                    continue;
                }
                runnable = new PrecommitRunnable(this, this.getAggregatePrecommitListeners(), notifications, tx);
            }
            catch (InterruptedException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.catching(clazz, "precommit", e);
                Status status = new Status(4, EMFTransactionPlugin.getPluginId(), 42, Messages.precommitInterrupted, (Throwable)e);
                EMFTransactionPlugin.INSTANCE.log(status);
                RollbackException exc = new RollbackException((IStatus)status);
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.throwing(clazz2, "precommit", exc);
                throw exc;
            }
        }
    }

    protected void postcommit(final InternalTransaction tx) {
        List notifications;
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.TRANSACTIONS)) {
            Tracing.trace(">>> Postcommitting " + TransactionalEditingDomainImpl.getDebugID(tx) + " at " + Tracing.now());
        }
        if ((notifications = this.validator.getNotificationsForPostcommit(tx)) == null || notifications.isEmpty()) {
            return;
        }
        final ArrayList cache = new ArrayList(notifications.size());
        this.validator.dispose();
        final ResourceSetListener[] listeners = this.getPostcommitListeners();
        try {
            this.runExclusive(new Runnable(){

                public void run() {
                    int i = 0;
                    while (i < listeners.length) {
                        try {
                            List filtered = FilterManager.getInstance().select(notifications, listeners[i].getFilter(), cache);
                            if (!filtered.isEmpty()) {
                                listeners[i].resourceSetChanged(new ResourceSetChangeEvent(TransactionalEditingDomainImpl.this, tx, filtered));
                            }
                        }
                        catch (Exception e) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            Tracing.catching(clazz, "postcommit", e);
                            Status status = new Status(4, EMFTransactionPlugin.getPluginId(), 45, Messages.postcommitFailed, (Throwable)e);
                            EMFTransactionPlugin.INSTANCE.log(status);
                        }
                        ++i;
                    }
                }
            });
        }
        catch (InterruptedException e) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.catching(clazz, "postcommit", e);
            Status status = new Status(4, EMFTransactionPlugin.getPluginId(), 44, Messages.postcommitInterrupted, (Throwable)e);
            EMFTransactionPlugin.INSTANCE.log(status);
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void broadcastUnbatched(Notification notification) {
        final ResourceSetListener[] listeners = this.getPostcommitListeners();
        this.unbatchedNotifications.add(notification);
        try {
            try {
                this.runExclusive(new Runnable(){

                    public void run() {
                        int i = 0;
                        while (i < listeners.length) {
                            try {
                                List filtered = FilterManager.getInstance().selectUnbatched(TransactionalEditingDomainImpl.this.unbatchedNotifications, listeners[i].getFilter());
                                if (!filtered.isEmpty()) {
                                    listeners[i].resourceSetChanged(TransactionalEditingDomainImpl.this.unbatchedChangeEvent);
                                }
                            }
                            catch (Exception e) {
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                Tracing.catching(clazz, "broadcastUnbatched", e);
                                Status status = new Status(4, EMFTransactionPlugin.getPluginId(), 45, Messages.postcommitFailed, (Throwable)e);
                                EMFTransactionPlugin.INSTANCE.log(status);
                            }
                            ++i;
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    Class<?> clazz2;
                    try {
                        clazz2 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0 = clazz2;
                }
                Tracing.catching(clazz, "broadcastUnbatched", e);
                Status status = new Status(4, EMFTransactionPlugin.getPluginId(), 44, Messages.postcommitInterrupted, (Throwable)e);
                EMFTransactionPlugin.INSTANCE.log(status);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            this.unbatchedNotifications.remove(0);
            throw throwable;
        }
        {
            Object var5_7 = null;
            this.unbatchedNotifications.remove(0);
        }
    }

    public void dispose() {
        this.setID(null);
        this.activeTransaction = null;
        this.recorder.dispose();
        this.recorder = null;
        this.validator = null;
        this.getTransactionalCommandStack().dispose();
        this.commandStack = null;
    }

    public static class FactoryImpl
    implements TransactionalEditingDomain.Factory {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public synchronized TransactionalEditingDomain createEditingDomain() {
            TransactionalEditingDomainImpl result = new TransactionalEditingDomainImpl((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE));
            this.mapResourceSet(result);
            return result;
        }

        public synchronized TransactionalEditingDomain createEditingDomain(ResourceSet rset) {
            TransactionalEditingDomainImpl result = new TransactionalEditingDomainImpl((AdapterFactory)new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE), rset);
            this.mapResourceSet(result);
            return result;
        }

        public TransactionalEditingDomain getEditingDomain(ResourceSet rset) {
            ResourceSetDomainLink link;
            TransactionalEditingDomain result = null;
            EList eList = rset.eAdapters();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl$FactoryImpl$ResourceSetDomainLink");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((link = (ResourceSetDomainLink)EcoreUtil.getAdapter((List)eList, (Object)clazz)) != null) {
                result = link.getDomain();
            }
            return result;
        }

        public synchronized void mapResourceSet(TransactionalEditingDomain domain) {
            domain.getResourceSet().eAdapters().add((Object)new ResourceSetDomainLink(domain));
        }

        public synchronized void unmapResourceSet(TransactionalEditingDomain domain) {
            Iterator iter = domain.getResourceSet().eAdapters().iterator();
            while (iter.hasNext()) {
                Adapter next = (Adapter)iter.next();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.emf.transaction.TransactionalEditingDomain");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!next.isAdapterForType((Object)clazz)) continue;
                iter.remove();
            }
        }

        private static class ResourceSetDomainLink
        extends AdapterImpl {
            private final Reference domain;
            static /* synthetic */ Class class$0;

            ResourceSetDomainLink(TransactionalEditingDomain domain) {
                this.domain = new WeakReference<TransactionalEditingDomain>(domain);
            }

            public boolean isAdapterForType(Object type) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl$FactoryImpl$ResourceSetDomainLink");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return type == clazz;
            }

            final TransactionalEditingDomain getDomain() {
                TransactionalEditingDomain result = (TransactionalEditingDomain)this.domain.get();
                if (result == null) {
                    this.getTarget().eAdapters().remove((Object)this);
                }
                return result;
            }
        }
    }

    public static final class RegistryImpl
    implements TransactionalEditingDomain.Registry {
        private final Map domains = new HashMap();
        static /* synthetic */ Class class$0;

        public synchronized TransactionalEditingDomain getEditingDomain(String id) {
            TransactionalEditingDomain result = (TransactionalEditingDomain)this.domains.get(id);
            if (result == null && (result = EditingDomainManager.getInstance().createEditingDomain(id)) != null) {
                this.addImpl(id, result);
            }
            return result;
        }

        public synchronized void add(String id, TransactionalEditingDomain domain) {
            this.remove(id);
            this.addImpl(id, domain);
        }

        void addImpl(String id, TransactionalEditingDomain domain) {
            if (!id.equals(domain.getID())) {
                domain.setID(id);
            }
            this.domains.put(id, domain);
            EditingDomainManager.getInstance().configureListeners(id, domain);
        }

        public synchronized TransactionalEditingDomain remove(String id) {
            if (EditingDomainManager.getInstance().isStaticallyRegistered(id)) {
                IllegalArgumentException exc = new IllegalArgumentException(NLS.bind((String)Messages.removeStaticDomain, (Object)id));
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.transaction.impl.TransactionalEditingDomainImpl$RegistryImpl");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.throwing(clazz, "remove", exc);
                throw exc;
            }
            TransactionalEditingDomain result = (TransactionalEditingDomain)this.domains.remove(id);
            if (result != null) {
                EditingDomainManager.getInstance().deconfigureListeners(id, result);
            }
            return result;
        }
    }
}

