/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.BasicEMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.impl.ChangeDescriptionImpl;
import org.eclipse.emf.transaction.TransactionChangeDescription;

public class CompositeChangeDescription
extends ChangeDescriptionImpl
implements TransactionChangeDescription {
    private final List changes = new ArrayList();

    public final boolean isEmpty() {
        return this.changes.isEmpty();
    }

    public final void clear() {
        this.changes.clear();
    }

    public boolean canApply() {
        boolean result = true;
        Iterator iter = this.changes.iterator();
        while (result && iter.hasNext()) {
            Object next = iter.next();
            if (!(next instanceof TransactionChangeDescription)) continue;
            result = ((TransactionChangeDescription)next).canApply();
        }
        return result;
    }

    public void apply() {
        ListIterator iter = this.changes.listIterator(this.changes.size());
        while (iter.hasPrevious()) {
            ((ChangeDescription)iter.previous()).apply();
        }
        this.changes.clear();
    }

    public void applyAndReverse() {
        ListIterator iter = this.changes.listIterator(this.changes.size());
        while (iter.hasPrevious()) {
            ((ChangeDescription)iter.previous()).applyAndReverse();
        }
        Collections.reverse(this.changes);
    }

    public void add(ChangeDescription change) {
        if (!this.isEmpty(change)) {
            if (change instanceof CompositeChangeDescription) {
                CompositeChangeDescription other = (CompositeChangeDescription)change;
                Iterator iter = other.changes.iterator();
                while (iter.hasNext()) {
                    this.add((ChangeDescription)iter.next());
                }
            } else {
                this.changes.add(change);
                if (this.objectChanges != null) {
                    this.objectChanges.addAll((Collection)change.getObjectChanges());
                }
                if (this.objectsToAttach != null) {
                    this.objectsToAttach.addAll((Collection)change.getObjectsToAttach());
                }
                if (this.objectsToDetach != null) {
                    this.objectsToDetach.addAll((Collection)change.getObjectsToDetach());
                }
                if (this.resourceChanges != null) {
                    this.resourceChanges.addAll((Collection)change.getResourceChanges());
                }
            }
        }
    }

    private boolean isEmpty(ChangeDescription changeDescription) {
        boolean result;
        boolean bl = result = changeDescription == null;
        if (!result) {
            result = changeDescription instanceof TransactionChangeDescription ? ((TransactionChangeDescription)changeDescription).isEmpty() : changeDescription.getObjectChanges().isEmpty() && changeDescription.getObjectsToAttach().isEmpty() && changeDescription.getObjectsToDetach().isEmpty() && changeDescription.getResourceChanges().isEmpty();
        }
        return result;
    }

    public EMap getObjectChanges() {
        if (this.objectChanges == null) {
            this.objectChanges = new BasicEMap();
            Iterator iter = this.changes.iterator();
            while (iter.hasNext()) {
                this.objectChanges.addAll((Collection)((ChangeDescription)iter.next()).getObjectChanges());
            }
        }
        return this.objectChanges;
    }

    public EList getObjectsToDetach() {
        if (this.objectsToDetach == null) {
            this.objectsToDetach = new BasicEList();
            Iterator iter = this.changes.iterator();
            while (iter.hasNext()) {
                this.objectsToDetach.addAll((Collection)((ChangeDescription)iter.next()).getObjectsToDetach());
            }
        }
        return this.objectsToDetach;
    }

    public EList getObjectsToAttach() {
        if (this.objectsToAttach == null) {
            this.objectsToAttach = new BasicEList();
            Iterator iter = this.changes.iterator();
            while (iter.hasNext()) {
                this.objectsToAttach.addAll((Collection)((ChangeDescription)iter.next()).getObjectsToAttach());
            }
        }
        return this.objectsToAttach;
    }

    public EList getResourceChanges() {
        if (this.resourceChanges == null) {
            this.resourceChanges = new BasicEList();
            Iterator iter = this.changes.iterator();
            while (iter.hasNext()) {
                this.resourceChanges.addAll((Collection)((ChangeDescription)iter.next()).getResourceChanges());
            }
        }
        return this.resourceChanges;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("CompositeChangeDescription[");
        result.append(this.getObjectChanges().size()).append(", ");
        result.append(this.getObjectsToAttach().size()).append(", ");
        result.append(this.getObjectsToDetach().size()).append(", ");
        result.append(this.getResourceChanges().size()).append(']');
        return result.toString();
    }
}

