/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.transaction.util;

import java.util.IdentityHashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobManager;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.transaction.internal.EMFTransactionDebugOptions;
import org.eclipse.emf.transaction.internal.EMFTransactionPlugin;
import org.eclipse.emf.transaction.internal.Tracing;
import org.eclipse.emf.transaction.internal.l10n.Messages;
import org.eclipse.emf.transaction.util.Queue;

public class Lock {
    private static final IJobManager jobmgr;
    private static long nextId;
    static final IStatus UI_REENTERED_STATUS;
    private final long id;
    private Thread owner = null;
    private int depth = 0;
    private final Queue waiting = new Queue();
    private final Map yielders = new IdentityHashMap();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
        jobmgr = Platform.getJobManager();
        nextId = 0L;
        UI_REENTERED_STATUS = new Status(1, EMFTransactionPlugin.getPluginId(), 1, "UI thread re-entered to get the lock", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lock() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            this.id = ++nextId;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public synchronized Thread getOwner() {
        return this.owner;
    }

    public synchronized int getDepth() {
        if (Thread.currentThread() != this.owner) {
            return 0;
        }
        return this.depth;
    }

    public void acquire(boolean exclusive) throws InterruptedException {
        this.acquire(0L, exclusive);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean acquire(long timeout, boolean exclusive) throws InterruptedException {
        if (timeout < 0L) {
            IllegalArgumentException exc = new IllegalArgumentException("negative timeout");
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "acquire", exc);
            throw exc;
        }
        if (Thread.interrupted()) {
            InterruptedException exc = new InterruptedException();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Tracing.throwing(clazz, "acquire", exc);
            throw exc;
        }
        Thread current = Thread.currentThread();
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            if (timeout > 0L) {
                Tracing.trace("::: Timed Acquire    [id=" + this.id + ", thread=" + current.getName() + ", exclusive=" + exclusive + ", timeout=" + timeout + ']' + " at " + Tracing.now());
            } else {
                Tracing.trace("::: Acquire          [id=" + this.id + ", thread=" + current.getName() + ", exclusive=" + exclusive + ']' + " at " + Tracing.now());
            }
        }
        boolean result = false;
        Queue.Wait node = null;
        Lock lock = this;
        synchronized (lock) {
            if (!exclusive || this.notYielded()) {
                if (current == this.owner) {
                    ++this.depth;
                    result = true;
                } else if (this.owner == null) {
                    this.depth = 1;
                    this.owner = current;
                    result = true;
                } else {
                    node = this.waiting.put(timeout, exclusive);
                }
            } else {
                if (this.owner == current) {
                    throw new InterruptedException(Messages.upgradeReadLock);
                }
                node = this.waiting.put(timeout, exclusive);
            }
        }
        if (node != null) {
            node.waitFor(timeout);
            lock = this;
            synchronized (lock) {
                if (node.wasNotified()) {
                    this.depth = 1;
                    this.owner = current;
                    result = true;
                }
            }
        }
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            if (result) {
                Tracing.trace("::: Taken            [id=" + this.id + ", thread=" + current.getName() + ", depth=" + this.depth + ']' + " at " + Tracing.now());
            } else {
                Tracing.trace("::: Timed Out        [id=" + this.id + ", thread=" + current.getName() + ']' + " at " + Tracing.now());
            }
        }
        if (result) {
            this.resume();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void uiSafeAcquire(boolean exclusive) throws InterruptedException {
        Thread current;
        block34: {
            boolean acquired;
            block33: {
                acquired = false;
                current = Thread.currentThread();
                Job currentJob = jobmgr.currentJob();
                if (currentJob == null || currentJob.getRule() == null) break block33;
                this.acquire(exclusive);
                break block34;
            }
            if (Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                Tracing.trace("::: UI-Safe Acquire  [id=" + this.id + ", thread=" + current.getName() + ']' + " at " + Tracing.now());
            }
            if (acquired = this.acquire(250L, exclusive)) {
                if (!$assertionsDisabled && this.getOwner() != current) {
                    throw new AssertionError();
                }
                return;
            }
            AcquireJob job = new AcquireJob(current, exclusive);
            while (!acquired) {
                Object var9_9;
                Object sync = job.getSync();
                ISchedulingRule rule = job.getRule();
                Object object = sync;
                synchronized (object) {
                    if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                        Tracing.trace("::: Scheduling       [id=" + this.id + ", thread=" + current.getName() + ']' + " at " + Tracing.now());
                    }
                    job.schedule();
                    sync.wait();
                }
                try {
                    InterruptedException exc;
                    try {
                        if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                            Tracing.trace("::: Blocking         [id=" + this.id + ", thread=" + current.getName() + ']' + " at " + Tracing.now());
                        }
                        jobmgr.beginRule(rule, null);
                        if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                            Tracing.trace("::: Unblocked        [id=" + this.id + ", thread=" + current.getName() + ']' + " at " + Tracing.now());
                        }
                        if (job.getResult().getSeverity() < 2) {
                            object = this;
                            synchronized (object) {
                                if (job.getResult() == UI_REENTERED_STATUS) {
                                    if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                                        Tracing.trace("::: Lock Recursion   [id=" + this.id + ", thread=" + current.getName() + ']' + " at " + Tracing.now());
                                    }
                                    acquired = this.acquire(250L, exclusive);
                                } else {
                                    boolean bl = acquired = this.getOwner() == current;
                                    if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING) && acquired) {
                                        Tracing.trace("::: Taken            [id=" + this.id + ", thread=" + current.getName() + ", depth=" + this.depth + ']' + " at " + Tracing.now());
                                    }
                                }
                            }
                            this.resume();
                        } else if (job.getResult().getSeverity() == 8) {
                            Thread.interrupted();
                            exc = new InterruptedException();
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                Class<?> clazz2;
                                try {
                                    clazz2 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                                clazz = class$0 = clazz2;
                            }
                            Tracing.throwing(clazz, "uiSafeAcquire", exc);
                            throw exc;
                        }
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        Thread.interrupted();
                        exc = new InterruptedException();
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            Class<?> clazz3;
                            try {
                                clazz3 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                            clazz = class$0 = clazz3;
                        }
                        Tracing.throwing(clazz, "uiSafeAcquire", exc);
                        throw exc;
                    }
                }
                catch (Throwable throwable) {
                    var9_9 = null;
                    jobmgr.endRule(rule);
                    throw throwable;
                }
                {
                    var9_9 = null;
                }
                jobmgr.endRule(rule);
            }
        }
        if (!$assertionsDisabled && this.getOwner() != current) {
            throw new AssertionError();
        }
    }

    public synchronized void release() {
        block7: {
            Queue.Wait node;
            if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
                Tracing.trace("::: Release          [id=" + this.id + ", thread=" + Thread.currentThread().getName() + ", depth=" + (this.depth - 1) + ']' + " at " + Tracing.now());
            }
            if (Thread.currentThread() != this.owner) {
                IllegalArgumentException exc = new IllegalArgumentException("Lock not owned by current thread");
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.emf.transaction.util.Lock");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                Tracing.throwing(clazz, "release", exc);
                throw exc;
            }
            --this.depth;
            if (this.depth != 0) break block7;
            boolean allowExclusive = this.notYielded();
            do {
                if ((node = this.waiting.take(allowExclusive)) != null) continue;
                this.owner = null;
                break block7;
            } while (!node.wakeUp());
            this.owner = node.getThread();
        }
    }

    private boolean notYielded() {
        return this.yielders.isEmpty();
    }

    public synchronized boolean yield() {
        boolean result;
        boolean bl = result = this.waiting.size() > this.waiting.exclusiveCount();
        if (result) {
            this.yielders.put(Thread.currentThread(), this);
        }
        if (result && Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            Tracing.trace("::: Yielding         [id=" + this.id + ", thread=" + Thread.currentThread().getName() + ']' + " at " + Tracing.now());
        }
        return result;
    }

    private void resume() {
        boolean removed;
        boolean bl = removed = this.yielders.remove(Thread.currentThread()) == this;
        if (removed && Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            Tracing.trace("::: Resuming         [id=" + this.id + ", thread=" + Thread.currentThread().getName() + ']' + " at " + Tracing.now());
        }
    }

    synchronized void transfer(Thread thread) {
        if (Tracing.shouldTrace(EMFTransactionDebugOptions.LOCKING)) {
            Tracing.trace("::: Transfer         [id=" + this.id + ", src=" + Thread.currentThread().getName() + ", dst=" + thread.getName() + ']' + " at " + Tracing.now());
        }
        this.owner = thread;
    }

    public String toString() {
        Thread lastKnownOwner = this.owner;
        return "Lock[id=" + this.id + ", depth=" + this.depth + ", owner=" + (lastKnownOwner == null ? null : lastKnownOwner.getName()) + ", waiting=" + this.waiting + ']';
    }

    class AcquireJob
    extends Job {
        private final Object sync;
        private final Thread thread;
        private final boolean exclusive;
        private AcquireRule rule;

        AcquireJob(Thread schedulingThread, boolean exclusive) {
            super(Messages.acquireJobLabel);
            this.sync = new Object();
            this.rule = new AcquireRule();
            this.thread = schedulingThread;
            this.exclusive = exclusive;
            this.setSystem(true);
            this.setRule(this.rule);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        protected IStatus run(IProgressMonitor monitor) {
            var2_2 = this.sync;
            synchronized (var2_2) {
                this.sync.notify();
                // MONITOREXIT @DISABLED, blocks:[0, 3] lbl5 : MonitorExitStatement: MONITOREXIT : var2_2
                if (true) ** GOTO lbl20
            }
            {
                do {
                    var2_2 = Lock.this;
                    synchronized (var2_2) {
                        if (Lock.this.getOwner() == this.thread) {
                            return Lock.UI_REENTERED_STATUS;
                        }
                    }
                    if (!monitor.isCanceled()) continue;
                    return Status.CANCEL_STATUS;
lbl20:
                    // 2 sources

                } while (!Lock.this.acquire(250L, this.exclusive));
            }
            Lock.this.transfer(this.thread);
            return Status.OK_STATUS;
        }

        public final Object getSync() {
            return this.sync;
        }
    }

    static class AcquireRule
    implements ISchedulingRule {
        AcquireRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

