/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.examples.actions;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.examples.extlibrary.presentation.EXTLibraryEditor;
import org.eclipse.emf.validation.examples.actions.LiveValidationContentAdapter;
import org.eclipse.emf.validation.examples.internal.l10n.ValidationMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;

public class EnableLiveValidationDelegate
implements IEditorActionDelegate,
IActionDelegate2 {
    protected static final String MESSAGE_EXCEPTION = ValidationMessages.message_exception;
    protected Shell shell = null;
    protected EXTLibraryEditor editor = null;
    protected Collection selectedEObjects = null;
    String title = ValidationMessages.EnableLiveValidationDelegate_title;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void selectionChanged(IAction action, ISelection selection) {
        this.selectedEObjects = null;
        try {
            try {
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    this.selectedEObjects = structuredSelection.toList();
                }
            }
            catch (Exception e) {
                MessageDialog.openInformation((Shell)this.shell, (String)this.title, (String)MESSAGE_EXCEPTION);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            action.setEnabled(this.selectedEObjects != null);
            throw throwable;
        }
        {
            Object var4_7 = null;
            action.setEnabled(this.selectedEObjects != null);
        }
        Iterator i = this.selectedEObjects.iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!(o instanceof Resource)) {
                action.setEnabled(false);
                continue;
            }
            if (!this.resourceHasAdapter((Resource)o)) continue;
            action.setEnabled(false);
        }
        return;
    }

    public void dispose() {
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        this.editor = (EXTLibraryEditor)targetEditor;
        if (targetEditor != null) {
            this.shell = targetEditor.getSite().getShell();
        }
    }

    public void init(IAction action) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void run(IAction action) {
        Iterator i = this.selectedEObjects.iterator();
        while (i.hasNext()) {
            Resource r = (Resource)i.next();
            if (this.resourceHasAdapter(r)) continue;
            LiveValidationContentAdapter liveValidationContentAdapter = new LiveValidationContentAdapter(this);
            r.eAdapters().add((Object)liveValidationContentAdapter);
        }
    }

    private boolean resourceHasAdapter(Resource r) {
        EList adapters = r.eAdapters();
        Iterator j = adapters.iterator();
        while (j.hasNext()) {
            Object o = j.next();
            if (!(o instanceof LiveValidationContentAdapter)) continue;
            return true;
        }
        return false;
    }
}

