/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.examples.actions;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.validation.examples.actions.EnableLiveValidationDelegate;
import org.eclipse.emf.validation.examples.constraints.ValidationDelegateClientSelector;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.service.ILiveValidator;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

class LiveValidationContentAdapter
extends EContentAdapter {
    private final EnableLiveValidationDelegate actionDelegate;
    private ILiveValidator validator = null;

    LiveValidationContentAdapter(EnableLiveValidationDelegate delegate) {
        this.actionDelegate = delegate;
    }

    public void notifyChanged(final Notification notification) {
        super.notifyChanged(notification);
        this.actionDelegate.shell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (LiveValidationContentAdapter.this.validator == null) {
                    LiveValidationContentAdapter.this.validator = (ILiveValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.LIVE);
                }
                ValidationDelegateClientSelector.running = true;
                IStatus status = LiveValidationContentAdapter.this.validator.validate(notification);
                if (!status.isOK()) {
                    if (status.isMultiStatus()) {
                        status = status.getChildren()[0];
                    }
                    MessageDialog.openError((Shell)((LiveValidationContentAdapter)LiveValidationContentAdapter.this).actionDelegate.shell, (String)((LiveValidationContentAdapter)LiveValidationContentAdapter.this).actionDelegate.title, (String)status.getMessage());
                }
                ValidationDelegateClientSelector.running = false;
            }
        });
    }
}

