/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.examples.constraints;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;

public class NonEmptyNamesConstraint
extends AbstractModelConstraint {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL) {
            String name = null;
            if (eObj instanceof Library) {
                name = ((Library)eObj).getName();
            } else if (eObj instanceof Book) {
                name = ((Book)eObj).getTitle();
            }
            if (name == null || name.length() == 0) {
                return ctx.createFailureStatus(new Object[]{eObj.eClass().getName()});
            }
        } else {
            Object newValue = ctx.getFeatureNewValue();
            if (newValue == null || ((String)newValue).length() == 0) {
                return ctx.createFailureStatus(new Object[]{eObj.eClass().getName()});
            }
        }
        return ctx.createSuccessStatus();
    }
}

