/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal;

import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.EMFPlugin;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.osgi.framework.Bundle;

public class ValidationUIPlugin
extends EMFPlugin {
    protected static final String PARENTHESIS_OPEN = "(";
    protected static final String PARENTHESIS_CLOSE = ")";
    protected static final String PREFIX_CHANGING = "CHANGING ";
    protected static final String PREFIX_CATCHING = "CAUGHT ";
    protected static final String PREFIX_THROWING = "THROWN ";
    protected static final String PREFIX_ENTERING = "ENTERING ";
    protected static final String PREFIX_EXITING = "EXITING ";
    protected static final String SEPARATOR_METHOD = "#";
    protected static final String SEPARATOR_PARAMETER = ", ";
    protected static final String SEPARATOR_RETURN = ":";
    protected static final String SEPARATOR_SPACE = " ";
    protected static final String LABEL_OLD_VALUE = "old=";
    protected static final String LABEL_NEW_VALUE = "new=";
    public static final ValidationUIPlugin INSTANCE = new ValidationUIPlugin();
    private static Implementation plugin;
    private static final String ICONS = "icons/";

    public ValidationUIPlugin() {
        super(new ResourceLocator[0]);
    }

    public ResourceLocator getPluginResourceLocator() {
        return plugin;
    }

    public static Implementation getPlugin() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String imageFile) {
        URL fullPath = FileLocator.find((Bundle)ValidationUIPlugin.getPlugin().getBundle(), (IPath)new Path(ICONS + imageFile), null);
        if (fullPath != null) {
            return ImageDescriptor.createFromURL((URL)fullPath);
        }
        return ImageDescriptor.getMissingImageDescriptor();
    }

    public static class Implementation
    extends EMFPlugin.EclipsePlugin {
        public Implementation() {
            plugin = this;
        }
    }

    public static class Tracing {
        private static final Map cachedOptions = new HashMap();

        protected static boolean shouldTrace() {
            return plugin.isDebugging();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean shouldTrace(String option) {
            if (Tracing.shouldTrace()) {
                Boolean value = null;
                Map map = cachedOptions;
                synchronized (map) {
                    value = (Boolean)cachedOptions.get(option);
                    if (value == null) {
                        value = new Boolean(Boolean.TRUE.toString().equalsIgnoreCase(Platform.getDebugOption((String)option)));
                        cachedOptions.put(option, value);
                    }
                }
                return value;
            }
            return false;
        }

        protected static String getArgumentString(Object argument) {
            return String.valueOf(argument);
        }

        protected static String getArgumentsString(Object[] arguments) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < arguments.length) {
                buffer.append(Tracing.getArgumentString(arguments[i]));
                if (i < arguments.length - 1) {
                    buffer.append(ValidationUIPlugin.SEPARATOR_PARAMETER);
                }
                ++i;
            }
            return buffer.toString();
        }

        public static void trace(String message) {
            if (Tracing.shouldTrace()) {
                System.out.println(message);
            }
        }

        public static void trace(String option, String message) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(message);
            }
        }

        public static void changing(String option, String valueDescription, Object oldValue, Object newValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_CHANGING + valueDescription + ValidationUIPlugin.SEPARATOR_SPACE + ValidationUIPlugin.LABEL_OLD_VALUE + Tracing.getArgumentString(oldValue) + ValidationUIPlugin.SEPARATOR_PARAMETER + ValidationUIPlugin.LABEL_NEW_VALUE + Tracing.getArgumentString(newValue));
            }
        }

        public static void changing(String option, Class clazz, String methodName, String valueDescription, Object oldValue, Object newValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_CHANGING + valueDescription + ValidationUIPlugin.SEPARATOR_SPACE + ValidationUIPlugin.LABEL_OLD_VALUE + Tracing.getArgumentString(oldValue) + ValidationUIPlugin.SEPARATOR_PARAMETER + ValidationUIPlugin.LABEL_NEW_VALUE + Tracing.getArgumentString(newValue) + ValidationUIPlugin.SEPARATOR_SPACE + ValidationUIPlugin.PARENTHESIS_OPEN + clazz.getName() + ValidationUIPlugin.SEPARATOR_METHOD + methodName + ValidationUIPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void catching(String option, Class clazz, String methodName, Throwable throwable) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_CATCHING + throwable.getMessage() + ValidationUIPlugin.SEPARATOR_SPACE + ValidationUIPlugin.PARENTHESIS_OPEN + clazz.getName() + ValidationUIPlugin.SEPARATOR_METHOD + methodName + ValidationUIPlugin.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public static void throwing(String option, Class clazz, String methodName, Throwable throwable) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_THROWING + throwable.getMessage() + ValidationUIPlugin.SEPARATOR_SPACE + ValidationUIPlugin.PARENTHESIS_OPEN + clazz.getName() + ValidationUIPlugin.SEPARATOR_METHOD + methodName + ValidationUIPlugin.PARENTHESIS_CLOSE);
                throwable.printStackTrace(System.err);
            }
        }

        public static void entering(String option, Class clazz, String methodName) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_ENTERING + clazz.getName() + ValidationUIPlugin.SEPARATOR_METHOD + methodName);
            }
        }

        public static void entering(String option, Class clazz, String methodName, Object parameter) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_ENTERING + clazz.getName() + ValidationUIPlugin.SEPARATOR_METHOD + methodName + ValidationUIPlugin.PARENTHESIS_OPEN + Tracing.getArgumentString(parameter) + ValidationUIPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void entering(String option, Class clazz, String methodName, Object[] parameters) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_ENTERING + clazz.getName() + ValidationUIPlugin.SEPARATOR_METHOD + methodName + ValidationUIPlugin.PARENTHESIS_OPEN + Tracing.getArgumentsString(parameters) + ValidationUIPlugin.PARENTHESIS_CLOSE);
            }
        }

        public static void exiting(String option, Class clazz, String methodName) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_EXITING + clazz.getName() + ValidationUIPlugin.SEPARATOR_METHOD + methodName);
            }
        }

        public static void exiting(String option, Class clazz, String methodName, Object returnValue) {
            if (Tracing.shouldTrace(option)) {
                Tracing.trace(ValidationUIPlugin.PREFIX_EXITING + clazz.getName() + ValidationUIPlugin.SEPARATOR_METHOD + methodName + ValidationUIPlugin.SEPARATOR_RETURN + Tracing.getArgumentString(returnValue));
            }
        }
    }
}

