/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal.preferences;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.ui.internal.preferences.ICategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.IConstraintNode;
import org.eclipse.jface.viewers.CheckboxTreeViewer;

abstract class AbstractCategoryTreeNode
implements ICategoryTreeNode {
    private final CheckboxTreeViewer tree;
    private ICategoryTreeNode[] children;
    private final Category category;
    private final ICategoryTreeNode parent;

    protected AbstractCategoryTreeNode(CheckboxTreeViewer tree, Category category, ICategoryTreeNode parent) {
        this.tree = tree;
        this.category = category;
        this.parent = parent;
    }

    protected abstract List createChildren();

    private void initChildren() {
        if (this.children == null) {
            List childList = this.createChildren();
            this.children = childList.toArray(new ICategoryTreeNode[childList.size()]);
        }
    }

    protected boolean isRecursivelyEmpty(Category cat) {
        boolean result = cat.getConstraints().isEmpty();
        if (result) {
            Iterator iter = cat.getChildren().iterator();
            while (result && iter.hasNext()) {
                result = this.isRecursivelyEmpty((Category)iter.next());
            }
        }
        return result;
    }

    protected final CheckboxTreeViewer getTree() {
        return this.tree;
    }

    public boolean hasChildren() {
        return this.getChildren().length > 0;
    }

    public ICategoryTreeNode[] getChildren() {
        this.initChildren();
        return this.children;
    }

    public final ICategoryTreeNode getParent() {
        return this.parent;
    }

    public Category getCategory() {
        return this.category;
    }

    public IConstraintNode[] getSelectedConstraints() {
        return new IConstraintNode[0];
    }

    public void applyToPreferences() {
        ICategoryTreeNode[] currentChildren = this.getChildren();
        int i = 0;
        while (i < currentChildren.length) {
            currentChildren[i].applyToPreferences();
            ++i;
        }
    }

    public void revertFromPreferences() {
        ICategoryTreeNode[] currentChildren = this.getChildren();
        int i = 0;
        while (i < currentChildren.length) {
            currentChildren[i].revertFromPreferences();
            ++i;
        }
    }

    public void restoreDefaults() {
        ICategoryTreeNode[] currentChildren = this.getChildren();
        int i = 0;
        while (i < currentChildren.length) {
            currentChildren[i].restoreDefaults();
            ++i;
        }
    }

    public String getDescription() {
        return this.category.getDescription();
    }

    public String toString() {
        return this.getCategory() == null ? "" : this.getCategory().getName();
    }
}

