/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.validation.ui.internal.preferences;

import java.util.ArrayList;
import org.eclipse.emf.validation.model.Category;
import org.eclipse.emf.validation.preferences.EMFModelValidationPreferences;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.emf.validation.ui.internal.ValidationUIPlugin;
import org.eclipse.emf.validation.ui.internal.l10n.ValidationUIMessages;
import org.eclipse.emf.validation.ui.internal.preferences.CategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.ConstraintDetailsHelper;
import org.eclipse.emf.validation.ui.internal.preferences.ConstraintNode;
import org.eclipse.emf.validation.ui.internal.preferences.ICategoryTreeNode;
import org.eclipse.emf.validation.ui.internal.preferences.IConstraintNode;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ConstraintsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String LOCK_ICON = "full/lock.gif";
    static final String CATEGORIES_PROMPT = ValidationUIMessages.prefs_categories_prompt;
    static final String CONSTRAINTS_PROMPT = ValidationUIMessages.prefs_constraints_prompt;
    static final String NO_SELECTION = ValidationUIMessages.prefs_no_selection;
    static final String NO_CATEGORY_DESCRIPTION = ValidationUIMessages.prefs_no_description_category;
    private CheckboxTreeViewer categoryTree;
    private CheckboxTableViewer constraintList;
    private StyledText detailsArea;
    private Mediator mediator;
    private ICategoryTreeNode rootcategory;

    protected Control createContents(Composite parent) {
        SashForm result = new SashForm(parent, 512);
        SashForm topPart = new SashForm((Composite)result, 256);
        this.createCategoryTree((Composite)topPart);
        this.createConstraintList((Composite)topPart);
        this.createDetailsArea((Composite)result);
        result.setWeights(new int[]{70, 30});
        return result;
    }

    private Control createCategoryTree(Composite parent) {
        Composite form = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        form.setLayout((Layout)layout);
        Label prompt = new Label(form, 0);
        prompt.setText(CATEGORIES_PROMPT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        prompt.setLayoutData((Object)data);
        this.categoryTree = new CheckboxTreeViewer(form);
        data = new FormData();
        data.top = new FormAttachment((Control)prompt, 4);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.categoryTree.getControl().setLayoutData((Object)data);
        this.rootcategory = CategoryTreeNode.createRoot(this.categoryTree);
        this.categoryTree.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final Image lockImage = ValidationUIPlugin.getImageDescriptor("full/lock.gif").createImage(true);

            public void dispose() {
                this.lockImage.dispose();
                super.dispose();
            }

            public Image getImage(Object element) {
                ICategoryTreeNode node = (ICategoryTreeNode)element;
                if (node.getCategory() != null && node.getCategory().isMandatory()) {
                    return this.lockImage;
                }
                return null;
            }
        });
        this.categoryTree.setContentProvider((IContentProvider)new CategoryTreeContents());
        this.categoryTree.setInput((Object)this.rootcategory);
        this.markEnabledCategories(this.rootcategory);
        this.categoryTree.addCheckStateListener((ICheckStateListener)this.getMediator());
        this.categoryTree.addSelectionChangedListener((ISelectionChangedListener)this.getMediator());
        return this.categoryTree.getTree();
    }

    private Control createConstraintList(Composite parent) {
        Composite form = new Composite(parent, 0);
        FormLayout layout = new FormLayout();
        form.setLayout((Layout)layout);
        Label prompt = new Label(form, 0);
        prompt.setText(CONSTRAINTS_PROMPT);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        prompt.setLayoutData((Object)data);
        this.constraintList = CheckboxTableViewer.newCheckList((Composite)form, (int)32);
        data = new FormData();
        data.top = new FormAttachment((Control)prompt, 4);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        this.constraintList.getControl().setLayoutData((Object)data);
        this.constraintList.setContentProvider((IContentProvider)new ConstraintListContents());
        this.constraintList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){
            private final Image lockImage = ValidationUIPlugin.getImageDescriptor("full/lock.gif").createImage(true);

            public void dispose() {
                this.lockImage.dispose();
                super.dispose();
            }

            public Image getImage(Object element) {
                IConstraintNode constraint = (IConstraintNode)element;
                if (constraint.isErrored()) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
                }
                if (constraint.isMandatory()) {
                    return this.lockImage;
                }
                return null;
            }

            public String getText(Object element) {
                return ((IConstraintNode)element).getName();
            }
        });
        this.constraintList.setSorter(new ViewerSorter());
        this.constraintList.addCheckStateListener((ICheckStateListener)this.getMediator());
        this.constraintList.addSelectionChangedListener((ISelectionChangedListener)this.getMediator());
        return this.constraintList.getControl();
    }

    private Control createDetailsArea(Composite parent) {
        this.detailsArea = new StyledText(parent, 2634);
        this.getMediator().clearDetailsArea();
        return this.detailsArea;
    }

    private CheckboxTreeViewer getCategoryTree() {
        return this.categoryTree;
    }

    private CheckboxTableViewer getConstraintList() {
        return this.constraintList;
    }

    private StyledText getDetailsArea() {
        return this.detailsArea;
    }

    private Mediator getMediator() {
        if (this.mediator == null) {
            this.mediator = new Mediator();
        }
        return this.mediator;
    }

    public void init(IWorkbench workbench) {
        ModelValidationService.getInstance().loadXmlConstraintDeclarations();
    }

    public boolean performOk() {
        this.rootcategory.applyToPreferences();
        EMFModelValidationPreferences.save();
        return true;
    }

    protected void performDefaults() {
        this.rootcategory.restoreDefaults();
        super.performDefaults();
    }

    private Category getCurrentCategorySelection() {
        IStructuredSelection selection = (IStructuredSelection)this.getCategoryTree().getSelection();
        if (selection.isEmpty()) {
            return null;
        }
        return ((ICategoryTreeNode)selection.getFirstElement()).getCategory();
    }

    private void markEnabledCategories(ICategoryTreeNode root) {
        this.markEnabledCategories(root.getChildren());
    }

    private void markEnabledCategories(ICategoryTreeNode[] categories) {
        int i = 0;
        while (i < categories.length) {
            ICategoryTreeNode next = categories[i];
            this.getCategoryTree().setChecked((Object)next, next.isChecked());
            this.getCategoryTree().setGrayed((Object)next, next.isGrayed());
            this.markEnabledCategories(next.getChildren());
            ++i;
        }
    }

    public void dispose() {
        ConstraintNode.flushCache();
        super.dispose();
    }

    private class CategoryTreeContents
    implements ITreeContentProvider {
        CategoryTreeContents() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((ICategoryTreeNode)parentElement).getChildren();
        }

        public Object getParent(Object element) {
            return ((ICategoryTreeNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((ICategoryTreeNode)element).hasChildren();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ConstraintListContents
    implements IStructuredContentProvider,
    ICheckStateListener {
        private CheckboxTableViewer viewer;
        private ICategoryTreeNode category;

        ConstraintListContents() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement == null) {
                return new Object[0];
            }
            this.category = (ICategoryTreeNode)inputElement;
            return this.category.getConstraints().toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer newViewer, Object oldInput, Object newInput) {
            if (this.viewer != null) {
                this.viewer.removeCheckStateListener((ICheckStateListener)this);
            }
            this.viewer = (CheckboxTableViewer)newViewer;
            this.category = (ICategoryTreeNode)newInput;
            if (this.viewer != null) {
                this.viewer.addCheckStateListener((ICheckStateListener)this);
            }
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            this.category.updateCheckState((IConstraintNode)event.getElement());
        }
    }

    private class Mediator
    implements ISelectionChangedListener,
    ICheckStateListener {
        private boolean respondingToUserSelection;

        Mediator() {
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void checkStateChanged(CheckStateChangedEvent event) {
            Object element = event.getElement();
            if (element instanceof ICategoryTreeNode) {
                ICategoryTreeNode node = (ICategoryTreeNode)element;
                if (this.respondingToUserSelection) return;
                this.respondingToUserSelection = true;
                try {
                    node.checkStateChanged(event);
                    IStructuredSelection selection = (IStructuredSelection)ConstraintsPreferencePage.this.getCategoryTree().getSelection();
                    if (!selection.isEmpty()) {
                        this.selectCategory((ICategoryTreeNode)selection.getFirstElement());
                    }
                }
                catch (Throwable throwable) {
                    Object var5_9 = null;
                    this.respondingToUserSelection = false;
                    throw throwable;
                }
                {
                    Object var5_10 = null;
                    this.respondingToUserSelection = false;
                    return;
                }
            }
            IConstraintNode node = (IConstraintNode)element;
            if (this.respondingToUserSelection) return;
            this.respondingToUserSelection = true;
            try {
                node.checkStateChanged(event);
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                this.respondingToUserSelection = false;
                throw throwable;
            }
            {
                Object var4_7 = null;
                this.respondingToUserSelection = false;
                return;
            }
        }

        public void selectionChanged(SelectionChangedEvent event) {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (event.getSource().equals(ConstraintsPreferencePage.this.getCategoryTree())) {
                this.handleCategorySelection(selection);
            } else if (event.getSource().equals(ConstraintsPreferencePage.this.getConstraintList())) {
                this.handleConstraintSelection(selection);
            }
        }

        private void handleCategorySelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                this.selectCategory((ICategoryTreeNode)selection.getFirstElement());
            } else {
                ConstraintsPreferencePage.this.getConstraintList().setInput(null);
                this.clearDetailsArea();
            }
        }

        private void selectCategory(ICategoryTreeNode category) {
            ConstraintsPreferencePage.this.getConstraintList().setInput((Object)category);
            this.selectConstraints(category);
            this.setDetails(category);
        }

        private void selectConstraints(ICategoryTreeNode categoryNode) {
            ConstraintsPreferencePage.this.getConstraintList().setCheckedElements((Object[])categoryNode.getSelectedConstraints());
        }

        private void handleConstraintSelection(IStructuredSelection selection) {
            if (!selection.isEmpty()) {
                this.setDetails((IConstraintNode)selection.getFirstElement());
            } else {
                this.clearDetailsArea();
            }
        }

        void clearDetailsArea() {
            ConstraintsPreferencePage.this.getDetailsArea().setText(NO_SELECTION);
        }

        private void setDetails(ICategoryTreeNode category) {
            String description;
            String string = description = category == null ? null : category.getDescription();
            if (description == null) {
                description = NO_CATEGORY_DESCRIPTION;
            }
            ConstraintsPreferencePage.this.getDetailsArea().setText(description);
        }

        private void setDetails(IConstraintNode constraint) {
            ArrayList styles = new ArrayList(32);
            String text = ConstraintDetailsHelper.formatConstraintDescription(constraint, ConstraintsPreferencePage.this.getCurrentCategorySelection(), styles);
            ConstraintsPreferencePage.this.getDetailsArea().setText(text);
            ConstraintsPreferencePage.this.getDetailsArea().setStyleRanges(styles.toArray(new StyleRange[styles.size()]));
        }
    }
}

