/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.resolver;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.bridge.resolver.NodePattern;
import org.eclipse.gmf.internal.bridge.resolver.Resolution;
import org.eclipse.gmf.internal.bridge.resolver.ResolvedItem;
import org.eclipse.gmf.internal.bridge.resolver.StructureResolver;
import org.eclipse.gmf.internal.bridge.resolver.TypeLinkPattern;
import org.eclipse.gmf.internal.bridge.resolver.TypePattern;

public class StructureBuilder {
    private StructureResolver resolver;

    public StructureBuilder(StructureResolver resolver) {
        this.resolver = resolver;
    }

    public ResolvedItem process(EPackage domainPackage) {
        ResolvedItem item = new ResolvedItem(null, domainPackage, null, ResolvedItem.DEFAULT_RESOLUTIONS);
        Iterator it = domainPackage.getEClassifiers().iterator();
        while (it.hasNext()) {
            Object next = it.next();
            if (!(next instanceof EClass)) continue;
            item.addChild(this.process((EClass)next));
        }
        return item;
    }

    public ResolvedItem process(EClass domainClass) {
        ResolvedItem item;
        TypePattern pattern = this.resolver.resolve(domainClass);
        if (pattern instanceof NodePattern) {
            item = new ResolvedItem(Resolution.NODE, domainClass, pattern, ResolvedItem.NODE_LINK_RESOLUTIONS);
            NodePattern nodePattern = (NodePattern)pattern;
            this.addLabels(item, nodePattern);
            int i = 0;
            while (i < nodePattern.getRefLinks().length) {
                item.addChild(new ResolvedItem(Resolution.LINK, nodePattern.getRefLinks()[i], null, ResolvedItem.LINK_RESOLUTIONS));
                ++i;
            }
        } else if (pattern instanceof TypeLinkPattern) {
            item = new ResolvedItem(Resolution.LINK, domainClass, pattern, ResolvedItem.NODE_LINK_RESOLUTIONS);
            TypeLinkPattern linkPattern = (TypeLinkPattern)pattern;
            this.addLabels(item, linkPattern);
        } else {
            item = new ResolvedItem(null, domainClass, pattern, ResolvedItem.DEFAULT_RESOLUTIONS);
        }
        return item;
    }

    protected void addLabels(ResolvedItem typeItem, TypePattern pattern) {
        int i = 0;
        while (i < pattern.getLabels().length) {
            typeItem.addChild(new ResolvedItem(Resolution.LABEL, pattern.getLabels()[i], null, ResolvedItem.LABEL_RESOLUTIONS));
            ++i;
        }
    }
}

