/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.resolver;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.internal.bridge.resolver.NodePattern;
import org.eclipse.gmf.internal.bridge.resolver.TypeLinkPattern;
import org.eclipse.gmf.internal.bridge.resolver.TypePattern;
import org.eclipse.gmf.internal.bridge.resolver.Vocabulary;

public class StructureResolver {
    private Vocabulary nodeVocabulary = new Vocabulary();
    private Vocabulary linkVocabulary;
    private Vocabulary linkSourceVocabulary;
    private Vocabulary linkTargetVocabulary;

    public StructureResolver() {
        this.nodeVocabulary.add(new String[]{"node", "item"});
        this.linkVocabulary = new Vocabulary();
        this.linkVocabulary.add(new String[]{"link", "connection", "relation", "dependency", "flow"});
        this.linkSourceVocabulary = new Vocabulary();
        this.linkSourceVocabulary.add(new String[]{"source", "src", "from"});
        this.linkTargetVocabulary = new Vocabulary();
        this.linkTargetVocabulary.add(new String[]{"destination", "dst", "dest", "to"});
    }

    protected boolean guessNode(EClass type) {
        return this.nodeVocabulary.containsWords(type.getName());
    }

    protected boolean guessLink(EClass type) {
        return this.linkVocabulary.containsWords(type.getName());
    }

    protected EReference guessLinkSource(EReference[] refs) {
        int i = 0;
        while (i < refs.length) {
            if (this.linkSourceVocabulary.containsWords(refs[i].getName())) {
                return refs[i];
            }
            ++i;
        }
        return null;
    }

    protected EReference guessLinkTarget(EReference[] refs) {
        int i = 0;
        while (i < refs.length) {
            if (this.linkTargetVocabulary.containsWords(refs[i].getName())) {
                return refs[i];
            }
            ++i;
        }
        return null;
    }

    public TypePattern resolve(EClass type) {
        EReference target;
        EReference source;
        if (type.isAbstract() || type.isInterface()) {
            return null;
        }
        EReference[] containments = this.getContainments(type);
        if (containments.length == 0) {
            return null;
        }
        EAttribute[] labels = this.getLabels(type);
        EReference[] refs = this.getEAllPotentialRefs(type, true);
        if (refs.length == 0 || !type.getEAllContainments().isEmpty() || this.guessNode(type)) {
            refs = this.getEAllPotentialRefs(type, false);
            return new NodePattern(type, labels, refs);
        }
        if (refs.length == 1) {
            source = null;
            target = refs[0];
        } else {
            source = this.guessLinkSource(refs);
            target = this.guessLinkTarget(refs);
            if (source == null) {
                EReference eReference = source = target == refs[0] ? refs[1] : refs[0];
            }
            if (target == null) {
                target = source == refs[1] ? refs[0] : refs[1];
            }
        }
        return new TypeLinkPattern(type, labels, source, target);
    }

    protected EAttribute[] getLabels(EClass type) {
        ArrayList<EAttribute> attrs = new ArrayList<EAttribute>();
        Iterator it = type.getEAllAttributes().iterator();
        while (it.hasNext()) {
            EAttribute attr = (EAttribute)it.next();
            attrs.add(attr);
        }
        return attrs.toArray(new EAttribute[attrs.size()]);
    }

    protected EReference[] getEAllPotentialRefs(EClass type, boolean forLink) {
        ArrayList<EReference> refs = new ArrayList<EReference>();
        Iterator it = type.getEAllReferences().iterator();
        while (it.hasNext()) {
            EReference ref = (EReference)it.next();
            EClass refType = ref.getEReferenceType();
            if (forLink && (refType.isSuperTypeOf(type) || ref.isMany())) continue;
            boolean samePackage = refType.getEPackage().equals(type.getEPackage());
            if (ref.isDerived() || ref.isContainer() || ref.isContainment() || !samePackage) continue;
            refs.add(ref);
        }
        return refs.toArray(new EReference[refs.size()]);
    }

    protected EReference[] getContainments(EClass type) {
        ArrayList<EReference> refs = new ArrayList<EReference>();
        TreeIterator it = type.getEPackage().eAllContents();
        while (it.hasNext()) {
            EReference ref;
            EObject element = (EObject)it.next();
            if (!(element instanceof EReference) || !(ref = (EReference)element).isContainment() || !ref.getEReferenceType().isSuperTypeOf(type) || ref.getEContainingClass() == type) continue;
            refs.add(ref);
        }
        return refs.toArray(new EReference[refs.size()]);
    }
}

