/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.internal.bridge.wizards.pages.EntriesPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.InputPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.Messages;
import org.eclipse.gmf.internal.bridge.wizards.pages.NewMapFileCreationPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.RootElementPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.WizardInput;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class NewGMFMapModelWizard
extends Wizard
implements INewWizard {
    protected IStructuredSelection mySelection;
    protected final WizardInput myHolder;
    private IWorkbench myWorkbench;

    public NewGMFMapModelWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.wizardTitle);
        this.myHolder = new WizardInput();
    }

    public void addPages() {
        this.addNewFilePage();
        this.addSelectInputPage();
        this.addSelectRootPage();
        this.addDoMapPage();
    }

    protected void addNewFilePage() {
        this.addPage((IWizardPage)new NewMapFileCreationPage(this.mySelection, this.myHolder));
    }

    protected void addSelectInputPage() {
        this.addPage((IWizardPage)new InputPage(this.myHolder));
    }

    protected void addSelectRootPage() {
        this.addPage((IWizardPage)new RootElementPage(this.myHolder));
    }

    protected void addDoMapPage() {
        this.addPage((IWizardPage)new EntriesPage(this.myHolder));
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.myWorkbench = workbench;
        this.mySelection = selection;
    }

    public boolean performFinish() {
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void execute(IProgressMonitor progressMonitor) {
                try {
                    try {
                        HashMap<String, String> options = new HashMap<String, String>();
                        options.put("ENCODING", "UTF-8");
                        NewGMFMapModelWizard.this.myHolder.getMapping().eResource().save(options);
                        if (NewGMFMapModelWizard.this.myHolder.isNewBlankToolDef()) {
                            NewGMFMapModelWizard.this.myHolder.getToolDef().eResource().save(options);
                        }
                    }
                    catch (Exception ex) {
                        Plugin.log(ex);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    progressMonitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                progressMonitor.done();
            }
        };
        try {
            this.getContainer().run(false, false, (IRunnableWithProgress)operation);
            WizardUtil.selectReveal(this.myWorkbench, (ISelection)new StructuredSelection((Object)this.getModelFile()));
            WizardUtil.openInEditor(this.myWorkbench, this.getModelFile());
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (PartInitException ex) {
            Plugin.log((CoreException)ex);
        }
        return true;
    }

    public IFile getModelFile() {
        return this.myHolder.getMappingFile();
    }

    public WizardInput getWizardInput() {
        return this.myHolder;
    }
}

