/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards;

import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class WizardUtil {
    private WizardUtil() {
    }

    public static String getDefaultFileName(IStructuredSelection selection, String defaultName, String extension) {
        Object selected;
        if (selection != null && !selection.isEmpty() && (selected = selection.getFirstElement()) instanceof IFile) {
            return WizardUtil.getDefaultFileName((IFile)selected, extension);
        }
        return String.valueOf(defaultName) + '.' + extension;
    }

    public static String getDefaultFileName(IFile file, String extension) {
        String fileNameBase = file.getName();
        if (file.getFileExtension() != null) {
            fileNameBase = fileNameBase.substring(0, fileNameBase.length() - (file.getFileExtension().length() + 1));
        }
        String modelFilename = String.valueOf(fileNameBase) + "." + extension;
        int i = 1;
        while (file.getParent().findMember(modelFilename) != null) {
            modelFilename = String.valueOf(fileNameBase) + i + "." + extension;
            ++i;
        }
        return modelFilename;
    }

    public static String getCapName(EStructuralFeature feature) {
        EClass type = feature.getEContainingClass();
        String name = type.getName();
        if (feature.getName().length() > 0) {
            name = String.valueOf(name) + Character.toUpperCase(feature.getName().charAt(0));
        }
        if (feature.getName().length() > 1) {
            name = String.valueOf(name) + feature.getName().substring(1);
        }
        return name;
    }

    public static void selectReveal(IWorkbench workbench, final ISelection selection) {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        final IWorkbenchPart activePart = page.getActivePart();
        if (activePart instanceof ISetSelectionTarget) {
            workbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    ((ISetSelectionTarget)activePart).selectReveal(selection);
                }
            });
        }
    }

    public static void openInEditor(IWorkbench workbench, IFile file) throws PartInitException {
        IWorkbenchWindow workbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = workbenchWindow.getActivePage();
        page.openEditor((IEditorInput)new FileEditorInput(file), workbench.getEditorRegistry().getDefaultEditor(file.getFullPath().toString()).getId());
    }
}

