/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.internal.bridge.resolver.NodePattern;
import org.eclipse.gmf.internal.bridge.resolver.Resolution;
import org.eclipse.gmf.internal.bridge.resolver.ResolvedItem;
import org.eclipse.gmf.internal.bridge.resolver.StructureBuilder;
import org.eclipse.gmf.internal.bridge.resolver.TypeLinkPattern;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.pages.DomainModelSource;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class DefinitionPage
extends WizardPage {
    private StructureBuilder structureBuilder;
    private DomainModelSource domainModelSource;
    private boolean allowDiagramElementSelection;
    private Composite innerPlate;
    private StackLayout innerPlateLayout;
    private Combo diagramElementSelector;
    private Button excludeContainedNodesChoice;
    private Button excludeLinksChoice;
    private TreeViewer viewer;
    private Text errorDetails;

    public DefinitionPage(String pageId, StructureBuilder structureBuilder, DomainModelSource domainModelSource, boolean allowDiagramElementSelection) {
        super(pageId);
        this.structureBuilder = structureBuilder;
        this.domainModelSource = domainModelSource;
        this.allowDiagramElementSelection = allowDiagramElementSelection;
    }

    protected GridData createFillBothGridData(int span) {
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.grabExcessVerticalSpace = true;
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = span;
        return data;
    }

    protected GridData createFillHorzGridData(int span) {
        GridData data = new GridData();
        data.horizontalAlignment = 4;
        data.grabExcessHorizontalSpace = true;
        data.horizontalSpan = span;
        return data;
    }

    public void createControl(Composite parent) {
        this.innerPlate = new Composite(parent, 0);
        this.innerPlate.setLayoutData((Object)this.createFillBothGridData(1));
        this.innerPlateLayout = new StackLayout();
        this.innerPlate.setLayout((Layout)this.innerPlateLayout);
        this.innerPlateLayout.topControl = this.createDomainModelGroup(this.innerPlate);
        this.createErrorGroup(this.innerPlate);
        this.setPageComplete(this.validatePage());
        this.setControl((Control)this.innerPlate);
    }

    private Composite createDomainModelGroup(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        if (this.allowDiagramElementSelection) {
            Label diagramElementLabel = new Label(plate, 0);
            diagramElementLabel.setText("Diagram element:");
            diagramElementLabel.setLayoutData((Object)new GridData());
            this.diagramElementSelector = new Combo(plate, 4);
            this.diagramElementSelector.setLayoutData((Object)this.createFillHorzGridData(1));
            this.diagramElementSelector.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }
            });
            this.excludeContainedNodesChoice = this.createChoice(plate, "Exclude types that are resolved as nodes that have a container");
            this.excludeLinksChoice = this.createChoice(plate, "Exclude types that are resolved as links");
        }
        Label domainModelElementsLabel = new Label(plate, 0);
        domainModelElementsLabel.setText("Domain model elements to process:");
        domainModelElementsLabel.setLayoutData((Object)this.createFillHorzGridData(2));
        this.viewer = this.createViewer(plate);
        this.viewer.getControl().setLayoutData((Object)this.createFillBothGridData(2));
        return plate;
    }

    private Button createChoice(Composite plate, String text) {
        Label dummy = new Label(plate, 0);
        dummy.setLayoutData((Object)new GridData());
        Button choice = new Button(plate, 32);
        choice.setText(text);
        choice.setLayoutData((Object)this.createFillHorzGridData(1));
        choice.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DefinitionPage.this.updateDiagramElementSelector();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return choice;
    }

    private Composite createErrorGroup(Composite parent) {
        Composite plate = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 12;
        plate.setLayout((Layout)layout);
        Label errorDescription = new Label(plate, 0);
        errorDescription.setText("Error loading domain model:");
        errorDescription.setLayoutData((Object)this.createFillHorzGridData(1));
        this.errorDetails = new Text(plate, 2816);
        this.errorDetails.setLayoutData((Object)this.createFillBothGridData(1));
        return plate;
    }

    protected TreeViewer createViewer(Composite parent) {
        Tree tree = new Tree(parent, 68356);
        TableLayout layout = new TableLayout();
        tree.setLayout((Layout)layout);
        tree.setHeaderVisible(true);
        TreeColumn elementColumn = new TreeColumn(tree, 16384);
        elementColumn.setText("Element");
        elementColumn.setResizable(true);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 32, true));
        this.addResolutionColumn(tree, Resolution.NODE, "/icons/cview16/node.gif");
        this.addResolutionColumn(tree, Resolution.LINK, "/icons/cview16/link.gif");
        this.addResolutionColumn(tree, Resolution.LABEL, "/icons/cview16/label.gif");
        final TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new ResolverContentProvider());
        EcoreItemProviderAdapterFactory adapterFactory = new EcoreItemProviderAdapterFactory();
        viewer.setLabelProvider((IBaseLabelProvider)new ResolverLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory)));
        viewer.setColumnProperties(new String[]{"no", Resolution.NODE.getName(), Resolution.LINK.getName(), Resolution.LABEL.getName()});
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[1] = new CheckboxCellEditor();
        cellEditorArray[2] = new CheckboxCellEditor();
        cellEditorArray[3] = new CheckboxCellEditor();
        viewer.setCellEditors(cellEditorArray);
        viewer.setCellModifier(new ICellModifier(){

            public Object getValue(Object element, String property) {
                ResolvedItem item = (ResolvedItem)element;
                return item.getResolution() == Resolution.getByName(property);
            }

            public boolean canModify(Object element, String property) {
                return true;
            }

            public void modify(Object element, String property, Object value) {
                Resolution resolution;
                ResolvedItem item = (ResolvedItem)((TreeItem)element).getData();
                if (!item.isPossibleResolution(resolution = Resolution.getByName(property))) {
                    return;
                }
                item.setResolution((Boolean)value != false ? resolution : null);
                viewer.update((Object)item, new String[]{Resolution.NODE.getName(), Resolution.LINK.getName(), Resolution.LABEL.getName()});
            }
        });
        return viewer;
    }

    protected TreeColumn addResolutionColumn(Tree tree, Resolution resolution, String iconId) {
        TreeColumn column = new TreeColumn(tree, 0x1000000);
        column.setImage(Plugin.getDefault().getImageRegistry().get(iconId));
        column.setResizable(false);
        ((TableLayout)tree.getLayout()).addColumnData((ColumnLayoutData)new ColumnPixelData(18, false, true));
        return column;
    }

    protected boolean validatePage() {
        return true;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible && this.domainModelSource.update()) {
            EPackage contents = this.domainModelSource.getContents();
            this.viewer.setInput(contents == null ? null : this.structureBuilder.process(contents));
            this.viewer.expandAll();
            this.viewer.getControl().pack();
            if (contents != null) {
                this.updateDiagramElementSelector();
                this.setPageComplete(this.validatePage());
                this.showDomainModelControls();
            } else if (this.domainModelSource.getErrorStatus() == null) {
                this.updateDiagramElementSelector();
                this.setPageComplete(true);
                this.showDomainModelControls();
            } else {
                this.setPageComplete(false);
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    PrintStream ps = new PrintStream(baos);
                    this.domainModelSource.getErrorStatus().getException().printStackTrace(ps);
                    ps.flush();
                    baos.flush();
                    this.errorDetails.setText(baos.toString());
                }
                catch (IOException iOException) {}
                this.showErrorDetailsControls();
            }
            this.innerPlate.layout(true, true);
        }
    }

    protected void showDomainModelControls() {
        this.innerPlateLayout.topControl = this.innerPlate.getChildren()[0];
    }

    protected void showErrorDetailsControls() {
        this.innerPlateLayout.topControl = this.innerPlate.getChildren()[1];
    }

    public ResolvedItem getModel() {
        return (ResolvedItem)this.viewer.getInput();
    }

    public ResolvedItem getDiagramElement() {
        if (!this.allowDiagramElementSelection) {
            return null;
        }
        return this.findResolvedItemByTypeName(this.getModel(), this.diagramElementSelector.getText());
    }

    private ResolvedItem findResolvedItemByTypeName(ResolvedItem item, String typeName) {
        if (item.getDomainRef() instanceof EClass && ((EClass)item.getDomainRef()).getName().equals(typeName)) {
            return item;
        }
        Iterator it = item.getChildren().iterator();
        while (it.hasNext()) {
            ResolvedItem result = this.findResolvedItemByTypeName((ResolvedItem)it.next(), typeName);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void updateDiagramElementSelector() {
        if (!this.allowDiagramElementSelection) {
            return;
        }
        TreeSet types = new TreeSet(new Comparator(){

            public int compare(Object arg0, Object arg1) {
                EClass type0 = (EClass)((ResolvedItem)arg0).getDomainRef();
                EClass type1 = (EClass)((ResolvedItem)arg1).getDomainRef();
                return type0.getName().compareToIgnoreCase(type1.getName());
            }
        });
        if (this.viewer.getInput() != null) {
            this.collectResolvedDomainTypes(types, (ResolvedItem)this.viewer.getInput());
        }
        String contents = this.diagramElementSelector.getText();
        this.diagramElementSelector.removeAll();
        Iterator it = types.iterator();
        while (it.hasNext()) {
            EClass type = (EClass)((ResolvedItem)it.next()).getDomainRef();
            this.diagramElementSelector.add(type.getName());
            if (!contents.equals(type.getName())) continue;
            this.diagramElementSelector.setText(contents);
        }
        if (this.diagramElementSelector.getText().length() == 0 && this.diagramElementSelector.getItemCount() > 0) {
            this.diagramElementSelector.setText(this.diagramElementSelector.getItem(0));
        }
        contents.equals(this.diagramElementSelector.getText());
    }

    private void collectResolvedDomainTypes(Collection types, ResolvedItem item) {
        if (item.getDomainRef() instanceof EClass) {
            boolean ignore = false;
            if (this.excludeContainedNodesChoice.getSelection()) {
                ignore |= item.getPattern() instanceof NodePattern;
            }
            if (this.excludeLinksChoice.getSelection()) {
                ignore |= item.getPattern() instanceof TypeLinkPattern;
            }
            if (!ignore) {
                types.add(item);
            }
        }
        Iterator it = item.getChildren().iterator();
        while (it.hasNext()) {
            this.collectResolvedDomainTypes(types, (ResolvedItem)it.next());
        }
    }

    protected static class ResolverContentProvider
    implements ITreeContentProvider {
        protected ResolverContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return ((ResolvedItem)element).getParent();
        }

        public Object[] getChildren(Object parentElement) {
            List children = ((ResolvedItem)parentElement).getChildren();
            return children.toArray();
        }

        public boolean hasChildren(Object element) {
            List children = ((ResolvedItem)element).getChildren();
            return !children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }
    }

    protected static class ResolverLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ILabelProvider domainLabelProvider;

        public ResolverLabelProvider(ILabelProvider domainLabelProvider) {
            this.domainLabelProvider = domainLabelProvider;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                Object domainRef = ((ResolvedItem)element).getDomainRef();
                return this.domainLabelProvider.getText(domainRef);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                Object domainRef = ((ResolvedItem)element).getDomainRef();
                return this.domainLabelProvider.getImage(domainRef);
            }
            ResolvedItem item = (ResolvedItem)element;
            Image checkedIcon = Plugin.getDefault().getImageRegistry().get("/icons/cview16/checked.gif");
            Image uncheckedIcon = Plugin.getDefault().getImageRegistry().get("/icons/cview16/unchecked.gif");
            if (columnIndex == 1) {
                if (!item.isPossibleResolution(Resolution.NODE)) {
                    return null;
                }
                return Resolution.NODE == item.getResolution() ? checkedIcon : uncheckedIcon;
            }
            if (columnIndex == 2) {
                if (!item.isPossibleResolution(Resolution.LINK)) {
                    return null;
                }
                return Resolution.LINK == item.getResolution() ? checkedIcon : uncheckedIcon;
            }
            if (columnIndex == 3) {
                if (!item.isPossibleResolution(Resolution.LABEL)) {
                    return null;
                }
                return Resolution.LABEL == item.getResolution() ? checkedIcon : uncheckedIcon;
            }
            return null;
        }
    }
}

