/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gmf.internal.bridge.wizards.pages.EntriesPage;
import org.eclipse.gmf.internal.bridge.wizards.pages.Messages;
import org.eclipse.gmf.internal.bridge.wizards.pages.WizardInput;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public class EntriesPage
extends WizardPage {
    private final WizardInput myHolder;

    public EntriesPage(WizardInput input) {
        super("entriesPage");
        this.myHolder = input;
        this.setTitle(Messages.mapPageTitle);
        this.setDescription(Messages.mapPageDesc);
    }

    protected Mapping getMapInstance() {
        return this.myHolder.getMapping();
    }

    protected WizardInput getHolder() {
        return this.myHolder;
    }

    public void createControl(Composite parent) {
        this.setControl((Control)new PageControl(parent));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            ((PageControl)this.getControl()).populate();
        }
    }

    private class PageControl
    extends Composite {
        private Group group;
        private List nodesList;
        private Group group1;
        private List linksList;
        private Composite detailsPart;
        private Group groupStructure;
        private Group groupEdit;
        private Group groupVisual;
        private Composite composite2;
        private Composite composite;
        private Button asNodeButton;
        private Button asLinkButton;
        private Button removeButton;
        private Button changeDetailsButton;
        private Button restoreButton;
        private Group groupConstaints;
        private Label specLabel;
        private Label initLabel;
        private Label diagramElementLabel;
        private Label metaElementLabel;
        private Label containmentLabel;
        private Label linkMetaFeatureLabel;
        private boolean isNodeInSelection;
        private NodeReference selectedNode;
        private LinkMapping selectedLink;
        private final ILabelProvider myLabelProvider;
        private SelectionListener myListListener;
        static final /* synthetic */ boolean $assertionsDisabled;
        static /* synthetic */ Class class$0;

        static {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.wizards.pages.EntriesPage$PageControl");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            $assertionsDisabled = !clazz.desiredAssertionStatus();
        }

        public PageControl(Composite parent) {
            super(parent, 0);
            this.group = null;
            this.nodesList = null;
            this.group1 = null;
            this.linksList = null;
            this.detailsPart = null;
            this.groupStructure = null;
            this.groupEdit = null;
            this.groupVisual = null;
            this.composite2 = null;
            this.composite = null;
            this.asNodeButton = null;
            this.asLinkButton = null;
            this.removeButton = null;
            this.changeDetailsButton = null;
            this.restoreButton = null;
            this.groupConstaints = null;
            this.specLabel = null;
            this.initLabel = null;
            this.diagramElementLabel = null;
            this.myLabelProvider = new LabelProvider(this){
                final /* synthetic */ PageControl this$1;
                {
                    this.this$1 = pageControl;
                }

                public String getText(Object element) {
                    if (element instanceof LinkMapping) {
                        LinkMapping next = (LinkMapping)element;
                        StringBuffer sb = new StringBuffer();
                        if (next.getDomainMetaElement() == null) {
                            if (next.getLinkMetaFeature() == null) {
                                sb.append("Link");
                            } else {
                                sb.append(next.getLinkMetaFeature().getName());
                                sb.append(" : ");
                                sb.append(next.getLinkMetaFeature().getEContainingClass().getName());
                            }
                        } else {
                            sb.append(next.getDomainMetaElement().getName());
                        }
                        sb.append(" (");
                        if (next.getDiagramLink() != null) {
                            sb.append(next.getDiagramLink().getName());
                            if (next.getContainmentFeature() != null) {
                                sb.append(";  ");
                            }
                        }
                        if (next.getContainmentFeature() != null) {
                            sb.append(next.getContainmentFeature().getName());
                        }
                        sb.append(")");
                        return sb.toString();
                    }
                    NodeReference next = (NodeReference)element;
                    StringBuffer sb = new StringBuffer();
                    sb.append(next.getChild().getDomainMetaElement() == null ? "Node" : next.getChild().getDomainMetaElement().getName());
                    sb.append(" (");
                    if (next.getChild().getDiagramNode() != null) {
                        sb.append(next.getChild().getDiagramNode().getName());
                        if (next.getContainmentFeature() != null) {
                            sb.append(";  ");
                        }
                    }
                    if (next.getContainmentFeature() != null) {
                        sb.append(next.getContainmentFeature().getName());
                    }
                    sb.append(")");
                    return sb.toString();
                }
            };
            this.myListListener = new SelectionListener(this){
                final /* synthetic */ PageControl this$1;
                {
                    this.this$1 = pageControl;
                }

                public void widgetSelected(SelectionEvent e) {
                    boolean nodeSelected = e.widget == PageControl.access$0(this.this$1);
                    PageControl.access$1(this.this$1).setEnabled(true);
                    PageControl.access$2(this.this$1).setEnabled(true);
                    PageControl.access$3(this.this$1).setEnabled(true);
                    if (nodeSelected) {
                        this.this$1.handleNodesListSelectionChange();
                        PageControl.access$4(this.this$1).deselectAll();
                    } else {
                        this.this$1.handleLinksListSelectionChange();
                        PageControl.access$0(this.this$1).deselectAll();
                    }
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            };
            this.initialize();
        }

        public void populate() {
            this.populateNodesList();
            this.populateLinksList();
        }

        private void populateNodesList() {
            String[] items = new String[EntriesPage.this.getMapInstance().getNodes().size()];
            int i = 0;
            Iterator it = EntriesPage.this.getMapInstance().getNodes().iterator();
            while (it.hasNext()) {
                items[i] = this.myLabelProvider.getText(it.next());
                ++i;
            }
            this.nodesList.setItems(items);
        }

        private void populateLinksList() {
            String[] items = new String[EntriesPage.this.getMapInstance().getLinks().size()];
            int i = 0;
            Iterator it = EntriesPage.this.getMapInstance().getLinks().iterator();
            while (it.hasNext()) {
                items[i] = this.myLabelProvider.getText(it.next());
                ++i;
            }
            this.linksList.setItems(items);
        }

        private void initialize() {
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            this.setLayout((Layout)gridLayout);
            this.createNodesList();
            this.createButtonsPane();
            this.createLinksList();
            this.createDetailsPart();
        }

        private void createNodesList() {
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.grabExcessVerticalSpace = true;
            gridData.verticalAlignment = 4;
            this.group = new Group((Composite)this, 0);
            this.group.setLayout((Layout)new FillLayout());
            this.group.setLayoutData((Object)gridData);
            this.group.setText("Nodes");
            this.nodesList = new List((Composite)this.group, 2564);
            this.nodesList.addSelectionListener(this.myListListener);
        }

        private void createLinksList() {
            GridData gridData1 = new GridData();
            gridData1.grabExcessHorizontalSpace = true;
            gridData1.horizontalAlignment = 4;
            gridData1.verticalAlignment = 4;
            gridData1.grabExcessVerticalSpace = true;
            this.group1 = new Group((Composite)this, 0);
            this.group1.setLayout((Layout)new FillLayout());
            this.group1.setLayoutData((Object)gridData1);
            this.group1.setText("Links");
            this.linksList = new List((Composite)this.group1, 2564);
            this.linksList.addSelectionListener(this.myListListener);
        }

        private void createDetailsPart() {
            GridData gridData3 = new GridData();
            gridData3.horizontalSpan = 5;
            gridData3.verticalAlignment = 4;
            gridData3.grabExcessHorizontalSpace = true;
            gridData3.grabExcessVerticalSpace = false;
            gridData3.horizontalAlignment = 4;
            this.detailsPart = new Composite((Composite)this, 0);
            this.detailsPart.setLayoutData((Object)gridData3);
            GridLayout gridLayout1 = new GridLayout();
            gridLayout1.numColumns = 7;
            gridLayout1.makeColumnsEqualWidth = true;
            this.detailsPart.setLayout((Layout)gridLayout1);
            this.createStructureGroup();
            this.createEditGroup();
            this.changeDetailsButton = new Button(this.detailsPart, 0);
            this.changeDetailsButton.setText("Change...");
            this.changeDetailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ PageControl this$1;
                {
                    this.this$1 = pageControl;
                }

                public void widgetSelected(SelectionEvent e) {
                    NodeReference input = PageControl.access$5(this.this$1) ? PageControl.access$6(this.this$1) : PageControl.access$7(this.this$1);
                    ChangePropertiesDialog changePropertiesDialog = PageControl.access$13(this.this$1).new ChangePropertiesDialog(this.this$1.getShell(), new Object[]{input});
                    int result = changePropertiesDialog.open();
                }
            });
            GridData gridData8 = new GridData();
            gridData8.grabExcessHorizontalSpace = true;
            gridData8.verticalAlignment = 2;
            gridData8.verticalSpan = 2;
            gridData8.horizontalAlignment = 2;
            this.changeDetailsButton.setLayoutData((Object)gridData8);
            this.createVisualGroup();
            this.createConstraintsGroup();
        }

        private void createStructureGroup() {
            this.groupStructure = new Group(this.detailsPart, 8);
            this.groupStructure.setText("Structure");
            this.groupStructure.setLayoutData((Object)this.newDetailGroupConstraint());
            this.groupStructure.setLayout((Layout)this.newDetailGroupLayout());
            Label l = new Label((Composite)this.groupStructure, 0);
            l.setText("Element:");
            this.metaElementLabel = new Label((Composite)this.groupStructure, 0);
            this.metaElementLabel.setLayoutData((Object)this.newDetailLabelConstraint());
            l = new Label((Composite)this.groupStructure, 0);
            l.setText("Containment:");
            this.containmentLabel = new Label((Composite)this.groupStructure, 0);
            this.containmentLabel.setLayoutData((Object)this.newDetailLabelConstraint());
            l = new Label((Composite)this.groupStructure, 0);
            l.setText("Target Feature:");
            this.linkMetaFeatureLabel = new Label((Composite)this.groupStructure, 0);
            this.linkMetaFeatureLabel.setLayoutData((Object)this.newDetailLabelConstraint());
        }

        private void createEditGroup() {
            this.groupEdit = new Group(this.detailsPart, 0);
            this.groupEdit.setText("Edit");
            this.groupEdit.setLayout((Layout)this.newDetailGroupLayout());
            this.groupEdit.setLayoutData((Object)this.newDetailGroupConstraint());
        }

        private void createVisualGroup() {
            this.groupVisual = new Group(this.detailsPart, 0);
            this.groupVisual.setText("Visual");
            this.groupVisual.setLayoutData((Object)this.newDetailGroupConstraint());
            this.groupVisual.setLayout((Layout)this.newDetailGroupLayout());
            Label l = new Label((Composite)this.groupVisual, 0);
            l.setText("Diagram Element:");
            this.diagramElementLabel = new Label((Composite)this.groupVisual, 0);
            this.diagramElementLabel.setLayoutData((Object)this.newDetailLabelConstraint());
        }

        private void createButtonsPane() {
            GridData gridData2 = new GridData();
            gridData2.horizontalAlignment = 4;
            gridData2.verticalAlignment = 2;
            this.composite2 = new Composite((Composite)this, 0);
            this.composite2.setLayout((Layout)new FillLayout());
            this.composite2.setLayoutData((Object)gridData2);
            this.createComposite();
        }

        private void createComposite() {
            RowLayout rowLayout = new RowLayout();
            rowLayout.type = 512;
            rowLayout.justify = true;
            rowLayout.marginHeight = 0;
            rowLayout.marginWidth = 0;
            rowLayout.pack = false;
            rowLayout.spacing = 6;
            rowLayout.marginLeft = 10;
            rowLayout.marginRight = 10;
            rowLayout.fill = false;
            this.composite = new Composite(this.composite2, 0);
            this.composite.setLayout((Layout)rowLayout);
            this.asNodeButton = new Button(this.composite, 0);
            this.asNodeButton.setText("As node <--");
            this.asNodeButton.setEnabled(false);
            this.asNodeButton.addListener(13, new Listener(this){
                final /* synthetic */ PageControl this$1;
                {
                    this.this$1 = pageControl;
                }

                public void handleEvent(Event event) {
                    TopNodeReference tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
                    NodeMapping nm = GMFMapFactory.eINSTANCE.createNodeMapping();
                    nm.setDomainMetaElement(PageControl.access$7(this.this$1).getDomainMetaElement());
                    nm.setDomainInitializer(PageControl.access$7(this.this$1).getDomainInitializer());
                    nm.setDomainSpecialization(PageControl.access$7(this.this$1).getDomainSpecialization());
                    nm.setTool(PageControl.access$7(this.this$1).getTool());
                    nm.setContextMenu(PageControl.access$7(this.this$1).getContextMenu());
                    nm.setAppearanceStyle(PageControl.access$7(this.this$1).getAppearanceStyle());
                    tnr.setContainmentFeature(PageControl.access$7(this.this$1).getContainmentFeature());
                    tnr.setOwnedChild(nm);
                    PageControl.access$13(this.this$1).getMapInstance().getNodes().add((Object)tnr);
                    PageControl.access$13(this.this$1).getMapInstance().getLinks().remove((Object)PageControl.access$7(this.this$1));
                    PageControl.access$4(this.this$1).remove(PageControl.access$4(this.this$1).getSelectionIndex());
                    PageControl.access$0(this.this$1).add(PageControl.access$8(this.this$1).getText((Object)nm));
                    PageControl.access$0(this.this$1).setSelection(PageControl.access$0(this.this$1).getItemCount() - 1);
                    this.this$1.handleNodesListSelectionChange();
                }
            });
            this.asLinkButton = new Button(this.composite, 0);
            this.asLinkButton.setText("As link  -->");
            this.asLinkButton.setEnabled(false);
            this.asLinkButton.addListener(13, new Listener(this){
                final /* synthetic */ PageControl this$1;
                {
                    this.this$1 = pageControl;
                }

                public void handleEvent(Event event) {
                    LinkMapping lm = GMFMapFactory.eINSTANCE.createLinkMapping();
                    NodeMapping nodeMapping = PageControl.access$6(this.this$1).getChild();
                    lm.setDomainMetaElement(nodeMapping.getDomainMetaElement());
                    lm.setContainmentFeature(PageControl.access$6(this.this$1).getContainmentFeature());
                    lm.setDomainInitializer(nodeMapping.getDomainInitializer());
                    lm.setDomainSpecialization(nodeMapping.getDomainSpecialization());
                    lm.setTool(nodeMapping.getTool());
                    lm.setContextMenu(nodeMapping.getContextMenu());
                    lm.setAppearanceStyle(nodeMapping.getAppearanceStyle());
                    PageControl.access$13(this.this$1).getMapInstance().getLinks().add((Object)lm);
                    PageControl.access$13(this.this$1).getMapInstance().getNodes().remove((Object)PageControl.access$6(this.this$1));
                    PageControl.access$0(this.this$1).remove(PageControl.access$0(this.this$1).getSelectionIndex());
                    PageControl.access$4(this.this$1).add(PageControl.access$8(this.this$1).getText((Object)lm));
                    PageControl.access$4(this.this$1).setSelection(PageControl.access$4(this.this$1).getItemCount() - 1);
                    this.this$1.handleLinksListSelectionChange();
                }
            });
            this.removeButton = new Button(this.composite, 0);
            this.removeButton.setText("Remove");
            this.removeButton.setEnabled(false);
            this.removeButton.addListener(13, new Listener(this){
                final /* synthetic */ PageControl this$1;
                {
                    this.this$1 = pageControl;
                }

                public void handleEvent(Event event) {
                    int i;
                    if (PageControl.access$0(this.this$1).getSelectionIndex() != -1) {
                        i = PageControl.access$0(this.this$1).getSelectionIndex();
                        PageControl.access$0(this.this$1).remove(i);
                        PageControl.access$13(this.this$1).getMapInstance().getNodes().remove(i);
                        if (i == PageControl.access$0(this.this$1).getItemCount() && i > 0) {
                            --i;
                        }
                        PageControl.access$0(this.this$1).setSelection(i);
                        if (PageControl.access$0(this.this$1).getItemCount() == 0) {
                            PageControl.access$9(this.this$1).setEnabled(false);
                            PageControl.access$1(this.this$1).setEnabled(false);
                            PageControl.access$2(this.this$1).setEnabled(false);
                        } else {
                            this.this$1.handleNodesListSelectionChange();
                        }
                    }
                    if (PageControl.access$4(this.this$1).getSelectionIndex() != -1) {
                        i = PageControl.access$4(this.this$1).getSelectionIndex();
                        PageControl.access$4(this.this$1).remove(i);
                        PageControl.access$13(this.this$1).getMapInstance().getLinks().remove(i);
                        if (i == PageControl.access$4(this.this$1).getItemCount() && i > 0) {
                            --i;
                        }
                        PageControl.access$4(this.this$1).setSelection(i);
                        if (PageControl.access$4(this.this$1).getItemCount() == 0) {
                            PageControl.access$10(this.this$1).setEnabled(false);
                            PageControl.access$1(this.this$1).setEnabled(false);
                            PageControl.access$2(this.this$1).setEnabled(false);
                        } else {
                            this.this$1.handleLinksListSelectionChange();
                        }
                    }
                }
            });
            this.restoreButton = new Button(this.composite, 0);
            this.restoreButton.setText("Restore...");
            this.restoreButton.setEnabled(false);
            this.restoreButton.addListener(13, new Listener(this){
                final /* synthetic */ PageControl this$1;
                {
                    this.this$1 = pageControl;
                }

                public void handleEvent(Event event) {
                    ListDialog d = new ListDialog(this.this$1.getShell());
                    d.setContentProvider(new IStructuredContentProvider(this){
                        final /* synthetic */ 7 this$2;
                        {
                            this.this$2 = var1_1;
                        }

                        public Object[] getElements(Object inputElement) {
                            return (Object[])inputElement;
                        }

                        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                        }

                        public void dispose() {
                        }
                    });
                    d.setLabelProvider(PageControl.access$8(this.this$1));
                    if (PageControl.access$5(this.this$1)) {
                        d.setInput((Object)PageControl.access$13(this.this$1).getHolder().nodeCandidates());
                    } else {
                        d.setInput((Object)PageControl.access$13(this.this$1).getHolder().linkCandidates());
                    }
                    if (d.open() == 0) {
                        if (PageControl.access$5(this.this$1)) {
                            PageControl.access$13(this.this$1).getMapInstance().getNodes().addAll(Arrays.asList(d.getResult()));
                            PageControl.access$0(this.this$1).removeAll();
                            PageControl.access$11(this.this$1);
                        } else {
                            PageControl.access$13(this.this$1).getMapInstance().getLinks().addAll(Arrays.asList(d.getResult()));
                            PageControl.access$4(this.this$1).removeAll();
                            PageControl.access$12(this.this$1);
                        }
                    }
                }
            });
        }

        private void createConstraintsGroup() {
            this.groupConstaints = new Group(this.detailsPart, 0);
            this.groupConstaints.setText("Constraints");
            this.groupConstaints.setLayout((Layout)this.newDetailGroupLayout());
            this.groupConstaints.setLayoutData((Object)this.newDetailGroupConstraint());
            Label label = new Label((Composite)this.groupConstaints, 0);
            label.setText("Specialization:");
            this.specLabel = new Label((Composite)this.groupConstaints, 0);
            this.specLabel.setLayoutData((Object)this.newDetailLabelConstraint());
            label = new Label((Composite)this.groupConstaints, 0);
            label.setText("Initializer:");
            this.initLabel = new Label((Composite)this.groupConstaints, 0);
            this.initLabel.setLayoutData((Object)this.newDetailLabelConstraint());
        }

        private GridLayout newDetailGroupLayout() {
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            gridLayout.makeColumnsEqualWidth = true;
            return gridLayout;
        }

        private GridData newDetailGroupConstraint() {
            GridData groupGridData = new GridData();
            groupGridData.horizontalAlignment = 4;
            groupGridData.grabExcessHorizontalSpace = true;
            groupGridData.grabExcessVerticalSpace = true;
            groupGridData.horizontalSpan = 3;
            groupGridData.verticalAlignment = 4;
            return groupGridData;
        }

        private GridData newDetailLabelConstraint() {
            GridData labelGridData = new GridData();
            labelGridData.horizontalSpan = 2;
            labelGridData.grabExcessHorizontalSpace = true;
            labelGridData.horizontalAlignment = 4;
            return labelGridData;
        }

        private void refreshCommonDetails(MappingEntry selectedEntry) {
            this.affix(this.metaElementLabel, (ENamedElement)selectedEntry.getDomainMetaElement());
            this.refreshDomainSpecialization(selectedEntry);
            this.refreshDomainInitializer(selectedEntry);
        }

        private void refreshDomainSpecialization(MappingEntry selectedEntry) {
            if (selectedEntry.getDomainSpecialization() == null) {
                this.specLabel.setText("");
                return;
            }
            this.specLabel.setText(selectedEntry.getDomainSpecialization().getBody());
        }

        private void refreshDomainInitializer(MappingEntry selectedEntry) {
            if (selectedEntry.getDomainInitializer() == null || !(selectedEntry.getDomainInitializer() instanceof FeatureSeqInitializer)) {
                this.initLabel.setText("");
                return;
            }
            FeatureSeqInitializer fsi = (FeatureSeqInitializer)selectedEntry.getDomainInitializer();
            StringBuffer sb = new StringBuffer();
            Iterator it = fsi.getInitializers().iterator();
            while (it.hasNext()) {
                FeatureValueSpec next = (FeatureValueSpec)it.next();
                sb.append(next.getFeature().getName());
                sb.append("; ");
            }
            this.initLabel.setText(sb.toString());
        }

        private void affix(Label l, ENamedElement el) {
            if (el != null) {
                l.setText(el.getName());
            } else {
                l.setText("");
            }
        }

        private void refreshNodeDetails() {
            this.refreshCommonDetails((MappingEntry)this.selectedNode.getChild());
            NodeMapping m = this.selectedNode.getChild();
            this.affix(this.containmentLabel, (ENamedElement)this.selectedNode.getContainmentFeature());
            if (m.getDiagramNode() != null) {
                this.diagramElementLabel.setText(m.getDiagramNode().getName());
            } else {
                this.diagramElementLabel.setText("");
            }
            this.linkMetaFeatureLabel.setText("");
        }

        private void refreshLinkDetails() {
            this.refreshCommonDetails((MappingEntry)this.selectedLink);
            LinkMapping l = this.selectedLink;
            if (l.getDiagramLink() != null) {
                this.diagramElementLabel.setText(l.getDiagramLink().getName());
            } else {
                this.diagramElementLabel.setText("");
            }
            this.affix(this.linkMetaFeatureLabel, (ENamedElement)l.getLinkMetaFeature());
        }

        void handleNodesListSelectionChange() {
            this.asNodeButton.setEnabled(false);
            this.asLinkButton.setEnabled(true);
            if (!$assertionsDisabled && this.nodesList.getSelectionIndex() == -1) {
                throw new AssertionError();
            }
            this.selectedNode = (NodeReference)EntriesPage.this.getMapInstance().getNodes().get(this.nodesList.getSelectionIndex());
            this.isNodeInSelection = true;
            this.refreshNodeDetails();
        }

        void handleLinksListSelectionChange() {
            if (!$assertionsDisabled && this.linksList.getSelectionIndex() == -1) {
                throw new AssertionError();
            }
            this.asLinkButton.setEnabled(false);
            this.selectedLink = (LinkMapping)EntriesPage.this.getMapInstance().getLinks().get(this.linksList.getSelectionIndex());
            this.asNodeButton.setEnabled(this.selectedLink.getDomainMetaElement() != null);
            this.isNodeInSelection = false;
            this.refreshLinkDetails();
        }

        static /* synthetic */ List access$0(PageControl pageControl) {
            return pageControl.nodesList;
        }

        static /* synthetic */ Button access$1(PageControl pageControl) {
            return pageControl.removeButton;
        }

        static /* synthetic */ Button access$2(PageControl pageControl) {
            return pageControl.changeDetailsButton;
        }

        static /* synthetic */ Button access$3(PageControl pageControl) {
            return pageControl.restoreButton;
        }

        static /* synthetic */ List access$4(PageControl pageControl) {
            return pageControl.linksList;
        }

        static /* synthetic */ boolean access$5(PageControl pageControl) {
            return pageControl.isNodeInSelection;
        }

        static /* synthetic */ NodeReference access$6(PageControl pageControl) {
            return pageControl.selectedNode;
        }

        static /* synthetic */ LinkMapping access$7(PageControl pageControl) {
            return pageControl.selectedLink;
        }

        static /* synthetic */ ILabelProvider access$8(PageControl pageControl) {
            return pageControl.myLabelProvider;
        }

        static /* synthetic */ Button access$9(PageControl pageControl) {
            return pageControl.asLinkButton;
        }

        static /* synthetic */ Button access$10(PageControl pageControl) {
            return pageControl.asNodeButton;
        }

        static /* synthetic */ void access$11(PageControl pageControl) {
            pageControl.populateNodesList();
        }

        static /* synthetic */ void access$12(PageControl pageControl) {
            pageControl.populateLinksList();
        }

        static /* synthetic */ EntriesPage access$13(PageControl pageControl) {
            return pageControl.EntriesPage.this;
        }
    }

    private class ChangePropertiesDialog
    extends Dialog {
        private Object[] mySelection;

        protected ChangePropertiesDialog(Shell parentShell, Object[] selection) {
            super(parentShell);
            this.setShellStyle(this.getShellStyle() | 0x10);
            this.mySelection = selection;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Composite frame = new Composite(composite, 2048);
            GridData layoutData = new GridData(1808);
            layoutData.heightHint = 300;
            layoutData.widthHint = 400;
            frame.setLayoutData((Object)layoutData);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            frame.setLayout((Layout)layout);
            PropertySheetPage propertyPage = new PropertySheetPage();
            propertyPage.createControl(frame);
            propertyPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(EntriesPage.this.myHolder.getAdapterFactory()));
            propertyPage.selectionChanged(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart(), (ISelection)new StructuredSelection(this.mySelection));
            propertyPage.getControl().setLayoutData((Object)new GridData(1808));
            return composite;
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }
}

