/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.Iterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.DecorationFigure;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureGallery;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.PolylineDecoration;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.internal.bridge.resolver.Resolution;
import org.eclipse.gmf.internal.bridge.resolver.ResolvedItem;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;

public class GraphDefBuilder {
    protected GMFGraphPackage gmfGraphPackage = GMFGraphPackage.eINSTANCE;
    protected GMFGraphFactory gmfGraphFactory = this.gmfGraphPackage.getGMFGraphFactory();

    public Canvas process(ResolvedItem item) {
        Canvas canvas = this.gmfGraphFactory.createCanvas();
        if (item != null) {
            EPackage ePackage = (EPackage)item.getDomainRef();
            canvas.setName(ePackage.getName());
            FigureGallery fGallery = this.gmfGraphFactory.createFigureGallery();
            fGallery.setName("default");
            canvas.getFigures().add((Object)fGallery);
            Iterator it = item.getChildren().iterator();
            while (it.hasNext()) {
                this.process((ResolvedItem)it.next(), canvas, fGallery);
            }
        }
        return canvas;
    }

    protected void process(ResolvedItem item, Canvas canvas, FigureGallery fGallery) {
        Node dElement;
        Rectangle figure;
        String baseName;
        boolean descend = false;
        if (item.getDomainRef() instanceof EClass) {
            EClass type = (EClass)item.getDomainRef();
            baseName = type.getName();
            if (item.getResolution() == Resolution.NODE) {
                figure = this.gmfGraphFactory.createRectangle();
                figure.setName(String.valueOf(baseName) + "Figure");
                fGallery.getFigures().add((Object)figure);
                dElement = this.gmfGraphFactory.createNode();
                dElement.setFigure((Figure)figure);
                dElement.setName(String.valueOf(baseName) + "Node");
                canvas.getNodes().add((Object)dElement);
                descend = true;
            } else if (item.getResolution() == Resolution.LINK) {
                figure = this.gmfGraphFactory.createPolylineConnection();
                figure.setName(String.valueOf(baseName) + "Figure");
                fGallery.getFigures().add((Object)figure);
                dElement = this.gmfGraphFactory.createConnection();
                dElement.setFigure((Figure)figure);
                dElement.setName(String.valueOf(baseName) + "Link");
                canvas.getConnections().add((Object)dElement);
                descend = true;
            }
        } else if (item.getDomainRef() instanceof EReference) {
            EReference ref = (EReference)item.getDomainRef();
            baseName = WizardUtil.getCapName((EStructuralFeature)ref);
            if (item.getResolution() == Resolution.LINK) {
                figure = this.gmfGraphFactory.createPolylineConnection();
                figure.setName(String.valueOf(baseName) + "Figure");
                PolylineDecoration decoration = this.gmfGraphFactory.createPolylineDecoration();
                decoration.setName(String.valueOf(baseName) + "TargetDecoration");
                figure.setTargetDecoration((DecorationFigure)decoration);
                fGallery.getFigures().add((Object)figure);
                Connection dElement2 = this.gmfGraphFactory.createConnection();
                dElement2.setFigure((Figure)figure);
                dElement2.setName(String.valueOf(baseName) + "Link");
                canvas.getConnections().add((Object)dElement2);
                descend = true;
            }
        } else if (item.getDomainRef() instanceof EAttribute) {
            EAttribute attr = (EAttribute)item.getDomainRef();
            baseName = WizardUtil.getCapName((EStructuralFeature)attr);
            if (item.getResolution() == Resolution.LABEL) {
                figure = this.gmfGraphFactory.createLabel();
                figure.setName(String.valueOf(baseName) + "Figure");
                fGallery.getFigures().add((Object)figure);
                dElement = this.gmfGraphFactory.createDiagramLabel();
                dElement.setFigure((Figure)figure);
                dElement.setName(String.valueOf(baseName) + "Label");
                canvas.getLabels().add((Object)dElement);
                descend = true;
            }
        }
        if (descend) {
            Iterator it = item.getChildren().iterator();
            while (it.hasNext()) {
                this.process((ResolvedItem)it.next(), canvas, fGallery);
            }
        }
    }
}

