/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.bridge.wizards.pages.GraphDefLookup;
import org.eclipse.gmf.internal.bridge.wizards.pages.ToolDefSupplier;
import org.eclipse.gmf.internal.bridge.wizards.pages.WizardInput;
import org.eclipse.gmf.internal.bridge.wizards.strategy.AccessibleClassNodeStrategy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.CompositeStrategy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.Hierarchy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.LeafNodeStrategy;
import org.eclipse.gmf.internal.bridge.wizards.strategy.Strategy;
import org.eclipse.gmf.mappings.GMFMapFactory;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.TopNodeReference;

public class MapDefFeeder {
    private final GraphDefLookup myGraphDefLookup;
    private final ToolDefSupplier myToolDefLookup;
    private Hierarchy myHierarchy;
    private final WizardInput myInputHolder;
    private List myNodeCandidates;
    private List myLinkCandidates;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.wizards.pages.MapDefFeeder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public MapDefFeeder(WizardInput holder, ToolDefSupplier toolDefSupplier) {
        if (!$assertionsDisabled && holder == null) {
            throw new AssertionError();
        }
        this.myInputHolder = holder;
        this.myGraphDefLookup = new GraphDefLookup(holder.getCanvasDef());
        this.myToolDefLookup = toolDefSupplier;
    }

    protected final Mapping getMapping() {
        return this.myInputHolder.getMapping();
    }

    public void feedDefaultMapping() {
        Hierarchy hierarchy = this.getHierarchy();
        this.myNodeCandidates = new UniqueEList((Collection)hierarchy.getAllClasses());
        this.createNodeFilter().filter(this.myNodeCandidates, hierarchy);
        this.myLinkCandidates = new ArrayList();
        this.createLinkFilter().filter(this.myLinkCandidates, hierarchy);
        this.myLinkCandidates.addAll(hierarchy.getAccessibleReferences(this.myNodeCandidates.iterator()));
        this.getMapping().getNodes().clear();
        this.getMapping().getNodes().addAll((Collection)this.nodesFrom(this.myNodeCandidates));
        this.getMapping().getLinks().clear();
        this.getMapping().getLinks().addAll((Collection)this.linksFrom(this.myLinkCandidates));
        this.getMapping().getDiagram().setPalette(this.myInputHolder.getToolDef().getPalette());
    }

    private Hierarchy getHierarchy() {
        if (this.myHierarchy == null) {
            this.myHierarchy = new Hierarchy(this.getMapping().getDiagram().getDomainMetaElement());
            this.myHierarchy.collect();
        }
        return this.myHierarchy;
    }

    private Strategy createNodeFilter() {
        return new CompositeStrategy(new Strategy[]{new AccessibleClassNodeStrategy(), new LeafNodeStrategy()});
    }

    private Strategy createLinkFilter() {
        return new Strategy(){

            public String getID() {
                throw new UnsupportedOperationException("QuickHack");
            }

            public void filter(Collection soFar, Hierarchy hierarchy) {
                UniqueEList linkCandidates = new UniqueEList((Collection)hierarchy.getAccessibleLinkClasses());
                Iterator iter = linkCandidates.iterator();
                while (iter.hasNext()) {
                    EClass element = (EClass)iter.next();
                    if (hierarchy.isLeaf(element)) continue;
                    iter.remove();
                }
                soFar.clear();
                soFar.addAll(linkCandidates);
            }
        };
    }

    private List nodesFrom(List candidates) {
        BasicEList rv = new BasicEList(candidates.size());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            EClass eClass = (EClass)iter.next();
            NodeMapping nm = GMFMapFactory.eINSTANCE.createNodeMapping();
            nm.setDomainMetaElement(eClass);
            nm.setDiagramNode(this.myGraphDefLookup.findSuitableNode(nm));
            this.addEditFeature((MappingEntry)nm, eClass);
            nm.setTool(this.myToolDefLookup.findTool(nm));
            TopNodeReference tnr = GMFMapFactory.eINSTANCE.createTopNodeReference();
            tnr.setContainmentFeature(this.getHierarchy().backRef(eClass));
            tnr.setOwnedChild(nm);
            rv.add((Object)tnr);
        }
        return rv;
    }

    private List linksFrom(List candidates) {
        BasicEList rv = new BasicEList(candidates.size());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            Object next = iter.next();
            LinkMapping lm = GMFMapFactory.eINSTANCE.createLinkMapping();
            if (next instanceof EClass) {
                EClass eClass = (EClass)next;
                lm.setDomainMetaElement(eClass);
                lm.setContainmentFeature(this.getHierarchy().backRef(eClass));
                this.addEditFeature((MappingEntry)lm, eClass);
                lm.setLinkMetaFeature((EStructuralFeature)this.getHierarchy().getLinkFeature(eClass));
            } else {
                lm.setLinkMetaFeature((EStructuralFeature)((EReference)next));
            }
            lm.setDiagramLink(this.myGraphDefLookup.findSuitableLink(lm));
            lm.setTool(this.myToolDefLookup.findTool(lm));
            rv.add((Object)lm);
        }
        return rv;
    }

    private void addEditFeature(MappingEntry me, EClass class1) {
        Iterator it = class1.getEAllAttributes().iterator();
        while (it.hasNext()) {
            EAttribute n = (EAttribute)it.next();
            if (!EcorePackage.eINSTANCE.getEString().equals(n.getEType())) continue;
            LabelMapping lm = GMFMapFactory.eINSTANCE.createLabelMapping();
            lm.getFeatures().add((Object)n);
            me.getLabelMappings().add((Object)lm);
            return;
        }
    }

    public NodeReference[] getInitialNodes() {
        return (NodeReference[])this.nodesFrom(this.myNodeCandidates).toArray(new NodeMapping[0]);
    }

    public LinkMapping[] getInitialLinks() {
        return this.linksFrom(this.myLinkCandidates).toArray(new LinkMapping[0]);
    }
}

