/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages;

import java.util.Iterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.internal.bridge.resolver.Resolution;
import org.eclipse.gmf.internal.bridge.resolver.ResolvedItem;
import org.eclipse.gmf.internal.bridge.wizards.WizardUtil;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.GMFToolFactory;
import org.eclipse.gmf.tooldef.GMFToolPackage;
import org.eclipse.gmf.tooldef.Image;
import org.eclipse.gmf.tooldef.Palette;
import org.eclipse.gmf.tooldef.ToolGroup;
import org.eclipse.gmf.tooldef.ToolRegistry;

public class ToolDefBuilder {
    protected GMFToolPackage gmfToolPackage = GMFToolPackage.eINSTANCE;
    protected GMFToolFactory gmfToolFactory = this.gmfToolPackage.getGMFToolFactory();

    public ToolRegistry process(ResolvedItem item) {
        ToolRegistry toolRegistry = this.gmfToolFactory.createToolRegistry();
        if (item != null) {
            EPackage ePackage = (EPackage)item.getDomainRef();
            Palette palette = this.gmfToolFactory.createPalette();
            toolRegistry.setPalette(palette);
            ToolGroup group = this.gmfToolFactory.createToolGroup();
            group.setTitle(ePackage.getName());
            palette.getTools().add((Object)group);
            Iterator it = item.getChildren().iterator();
            while (it.hasNext()) {
                this.process((ResolvedItem)it.next(), toolRegistry, group);
            }
        }
        return toolRegistry;
    }

    protected void process(ResolvedItem item, ToolRegistry toolRegistry, ToolGroup group) {
        String baseName;
        boolean descend = false;
        if (item.getDomainRef() instanceof EClass) {
            EClass type = (EClass)item.getDomainRef();
            baseName = type.getName();
            if (item.getResolution() == Resolution.NODE || item.getResolution() == Resolution.LINK) {
                this.addCreationTool(baseName, group);
                descend = true;
            }
        } else if (item.getDomainRef() instanceof EReference) {
            EReference ref = (EReference)item.getDomainRef();
            baseName = WizardUtil.getCapName((EStructuralFeature)ref);
            if (item.getResolution() == Resolution.LINK) {
                this.addCreationTool(baseName, group);
                descend = true;
            }
        }
        if (descend) {
            Iterator it = item.getChildren().iterator();
            while (it.hasNext()) {
                this.process((ResolvedItem)it.next(), toolRegistry, group);
            }
        }
    }

    protected CreationTool addCreationTool(String baseName, ToolGroup group) {
        CreationTool tool = this.gmfToolFactory.createCreationTool();
        tool.setTitle(baseName);
        tool.setDescription("Create new " + baseName);
        tool.setSmallIcon((Image)this.gmfToolFactory.createDefaultImage());
        tool.setLargeIcon((Image)this.gmfToolFactory.createDefaultImage());
        group.getTools().add((Object)tool);
        return tool;
    }
}

