/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.bridge.genmodel;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.emf.codegen.ecore.genmodel.GenClass;
import org.eclipse.emf.codegen.ecore.genmodel.GenFeature;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.bridge.genmodel.GenModelMatcher;
import org.eclipse.gmf.bridge.genmodel.InnerClassViewmapProducer;
import org.eclipse.gmf.bridge.genmodel.MappingTransformer;
import org.eclipse.gmf.bridge.genmodel.ViewmapProducer;
import org.eclipse.gmf.codegen.gmfgen.CompositeFeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.EntryBase;
import org.eclipse.gmf.codegen.gmfgen.FeatureLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.FeatureLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.GenAuditContainer;
import org.eclipse.gmf.codegen.gmfgen.GenAuditRule;
import org.eclipse.gmf.codegen.gmfgen.GenAuditable;
import org.eclipse.gmf.codegen.gmfgen.GenAuditedMetricTarget;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenConstraint;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenDiagramElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenDomainElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenElementInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureSeqInitializer;
import org.eclipse.gmf.codegen.gmfgen.GenFeatureValueSpec;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkConstraints;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNotationElementTarget;
import org.eclipse.gmf.codegen.gmfgen.GenPlugin;
import org.eclipse.gmf.codegen.gmfgen.GenSeverity;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.gmfgen.LabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.LinkEntry;
import org.eclipse.gmf.codegen.gmfgen.LinkLabelAlignment;
import org.eclipse.gmf.codegen.gmfgen.LinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.NodeEntry;
import org.eclipse.gmf.codegen.gmfgen.Palette;
import org.eclipse.gmf.codegen.gmfgen.ProviderPriority;
import org.eclipse.gmf.codegen.gmfgen.TextLabelModelFacet;
import org.eclipse.gmf.codegen.gmfgen.ToolGroup;
import org.eclipse.gmf.codegen.gmfgen.TypeLinkModelFacet;
import org.eclipse.gmf.codegen.gmfgen.TypeModelFacet;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.AlignmentFacet;
import org.eclipse.gmf.gmfgraph.Compartment;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.internal.bridge.History;
import org.eclipse.gmf.internal.bridge.NaiveIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.VisualIdentifierDispenser;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.mappings.AuditContainer;
import org.eclipse.gmf.mappings.AuditRule;
import org.eclipse.gmf.mappings.Auditable;
import org.eclipse.gmf.mappings.AuditedMetricTarget;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.ChildReference;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.Constraint;
import org.eclipse.gmf.mappings.DiagramElementTarget;
import org.eclipse.gmf.mappings.DomainElementTarget;
import org.eclipse.gmf.mappings.ElementInitializer;
import org.eclipse.gmf.mappings.FeatureSeqInitializer;
import org.eclipse.gmf.mappings.FeatureValueSpec;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkConstraints;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;
import org.eclipse.gmf.mappings.NodeReference;
import org.eclipse.gmf.mappings.NotationElementTarget;
import org.eclipse.gmf.mappings.Severity;
import org.eclipse.gmf.mappings.ToolOwner;
import org.eclipse.gmf.mappings.TopNodeReference;
import org.eclipse.gmf.tooldef.AbstractTool;
import org.eclipse.gmf.tooldef.BundleImage;
import org.eclipse.gmf.tooldef.CreationTool;
import org.eclipse.gmf.tooldef.ToolContainer;

public class DiagramGenModelTransformer
extends MappingTransformer {
    private GenEditorGenerator myGenModel;
    protected GenModelMatcher myGenModelMatch;
    private final DiagramRunTimeModelHelper myDRTHelper;
    private final ViewmapProducer myViewmaps = new InnerClassViewmapProducer();
    private final VisualIdentifierDispenser myVisualIDs;
    private final History myHistory;
    private final GenModelNamingMediator myNamingStrategy;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.bridge.genmodel.DiagramGenModelTransformer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public DiagramGenModelTransformer(DiagramRunTimeModelHelper drtHelper, GenModelNamingMediator namingStrategy) {
        this.myDRTHelper = drtHelper;
        this.myNamingStrategy = namingStrategy;
        this.myVisualIDs = new NaiveIdentifierDispenser();
        this.myHistory = new History();
    }

    public void setEMFGenModel(GenModel emfGenModel) {
        this.myGenModelMatch = new GenModelMatcher(emfGenModel);
    }

    public GenEditorGenerator getResult() {
        return this.getGenEssence();
    }

    private GenEditorGenerator getGenEssence() {
        if (this.myGenModel == null) {
            this.myGenModel = GMFGenFactory.eINSTANCE.createGenEditorGenerator();
        }
        if (this.myGenModel.getEditor() == null) {
            this.myGenModel.setEditor(GMFGenFactory.eINSTANCE.createGenEditorView());
        }
        return this.myGenModel;
    }

    private GenDiagram getGenDiagram() {
        if (this.getGenEssence().getDiagram() == null) {
            this.getGenEssence().setDiagram(GMFGenFactory.eINSTANCE.createGenDiagram());
        }
        return this.getGenEssence().getDiagram();
    }

    private GenPlugin getGenPlugin() {
        if (this.getGenEssence().getPlugin() == null) {
            this.getGenEssence().setPlugin(GMFGenFactory.eINSTANCE.createGenPlugin());
        }
        return this.getGenEssence().getPlugin();
    }

    private Palette getGenPalette() {
        Palette p = this.getGenDiagram().getPalette();
        if (p == null) {
            p = GMFGenFactory.eINSTANCE.createPalette();
            this.getGenDiagram().setPalette(p);
        }
        return p;
    }

    protected void process(CanvasMapping mapping) {
        if (!$assertionsDisabled && mapping.getDomainModel() == null) {
            throw new AssertionError();
        }
        if (this.myGenModelMatch == null) {
            this.myGenModelMatch = new GenModelMatcher(mapping.getDomainModel());
        }
        this.myHistory.purge();
        GenPackage primaryPackage = this.findGenPackage(mapping.getDomainModel());
        this.getGenEssence().setDomainGenModel(primaryPackage == null ? null : primaryPackage.getGenModel());
        if (this.getGenEssence().getDomainGenModel() != null) {
            this.getGenEssence().setModelID(this.getGenEssence().getDomainGenModel().getModelName());
        }
        this.getGenDiagram().setDomainDiagramElement(this.findGenClass(mapping.getDomainMetaElement()));
        this.getGenDiagram().setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        this.getGenDiagram().setVisualID(this.myVisualIDs.get(this.getGenDiagram()));
        this.getGenPlugin().setName(String.valueOf(mapping.getDomainModel().getName()) + " Plugin");
        this.getGenDiagram().setViewmap(this.myViewmaps.create(mapping.getDiagramCanvas()));
        this.getGenDiagram().setIconProviderPriority(ProviderPriority.LOW_LITERAL);
        this.myNamingStrategy.feed(this.getGenDiagram(), mapping);
    }

    protected void process(TopNodeReference topNode) {
        NodeMapping nme = topNode.getChild();
        if (!$assertionsDisabled && nme == null) {
            throw new AssertionError();
        }
        this.assertNodeMapping(nme);
        GenTopLevelNode genNode = GMFGenFactory.eINSTANCE.createGenTopLevelNode();
        this.getGenDiagram().getTopLevelNodes().add((Object)genNode);
        genNode.setDiagramRunTimeClass(this.findRunTimeClass(nme));
        genNode.setModelFacet(this.createModelFacet((NodeReference)topNode));
        genNode.setVisualID(this.myVisualIDs.get((GenNode)genNode));
        genNode.setViewmap(this.myViewmaps.create(nme.getDiagramNode()));
        this.handleNodeTool((ToolOwner)nme, (GenNode)genNode);
        this.myNamingStrategy.feed(genNode, nme);
        this.processAbstractNode(nme, (GenNode)genNode);
        this.myHistory.log(nme, genNode);
    }

    private void process(ChildReference childNodeRef, GenChildContainer container) {
        GenChildNode childNode;
        NodeMapping childNodeMapping = childNodeRef.getChild();
        if (!$assertionsDisabled && childNodeMapping == null) {
            throw new AssertionError();
        }
        this.assertNodeMapping(childNodeMapping);
        if (!$assertionsDisabled && childNodeMapping.getDiagramNode() == null) {
            throw new AssertionError();
        }
        if (this.myHistory.isKnownChildNode(childNodeMapping)) {
            childNode = this.myHistory.findChildNode(childNodeMapping);
        } else {
            childNode = GMFGenFactory.eINSTANCE.createGenChildNode();
            this.myHistory.log(childNodeMapping, childNode);
            this.getGenDiagram().getChildNodes().add((Object)childNode);
            childNode.setModelFacet(this.createModelFacet((NodeReference)childNodeRef));
            childNode.setDiagramRunTimeClass(this.findRunTimeClass(childNodeMapping));
            childNode.setViewmap(this.myViewmaps.create(childNodeMapping.getDiagramNode()));
            childNode.setVisualID(this.myVisualIDs.get(childNode));
            this.myNamingStrategy.feed(childNode, childNodeMapping);
            this.handleNodeTool((ToolOwner)childNodeMapping, (GenNode)childNode);
            this.processAbstractNode(childNodeMapping, (GenNode)childNode);
        }
        if (childNodeMapping.getChildren().size() > 0) {
            container.setListLayout(false);
        }
        container.getChildNodes().add((Object)childNode);
    }

    private void processAbstractNode(NodeMapping mapping, GenNode genNode) {
        HashMap<CompartmentMapping, GenCompartment> compartments2GenCompartmentsMap = new HashMap<CompartmentMapping, GenCompartment>();
        Iterator it = mapping.getCompartments().iterator();
        while (it.hasNext()) {
            CompartmentMapping compartmentMapping = (CompartmentMapping)it.next();
            GenCompartment compartmentGen = this.createGenCompartment(compartmentMapping);
            genNode.getCompartments().add((Object)compartmentGen);
            compartments2GenCompartmentsMap.put(compartmentMapping, compartmentGen);
        }
        it = mapping.getChildren().iterator();
        while (it.hasNext()) {
            ChildReference childNodeRef = (ChildReference)it.next();
            CompartmentMapping compartmentMapping = childNodeRef.getCompartment();
            Object genChildContainer = compartmentMapping != null && compartments2GenCompartmentsMap.containsKey(compartmentMapping) ? (GenChildContainer)compartments2GenCompartmentsMap.get(compartmentMapping) : genNode;
            this.process(childNodeRef, (GenChildContainer)genChildContainer);
        }
        Iterator labels = mapping.getLabelMappings().iterator();
        while (labels.hasNext()) {
            LabelMapping labelMapping = (LabelMapping)labels.next();
            GenNodeLabel label = this.createNodeLabel(genNode, labelMapping);
            this.myNamingStrategy.feed(label, labelMapping);
            genNode.getLabels().add((Object)label);
        }
    }

    private GenCompartment createGenCompartment(CompartmentMapping mapping) {
        Compartment compartment = mapping.getCompartment();
        if (!$assertionsDisabled && compartment == null) {
            throw new AssertionError();
        }
        GenCompartment childCompartment = GMFGenFactory.eINSTANCE.createGenCompartment();
        this.getGenDiagram().getCompartments().add((Object)childCompartment);
        childCompartment.setVisualID(this.myVisualIDs.get(childCompartment));
        childCompartment.setDiagramRunTimeClass(this.getChildContainerRunTimeClass());
        childCompartment.setViewmap(this.myViewmaps.create(mapping.getCompartment()));
        childCompartment.setCanCollapse(compartment.isCollapsible());
        childCompartment.setNeedsTitle(compartment.isNeedsTitle());
        childCompartment.setTitle(compartment.getName());
        this.myNamingStrategy.feed(childCompartment, mapping);
        return childCompartment;
    }

    protected void process(LinkMapping lme) {
        this.assertLinkMapping(lme);
        GenLink gl = GMFGenFactory.eINSTANCE.createGenLink();
        this.getGenDiagram().getLinks().add((Object)gl);
        gl.setModelFacet(this.createModelFacet(lme));
        if (lme.getTool() instanceof CreationTool) {
            LinkEntry le = GMFGenFactory.eINSTANCE.createLinkEntry();
            le.setEntryID(this.myVisualIDs.get(le));
            this.findToolGroup(lme.getTool()).getLinkTools().add((Object)le);
            le.getGenLink().add((Object)gl);
            this.setupCommonToolEntry((EntryBase)le, lme.getTool());
        }
        Iterator labels = lme.getLabelMappings().iterator();
        while (labels.hasNext()) {
            LabelMapping labelMapping = (LabelMapping)labels.next();
            GenLinkLabel label = this.createLinkLabel(gl, labelMapping);
            this.myNamingStrategy.feed(label, labelMapping);
            gl.getLabels().add((Object)label);
        }
        gl.setDiagramRunTimeClass(this.findRunTimeClass(lme));
        gl.setVisualID(this.myVisualIDs.get(gl));
        this.myNamingStrategy.feed(gl, lme);
        gl.setViewmap(this.myViewmaps.create(lme.getDiagramLink()));
        if (lme.getCreationConstraints() != null) {
            gl.setCreationConstraints(this.createLinkCreationConstraints(lme.getCreationConstraints()));
        }
        this.myHistory.log(lme, gl);
    }

    private GenNodeLabel createNodeLabel(GenNode node, LabelMapping mapping) {
        Object label = mapping.getDiagramLabel().getFigure().getParent() == null ? GMFGenFactory.eINSTANCE.createGenExternalNodeLabel() : GMFGenFactory.eINSTANCE.createGenNodeLabel();
        label.setVisualID(this.myVisualIDs.get((GenNodeLabel)label));
        label.setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        label.setViewmap(this.myViewmaps.create(mapping.getDiagramLabel()));
        label.setModelFacet(this.createLabelModelFacet(mapping));
        return label;
    }

    private GenLinkLabel createLinkLabel(GenLink link, LabelMapping mapping) {
        GenLinkLabel label = GMFGenFactory.eINSTANCE.createGenLinkLabel();
        label.setVisualID(this.myVisualIDs.get(label));
        label.setDiagramRunTimeClass(this.findRunTimeClass(mapping));
        label.setViewmap(this.myViewmaps.create(mapping.getDiagramLabel()));
        label.setModelFacet(this.createLabelModelFacet(mapping));
        DiagramLabel diagramLabel = mapping.getDiagramLabel();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.gmf.gmfgraph.AlignmentFacet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (diagramLabel.find((Class)clazz) != null) {
            DiagramLabel diagramLabel2 = mapping.getDiagramLabel();
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.gmf.gmfgraph.AlignmentFacet");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            AlignmentFacet af = (AlignmentFacet)diagramLabel2.find((Class)clazz2);
            label.setAlignment(this.getLinkLabelAlignment(af.getAlignment()));
        }
        return label;
    }

    private LinkLabelAlignment getLinkLabelAlignment(Alignment alignment) {
        switch (alignment.getValue()) {
            case 0: {
                return LinkLabelAlignment.SOURCE_LITERAL;
            }
            case 1: {
                return LinkLabelAlignment.MIDDLE_LITERAL;
            }
            case 2: {
                return LinkLabelAlignment.TARGET_LITERAL;
            }
        }
        throw new IllegalArgumentException("Link doesn't support alignment:" + alignment.getName());
    }

    private LabelModelFacet createLabelModelFacet(LabelMapping mapping) {
        String text = mapping.getText();
        if (text != null && text.length() > 0) {
            TextLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createTextLabelModelFacet();
            modelFacet.setText(text);
            return modelFacet;
        }
        if (mapping.getFeatures().size() == 1) {
            FeatureLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createFeatureLabelModelFacet();
            modelFacet.setMetaFeature(this.findGenFeature((EStructuralFeature)((EAttribute)mapping.getFeatures().get(0))));
            String defaultText = mapping.getDefaultText();
            if (defaultText == null || defaultText.length() == 0) {
                defaultText = "<...>";
            }
            modelFacet.setDefaultText(defaultText);
            modelFacet.setViewPattern(mapping.getViewPattern());
            modelFacet.setEditPattern(mapping.getEditPattern());
            return modelFacet;
        }
        if (mapping.getFeatures().size() > 1) {
            CompositeFeatureLabelModelFacet modelFacet = GMFGenFactory.eINSTANCE.createCompositeFeatureLabelModelFacet();
            Iterator features = mapping.getFeatures().iterator();
            while (features.hasNext()) {
                modelFacet.getMetaFeatures().add((Object)this.findGenFeature((EStructuralFeature)((EAttribute)features.next())));
            }
            modelFacet.setViewPattern(mapping.getViewPattern());
            modelFacet.setEditPattern(mapping.getEditPattern());
            return modelFacet;
        }
        throw new IllegalArgumentException("Model facet of a label is undefined " + mapping);
    }

    private GenClass findRunTimeClass(NodeMapping nme) {
        return this.myDRTHelper.get(nme);
    }

    private GenClass findRunTimeClass(LinkMapping lme) {
        return this.myDRTHelper.get(lme);
    }

    private GenClass findRunTimeClass(CanvasMapping mapping) {
        return this.myDRTHelper.get(mapping);
    }

    private GenClass getChildContainerRunTimeClass() {
        return this.myDRTHelper.getChildContainerDefault();
    }

    private GenClass findRunTimeClass(LabelMapping mapping) {
        return this.myDRTHelper.get(mapping);
    }

    private void handleNodeTool(ToolOwner nme, GenNode genNode) {
        if (nme.getTool() != null && nme.getTool() instanceof CreationTool) {
            NodeEntry ne = GMFGenFactory.eINSTANCE.createNodeEntry();
            ne.setEntryID(this.myVisualIDs.get(ne));
            this.findToolGroup(nme.getTool()).getNodeTools().add((Object)ne);
            ne.getGenNode().add((Object)genNode);
            this.setupCommonToolEntry((EntryBase)ne, nme.getTool());
        }
    }

    private void setupCommonToolEntry(EntryBase te, AbstractTool tool) {
        te.setTitleKey(tool.getTitle() == null ? "" : tool.getTitle());
        te.setDescriptionKey(tool.getDescription());
        if (tool.getLargeIcon() instanceof BundleImage) {
            te.setLargeIconPath(((BundleImage)tool.getLargeIcon()).getPath());
        }
        if (tool.getSmallIcon() instanceof BundleImage) {
            te.setSmallIconPath(((BundleImage)tool.getSmallIcon()).getPath());
        }
    }

    private ToolGroup findToolGroup(AbstractTool tool) {
        if (!$assertionsDisabled && tool.eContainer() == null) {
            throw new AssertionError();
        }
        ToolContainer tc = (ToolContainer)tool.eContainer();
        String groupName = tc.getTitle() == null ? "" : tc.getTitle();
        Iterator it = this.getGenPalette().getGroups().iterator();
        while (it.hasNext()) {
            ToolGroup next = (ToolGroup)it.next();
            if (!groupName.equals(next.getTitleKey())) continue;
            return next;
        }
        ToolGroup tg = GMFGenFactory.eINSTANCE.createToolGroup();
        tg.setEntryID(this.myVisualIDs.get(tg));
        this.getGenPalette().getGroups().add((Object)tg);
        this.setupCommonToolEntry((EntryBase)tg, (AbstractTool)tc);
        return tg;
    }

    private void assertNodeMapping(NodeMapping mapping) {
        if (!$assertionsDisabled && mapping.getDomainContext() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && mapping.getDiagramNode() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !DiagramGenModelTransformer.checkLabelMappings((MappingEntry)mapping)) {
            throw new AssertionError();
        }
    }

    private void assertLinkMapping(LinkMapping linkMapping) {
        if (!$assertionsDisabled && linkMapping.getDiagramLink() == null) {
            throw new AssertionError();
        }
        if (linkMapping.getDomainMetaElement() != null && !$assertionsDisabled && linkMapping.getLinkMetaFeature() == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && !DiagramGenModelTransformer.checkLabelMappings((MappingEntry)linkMapping)) {
            throw new AssertionError();
        }
    }

    private static boolean checkLabelMappings(MappingEntry entry) {
        boolean ok = true;
        Iterator it = entry.getLabelMappings().iterator();
        while (ok && it.hasNext()) {
            ok = DiagramGenModelTransformer.checkLabelFeatureValidity((LabelMapping)it.next());
        }
        return ok;
    }

    private static boolean checkLabelFeatureValidity(LabelMapping labelMapping) {
        EClass domainElement = labelMapping.getMapEntry().getDomainContext();
        boolean isOk = true;
        Iterator it = labelMapping.getFeatures().iterator();
        while (isOk && it.hasNext()) {
            EClass attrContainer = ((EAttribute)it.next()).getEContainingClass();
            isOk = attrContainer.isSuperTypeOf(domainElement);
        }
        return isOk;
    }

    private GenPackage findGenPackage(EPackage ePackage) {
        return this.myGenModelMatch.findGenPackage(ePackage);
    }

    private GenClass findGenClass(EClass eClass) {
        return this.myGenModelMatch.findGenClass(eClass);
    }

    private GenFeature findGenFeature(EStructuralFeature feature) {
        return this.myGenModelMatch.findGenFeature(feature);
    }

    private TypeModelFacet createModelFacet(NodeReference anm) {
        NodeMapping nodeMapping = anm.getChild();
        TypeModelFacet typeModelFacet = this.setupModelFacet(nodeMapping.getDomainContext(), (EStructuralFeature)anm.getContainmentFeature(), (EStructuralFeature)anm.getChildrenFeature());
        return this.setupAux(typeModelFacet, nodeMapping.getDomainSpecialization(), nodeMapping.getDomainInitializer());
    }

    private LinkModelFacet createModelFacet(LinkMapping lme) {
        if (lme.getDomainMetaElement() != null) {
            TypeLinkModelFacet mf = GMFGenFactory.eINSTANCE.createTypeLinkModelFacet();
            mf.setMetaClass(this.findGenClass(lme.getDomainMetaElement()));
            mf.setContainmentMetaFeature(this.findGenFeature((EStructuralFeature)lme.getContainmentFeature()));
            mf.setChildMetaFeature(mf.getContainmentMetaFeature());
            mf.setSourceMetaFeature(this.findGenFeature(lme.getSourceMetaFeature()));
            mf.setTargetMetaFeature(this.findGenFeature(lme.getLinkMetaFeature()));
            this.setupAux((TypeModelFacet)mf, lme.getDomainSpecialization(), lme.getDomainInitializer());
            return mf;
        }
        if (lme.getLinkMetaFeature() != null) {
            FeatureLinkModelFacet mf = GMFGenFactory.eINSTANCE.createFeatureLinkModelFacet();
            mf.setMetaFeature(this.findGenFeature(lme.getLinkMetaFeature()));
            return mf;
        }
        return null;
    }

    private GenLinkConstraints createLinkCreationConstraints(LinkConstraints constraints) {
        Constraint targetConstraint;
        LinkMapping lme = constraints.getLinkMapping();
        if (lme == null) {
            return null;
        }
        GenLinkConstraints genConstraints = GMFGenFactory.eINSTANCE.createGenLinkConstraints();
        Constraint sourceConstraint = constraints.getSourceEnd();
        if (sourceConstraint != null) {
            genConstraints.setSourceEnd(this.createGenConstraint(sourceConstraint));
        }
        if ((targetConstraint = constraints.getTargetEnd()) != null) {
            genConstraints.setTargetEnd(this.createGenConstraint(targetConstraint));
        }
        return genConstraints;
    }

    private TypeModelFacet setupModelFacet(EClass domainMetaElement, EStructuralFeature containmentFeature, EStructuralFeature childFeature) {
        TypeModelFacet mf = GMFGenFactory.eINSTANCE.createTypeModelFacet();
        mf.setMetaClass(this.findGenClass(domainMetaElement));
        mf.setContainmentMetaFeature(this.findGenFeature(containmentFeature));
        mf.setChildMetaFeature(childFeature == null ? mf.getContainmentMetaFeature() : this.findGenFeature(childFeature));
        return mf;
    }

    private TypeModelFacet setupAux(TypeModelFacet typeModelFacet, Constraint spec, ElementInitializer init) {
        if (spec != null) {
            typeModelFacet.setModelElementSelector(this.createGenConstraint(spec));
        }
        if (init != null) {
            typeModelFacet.setModelElementInitializer(this.createElementInitializer(init));
        }
        return typeModelFacet;
    }

    private GenElementInitializer createElementInitializer(ElementInitializer elementInitializer) {
        if (elementInitializer instanceof FeatureSeqInitializer) {
            FeatureSeqInitializer fsInitializer = (FeatureSeqInitializer)elementInitializer;
            GenFeatureSeqInitializer fSeqInitializer = GMFGenFactory.eINSTANCE.createGenFeatureSeqInitializer();
            Iterator it = fsInitializer.getInitializers().iterator();
            while (it.hasNext()) {
                FeatureValueSpec nextValSpec = (FeatureValueSpec)it.next();
                GenFeatureValueSpec nextGenValSpec = GMFGenFactory.eINSTANCE.createGenFeatureValueSpec();
                nextGenValSpec.setBody(nextValSpec.getBody());
                nextGenValSpec.setLanguage(nextValSpec.getLanguage());
                nextGenValSpec.setFeature(this.findGenFeature(nextValSpec.getFeature()));
                fSeqInitializer.getInitializers().add((Object)nextGenValSpec);
            }
            return fSeqInitializer;
        }
        return null;
    }

    private GenConstraint createGenConstraint(Constraint constraint) {
        if (constraint.getBody() == null) {
            return null;
        }
        GenConstraint modelElementSelector = GMFGenFactory.eINSTANCE.createGenConstraint();
        modelElementSelector.setBody(constraint.getBody());
        modelElementSelector.setLanguage(constraint.getLanguage());
        return modelElementSelector;
    }

    private GenAuditContainer createGenAuditContainer(AuditContainer ac) {
        GenAuditContainer gac = GMFGenFactory.eINSTANCE.createGenAuditContainer();
        gac.setId(ac.getId());
        gac.setName(ac.getName());
        gac.setDescription(ac.getDescription());
        Iterator it = ac.getChildContainers().iterator();
        while (it.hasNext()) {
            AuditContainer nextChild = (AuditContainer)it.next();
            gac.getChildContainers().add((Object)this.createGenAuditContainer(nextChild));
        }
        it = ac.getAudits().iterator();
        while (it.hasNext()) {
            gac.getAudits().add((Object)this.createGenAudit((AuditRule)it.next()));
        }
        return gac;
    }

    private GenAuditRule createGenAudit(AuditRule audit) {
        Constraint rule;
        GenAuditRule genAudit = GMFGenFactory.eINSTANCE.createGenAuditRule();
        genAudit.setId(audit.getId());
        genAudit.setName(audit.getName());
        genAudit.setMessage(audit.getMessage());
        genAudit.setDescription(audit.getDescription());
        genAudit.setUseInLiveMode(audit.isUseInLiveMode());
        if (audit.getTarget() != null) {
            genAudit.setTarget(this.createRuleTarget(audit.getTarget()));
        }
        if ((rule = audit.getRule()) != null) {
            genAudit.setRule(this.createGenConstraint(rule));
        }
        Severity severity = audit.getSeverity();
        GenSeverity genSeverity = null;
        if (severity == Severity.INFO_LITERAL) {
            genSeverity = GenSeverity.INFO_LITERAL;
        } else if (severity == Severity.WARNING_LITERAL) {
            genSeverity = GenSeverity.WARNING_LITERAL;
        } else if (severity == Severity.ERROR_LITERAL) {
            genSeverity = GenSeverity.ERROR_LITERAL;
        }
        if (genSeverity != null) {
            genAudit.setSeverity(genSeverity);
        }
        return genAudit;
    }

    private GenAuditable createRuleTarget(Auditable ruleTarget) {
        if (ruleTarget instanceof DomainElementTarget) {
            DomainElementTarget domainTarget = (DomainElementTarget)ruleTarget;
            GenDomainElementTarget genDomainTarget = GMFGenFactory.eINSTANCE.createGenDomainElementTarget();
            genDomainTarget.setElement(domainTarget.getElement() != null ? this.findGenClass(domainTarget.getElement()) : null);
            return genDomainTarget;
        }
        if (ruleTarget instanceof NotationElementTarget) {
            NotationElementTarget notationTarget = (NotationElementTarget)ruleTarget;
            GenNotationElementTarget genNotationTarget = GMFGenFactory.eINSTANCE.createGenNotationElementTarget();
            genNotationTarget.setElement(notationTarget.getElement() != null ? this.findGenClass(notationTarget.getElement()) : null);
            return genNotationTarget;
        }
        if (ruleTarget instanceof DiagramElementTarget) {
            GenDiagramElementTarget diagramTarget = GMFGenFactory.eINSTANCE.createGenDiagramElementTarget();
            MappingEntry mappingEntry = ((DiagramElementTarget)ruleTarget).getElement();
            if (mappingEntry != null) {
                LinkMapping lm;
                GenLink genBase = null;
                LinkMapping linkMapping = lm = mappingEntry instanceof LinkMapping ? (LinkMapping)mappingEntry : null;
                if (lm != null) {
                    genBase = this.myHistory.find(lm);
                } else {
                    NodeMapping nm = mappingEntry instanceof NodeMapping ? (NodeMapping)mappingEntry : null;
                    genBase = this.myHistory.find(nm);
                }
                if (!$assertionsDisabled && genBase == null) {
                    throw new AssertionError();
                }
                diagramTarget.setElement((GenCommonBase)genBase);
            }
            return diagramTarget;
        }
        if (ruleTarget instanceof AuditedMetricTarget) {
            GenAuditedMetricTarget genMetricTarget = GMFGenFactory.eINSTANCE.createGenAuditedMetricTarget();
            return genMetricTarget;
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)"Uknown rule target type");
        }
        return null;
    }

    protected void process(AuditContainer audits) {
        if (audits != null) {
            this.getGenEssence().setAudits(this.createGenAuditContainer(audits));
        }
    }
}

