/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.bridge.genmodel;

import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.bridge.genmodel.DefaultViewmapProducer;
import org.eclipse.gmf.codegen.gmfgen.FigureViewmap;
import org.eclipse.gmf.codegen.gmfgen.GMFGenFactory;
import org.eclipse.gmf.codegen.gmfgen.InnerClassViewmap;
import org.eclipse.gmf.codegen.gmfgen.Viewmap;
import org.eclipse.gmf.common.codegen.ImportAssistant;
import org.eclipse.gmf.common.codegen.NullImportAssistant;
import org.eclipse.gmf.gmfgraph.Child;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.DiagramLabel;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.GMFGraphPackage;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.util.FigureQualifiedNameSwitch;
import org.eclipse.gmf.gmfgraph.util.RuntimeFQNSwitch;
import org.eclipse.gmf.graphdef.codegen.FigureGenerator;
import org.osgi.framework.Bundle;

public class InnerClassViewmapProducer
extends DefaultViewmapProducer {
    private final FigureGenerator figureGenerator;
    private final FigureQualifiedNameSwitch fqnSwitch = new RuntimeFQNSwitch();

    public InnerClassViewmapProducer() {
        this.figureGenerator = new FigureGenerator(null, (ImportAssistant)new NullImportAssistant(), this.fqnSwitch);
    }

    public Viewmap create(Node node) {
        if (node.getFigure() == null) {
            return super.create(node);
        }
        try {
            return this.createViewmap(node.getFigure());
        }
        catch (JETException ex) {
            InnerClassViewmapProducer.log(ex);
            return super.create(node);
        }
    }

    public Viewmap create(Child child) {
        if (child.getFigure() == null) {
            return super.create(child);
        }
        try {
            return this.createViewmap(child.getFigure());
        }
        catch (JETException ex) {
            InnerClassViewmapProducer.log(ex);
            return super.create(child);
        }
    }

    public Viewmap create(Connection link) {
        if (link.getFigure() == null) {
            return super.create(link);
        }
        try {
            return this.createViewmap(link.getFigure());
        }
        catch (JETException ex) {
            InnerClassViewmapProducer.log(ex);
            return super.create(link);
        }
    }

    public Viewmap create(DiagramLabel label) {
        if (label.getFigure() == null) {
            return super.create(label);
        }
        try {
            return this.createViewmap(label.getFigure());
        }
        catch (JETException ex) {
            InnerClassViewmapProducer.log(ex);
            return super.create(label);
        }
    }

    private Viewmap createViewmap(Figure figure) throws JETException {
        if (figure instanceof CustomFigure && InnerClassViewmapProducer.isBareInstance(figure)) {
            FigureViewmap v = GMFGenFactory.eINSTANCE.createFigureViewmap();
            v.setFigureQualifiedClassName(String.valueOf(this.fqnSwitch.doSwitch((EObject)figure)));
            return v;
        }
        InnerClassViewmap v = GMFGenFactory.eINSTANCE.createInnerClassViewmap();
        v.setClassBody(this.figureGenerator.go(figure));
        v.setClassName(figure.getName());
        return v;
    }

    private static boolean isBareInstance(Figure figure) {
        if (!figure.getChildren().isEmpty()) {
            return false;
        }
        LinkedList featuresToCheck = new LinkedList(figure.eClass().getEAllStructuralFeatures());
        featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getIdentity_Name());
        if (figure instanceof CustomFigure) {
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_BundleName());
            featuresToCheck.remove(GMFGraphPackage.eINSTANCE.getCustomClass_QualifiedClassName());
        }
        Iterator it = featuresToCheck.iterator();
        while (it.hasNext()) {
            if (!figure.eIsSet((EStructuralFeature)it.next())) continue;
            return false;
        }
        return true;
    }

    private static void log(JETException ex) {
        Platform.getLog((Bundle)Platform.getBundle((String)"org.eclipse.gmf.bridge")).log(ex.getStatus());
    }
}

