/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.naming;

import java.util.Iterator;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.gmf.internal.bridge.naming.AbstractNamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.CollectingDispenser;
import org.eclipse.gmf.internal.bridge.naming.NamingStrategy;
import org.eclipse.gmf.internal.bridge.naming.UniqueValueDispenser;
import org.eclipse.gmf.mappings.CanvasMapping;
import org.eclipse.gmf.mappings.CompartmentMapping;
import org.eclipse.gmf.mappings.LabelMapping;
import org.eclipse.gmf.mappings.LinkMapping;
import org.eclipse.gmf.mappings.MappingEntry;
import org.eclipse.gmf.mappings.NodeMapping;

public class ClassNameStrategy
extends AbstractNamingStrategy {
    private final String mySuffix;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.bridge.naming.ClassNameStrategy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public ClassNameStrategy(String suffix) {
        this(suffix, null, new CollectingDispenser());
    }

    public ClassNameStrategy(String suffix, NamingStrategy chained, UniqueValueDispenser dispenser) {
        super(chained);
        if (!$assertionsDisabled && suffix == null) {
            throw new AssertionError();
        }
        this.mySuffix = suffix;
        this.setCache(dispenser);
    }

    public String get(CanvasMapping cme) {
        if (cme.getDomainMetaElement() == null) {
            return super.get(cme);
        }
        return this.createClassName(cme.getDomainMetaElement().getName());
    }

    public String get(NodeMapping nme) {
        if (nme.getDomainContext() == null) {
            return super.get(nme);
        }
        return this.createClassName(nme.getDomainContext().getName());
    }

    public String get(LinkMapping lme) {
        if (lme.getDomainMetaElement() != null) {
            return this.createClassName(lme.getDomainMetaElement().getName());
        }
        if (lme.getLinkMetaFeature() != null) {
            return this.createClassName(lme.getLinkMetaFeature().getName());
        }
        return super.get(lme);
    }

    public String get(CompartmentMapping cm) {
        if (cm.getParentNode().getDomainContext() == null || cm.getCompartment() == null) {
            return super.get(cm);
        }
        return this.createClassName(String.valueOf(cm.getParentNode().getDomainContext().getName()) + '_' + cm.getCompartment().getName());
    }

    private String getQualifier(LabelMapping mapping) {
        String text = mapping.getText();
        if (text != null && text.length() > 0) {
            return text.length() > 8 ? text.substring(0, 8) : text;
        }
        if (!$assertionsDisabled && mapping.getFeatures().size() <= 0) {
            throw new AssertionError();
        }
        StringBuffer sb = new StringBuffer();
        Iterator features = mapping.getFeatures().iterator();
        while (features.hasNext()) {
            EAttribute feature = (EAttribute)features.next();
            if (sb.length() > 0) {
                sb.append('_');
            }
            sb.append(feature.getName());
        }
        return sb.toString();
    }

    public String get(LabelMapping labelMapping) {
        MappingEntry mapEntry = labelMapping.getMapEntry();
        if (mapEntry instanceof NodeMapping) {
            return this.getForNode((NodeMapping)mapEntry, labelMapping);
        }
        if (mapEntry instanceof LinkMapping) {
            return this.getForLink((LinkMapping)mapEntry, labelMapping);
        }
        throw new IllegalStateException("Don't know how to handle mapEntry:" + mapEntry);
    }

    private String getForNode(NodeMapping nme, LabelMapping labelMapping) {
        if (nme.getDomainContext() == null) {
            return super.get(labelMapping);
        }
        String qualifier = this.getQualifier(labelMapping);
        return this.createClassName(String.valueOf(nme.getDomainContext().getName()) + '_' + qualifier);
    }

    private String getForLink(LinkMapping lme, LabelMapping labelMapping) {
        String qualifier = this.getQualifier(labelMapping);
        if (lme.getDomainMetaElement() != null) {
            return this.createClassName(String.valueOf(lme.getDomainMetaElement().getName()) + '_' + qualifier);
        }
        if (lme.getLinkMetaFeature() != null) {
            return this.createClassName(String.valueOf(lme.getLinkMetaFeature().getName()) + '_' + qualifier);
        }
        return super.get(labelMapping);
    }

    protected String createClassName(String name) {
        if ((name = CodeGenUtil.validJavaIdentifier((String)name)).length() > 0) {
            name = String.valueOf(Character.toUpperCase(name.charAt(0))) + name.substring(1);
        }
        String fullName = this.ensureUnique(name, this.mySuffix);
        this.cacheName(fullName);
        return fullName;
    }

    protected String ensureUnique(String name, String suffix) {
        int i = 2;
        String uniqueName = name;
        while (this.isCachedName(String.valueOf(uniqueName) + suffix)) {
            uniqueName = String.valueOf(name) + i++;
        }
        return String.valueOf(uniqueName) + suffix;
    }

    private boolean isCachedName(String string) {
        return this.getCache() == null ? false : !this.getCache().isUnique(string);
    }

    private void cacheName(String fullName) {
        if (this.getCache() != null) {
            this.getCache().remember(fullName);
        }
    }
}

