/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenModelFactory;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.gmf.bridge.genmodel.DiagramRunTimeModelTransformer;
import org.eclipse.gmf.bridge.genmodel.RuntimeGenModelAccess;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class CreateSpecificDiagramRunTimeModelAction
implements IObjectActionDelegate {
    private IFile myMapFile;
    private IWorkbenchPart myPart;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    public void run(IAction action) {
        ResourceSetImpl resSet = new ResourceSetImpl();
        Mapping m = (Mapping)resSet.getResource(this.getMapModelURI(), true).getContents().get(0);
        String packName = this.myMapFile.getLocation().removeFileExtension().lastSegment();
        DiagramRunTimeModelTransformer t = new DiagramRunTimeModelTransformer(packName, this.getMapModelURI().appendSegment("diagramrt").toString());
        t.transform(m);
        EPackage drtModel = t.getResult();
        Resource drtEcoreModelRes = resSet.createResource(this.getDestEcoreURI());
        URI genModelURI = this.getDestGenModelURI();
        Resource drtGenModelRes = Resource.Factory.Registry.INSTANCE.getFactory(genModelURI).createResource(genModelURI);
        resSet.getResources().add((Object)drtGenModelRes);
        drtEcoreModelRes.getContents().add((Object)drtModel);
        drtGenModelRes.getContents().add((Object)this.createGenModel(drtModel));
        try {
            drtEcoreModelRes.save(Collections.EMPTY_MAP);
            drtGenModelRes.save(Collections.EMPTY_MAP);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private URI getDestEcoreURI() {
        IPath p = this.myMapFile.getFullPath();
        return URI.createPlatformResourceURI((String)p.removeLastSegments(1).append(String.valueOf(p.removeFileExtension().lastSegment()) + "-drt").addFileExtension("ecore").toString());
    }

    private URI getDestGenModelURI() {
        IPath p = this.myMapFile.getFullPath();
        return URI.createPlatformResourceURI((String)p.removeLastSegments(1).append(String.valueOf(p.removeFileExtension().lastSegment()) + "-drt").addFileExtension("genmodel").toString());
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.myMapFile = (IFile)((IStructuredSelection)selection).getFirstElement();
    }

    private URI getMapModelURI() {
        return URI.createPlatformResourceURI((String)this.myMapFile.getFullPath().toString());
    }

    protected Shell getShell() {
        return this.myPart.getSite().getShell();
    }

    private GenModel createGenModel(EPackage model) {
        GenModel genModel = GenModelFactory.eINSTANCE.createGenModel();
        genModel.getForeignModel().add((Object)model.eResource().getURI().toString());
        genModel.initialize(Collections.singleton(model));
        GenPackage genPackage = (GenPackage)genModel.getGenPackages().get(0);
        genModel.setModelName(model.eResource().getURI().lastSegment());
        genModel.setModelPluginID(model.eResource().getURI().lastSegment());
        genModel.setModelDirectory("/" + model.eResource().getURI().lastSegment() + "/src/");
        genModel.getUsedGenPackages().add((Object)this.getDiagramRunTimeGenPackage());
        genPackage.setPrefix(String.valueOf(model.getName()) + "DRT");
        return genModel;
    }

    private GenPackage getDiagramRunTimeGenPackage() {
        RuntimeGenModelAccess runtimeAccess = new RuntimeGenModelAccess();
        runtimeAccess.ensure();
        return runtimeAccess.genPackage();
    }
}

