/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.util.Generator;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ExecuteTemplatesAction
implements IObjectActionDelegate,
IRunnableWithProgress {
    private static final String ASK_INFO = "ask_info";
    private static final String ASK_OK = "ask_ok";
    private IFile mySelection;
    private IWorkbenchPart myPart;
    private IStatus myRunStatus;
    private GenEditorGenerator myGenModel;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.internal.codegen.popup.actions.ExecuteTemplatesAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IAction action) {
        try {
            block14: {
                try {
                    this.loadGenModel();
                    if (!$assertionsDisabled && this.getGenModel() == null) {
                        throw new AssertionError();
                    }
                    IStatus isGenModelValid = this.validateGenModel();
                    if (!isGenModelValid.isOK() && !MessageDialog.openConfirm((Shell)this.getShell(), (String)action.getText(), (String)ExecuteTemplatesAction.formatMessage("generatecode.badsrc", isGenModelValid))) {
                        Object var3_3 = null;
                        this.unloadGenModel();
                        return;
                    }
                    this.myRunStatus = Status.CANCEL_STATUS;
                    new ProgressMonitorDialog(this.getShell()).run(true, true, (IRunnableWithProgress)this);
                    if (this.getRunStatus().isOK()) {
                        if (!"always".equals(ExecuteTemplatesAction.getPreferences().getString(ASK_OK))) {
                            MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)action.getText(), (String)CodeGenUIPlugin.getBundleString("generatecode.ok"), (String)CodeGenUIPlugin.getBundleString("generatecode.neveragain"), (boolean)false, (IPreferenceStore)ExecuteTemplatesAction.getPreferences(), (String)ASK_OK);
                        }
                        break block14;
                    }
                    if (this.myRunStatus.matches(4)) {
                        CodeGenUIPlugin.getDefault().getLog().log(this.getRunStatus());
                        MessageDialog.openError((Shell)this.getShell(), (String)action.getText(), (String)ExecuteTemplatesAction.formatMessage("generatecode.err", this.getRunStatus()));
                        break block14;
                    }
                    if (this.myRunStatus.matches(2)) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)action.getText(), (String)ExecuteTemplatesAction.formatMessage("generatecode.warn", this.getRunStatus()));
                    } else if (this.myRunStatus.matches(1) && !"always".equals(ExecuteTemplatesAction.getPreferences().getString(ASK_INFO))) {
                        MessageDialogWithToggle.openInformation((Shell)this.getShell(), (String)action.getText(), (String)ExecuteTemplatesAction.formatMessage("generatecode.info", this.getRunStatus()), (String)CodeGenUIPlugin.getBundleString("generatecode.neveragain"), (boolean)false, (IPreferenceStore)ExecuteTemplatesAction.getPreferences(), (String)ASK_INFO);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                }
                catch (InterruptedException interruptedException) {}
            }
            Object var3_5 = null;
            this.unloadGenModel();
            return;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            this.unloadGenModel();
            throw throwable;
        }
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        Generator g = new Generator(this.getGenModel());
        g.run(monitor);
        this.myRunStatus = g.getRunStatus();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelection = null;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        this.mySelection = (IFile)((IStructuredSelection)selection).getFirstElement();
        action.setEnabled(true);
    }

    private static String formatMessage(String bundleStringKey, IStatus status) {
        return CodeGenUIPlugin.formatMessage(bundleStringKey, status);
    }

    private IStatus getRunStatus() {
        return this.myRunStatus;
    }

    private GenEditorGenerator getGenModel() {
        return this.myGenModel;
    }

    private void loadGenModel() {
        URI selected = URI.createPlatformResourceURI((String)this.mySelection.getFullPath().toString());
        ResourceSetImpl srcResSet = new ResourceSetImpl();
        srcResSet.getLoadOptions().put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        Resource srcRes = srcResSet.getResource(selected, true);
        Object root = srcRes.getContents().get(0);
        if (root instanceof GenDiagram) {
            this.myGenModel = ((GenDiagram)root).getEditorGen();
        } else if (root instanceof GenEditorGenerator) {
            this.myGenModel = (GenEditorGenerator)root;
        }
        if (this.myGenModel != null && this.myGenModel.getDomainGenModel() != null) {
            this.myGenModel.getDomainGenModel().reconcile();
        }
    }

    private void unloadGenModel() {
        if (this.myGenModel != null && this.myGenModel.eResource() != null) {
            this.myGenModel.eResource().unload();
        }
        this.myGenModel = null;
    }

    private IStatus validateGenModel() {
        return BasicDiagnostic.toIStatus((Diagnostic)Diagnostician.INSTANCE.validate((EObject)this.getGenModel()));
    }

    private Shell getShell() {
        return this.myPart.getSite().getShell();
    }

    private static IPreferenceStore getPreferences() {
        return CodeGenUIPlugin.getDefault().getPreferenceStore();
    }
}

