/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.codegen.popup.actions;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.gmf.bridge.genmodel.BasicDiagramRunTimeModelHelper;
import org.eclipse.gmf.bridge.genmodel.BasicGenModelAccess;
import org.eclipse.gmf.bridge.genmodel.DiagramGenModelTransformer;
import org.eclipse.gmf.bridge.genmodel.DiagramRunTimeModelHelper;
import org.eclipse.gmf.bridge.genmodel.FileGenModelAccess;
import org.eclipse.gmf.bridge.genmodel.GenModelAccess;
import org.eclipse.gmf.bridge.genmodel.SpecificDiagramRunTimeModelHelper;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediator;
import org.eclipse.gmf.internal.bridge.naming.gen.GenModelNamingMediatorImpl;
import org.eclipse.gmf.internal.codegen.CodeGenUIPlugin;
import org.eclipse.gmf.mappings.Mapping;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;

public class TransformToGenModel
implements IObjectActionDelegate {
    private static final String ASK_WARN = "ask_warn";
    private IFile myMapFile;
    private IWorkbenchPart myPart;
    private IFile myDestFile;
    private Map mySaveOptions = null;
    private static final Boolean THERE_IS_NO_SPECIFIC_RT = Boolean.TRUE;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    public void run(IAction action) {
        this.initDestinationFile();
        if (this.myDestFile == null) {
            return;
        }
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource mapRes = resSet.getResource(this.getMapModelURI(), true);
        final Mapping mapping = (Mapping)mapRes.getContents().get(0);
        IStatus mapIsValid = this.validate(mapping);
        if (mapIsValid.matches(8)) {
            return;
        }
        if (mapIsValid.matches(4)) {
            ErrorDialog.openError((Shell)this.getShell(), (String)action.getText(), (String)CodeGenUIPlugin.getBundleString("transform.err"), (IStatus)mapIsValid);
            return;
        }
        if (mapIsValid.matches(3) && !"always".equals(TransformToGenModel.getPreferences().getString(ASK_WARN)) && MessageDialogWithToggle.openOkCancelConfirm((Shell)this.getShell(), (String)action.getText(), (String)CodeGenUIPlugin.getBundleString("transform.warn"), (String)CodeGenUIPlugin.getBundleString("transform.neverwarn"), (boolean)false, (IPreferenceStore)TransformToGenModel.getPreferences(), (String)ASK_WARN).getReturnCode() != 0) {
            return;
        }
        GenModelDetector gmDetector = new GenModelDetector();
        IStatus findStatus = gmDetector.find(this.getShell(), mapping);
        if (findStatus.getSeverity() == 8) {
            return;
        }
        GenModel domainGenModel = null;
        if (findStatus.isOK()) {
            domainGenModel = gmDetector.get((ResourceSet)resSet);
        }
        DiagramRunTimeModelHelper drtModelHelper = this.detectRunTimeModel((ResourceSet)resSet);
        final DiagramGenModelTransformer t = new DiagramGenModelTransformer(drtModelHelper, (GenModelNamingMediator)new GenModelNamingMediatorImpl());
        if (domainGenModel != null) {
            t.setEMFGenModel(domainGenModel);
        }
        new Job(action.getText(), (ResourceSet)resSet){
            private final /* synthetic */ ResourceSet val$resSet;
            {
                this.val$resSet = resourceSet;
                super($anonymous0);
                this.setPriority(20);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected IStatus run(IProgressMonitor monitor) {
                IStatus iStatus;
                block8: {
                    IStatus iStatus2;
                    block7: {
                        IStatus iStatus3;
                        block6: {
                            monitor.beginTask(this.getName(), 3);
                            try {
                                try {
                                    GenEditorGenerator genEditor = this.transform(mapping);
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) {
                                        iStatus3 = Status.CANCEL_STATUS;
                                        Object var3_8 = null;
                                        break block6;
                                    }
                                    this.save(genEditor);
                                    monitor.worked(1);
                                    if (monitor.isCanceled()) {
                                        iStatus2 = Status.CANCEL_STATUS;
                                        break block7;
                                    }
                                    iStatus = this.validate(genEditor);
                                    break block8;
                                }
                                catch (IOException ex) {
                                    IStatus iStatus4 = CodeGenUIPlugin.createError("", ex);
                                    Object var3_11 = null;
                                    monitor.done();
                                    return iStatus4;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var3_12 = null;
                                monitor.done();
                                throw throwable;
                            }
                        }
                        monitor.done();
                        return iStatus3;
                    }
                    Object var3_9 = null;
                    monitor.done();
                    return iStatus2;
                }
                Object var3_10 = null;
                monitor.done();
                return iStatus;
            }

            private GenEditorGenerator transform(Mapping m) {
                t.transform(m);
                return t.getResult();
            }

            private IStatus validate(GenEditorGenerator genBurdern) {
                Diagnostic d = Diagnostician.INSTANCE.validate((EObject)genBurdern);
                if (d.getSeverity() == 0) {
                    return Status.OK_STATUS;
                }
                if ((d.getSeverity() & 8) != 0) {
                    return Status.CANCEL_STATUS;
                }
                return BasicDiagnostic.toIStatus((Diagnostic)d);
            }

            private void save(GenEditorGenerator genBurdern) throws IOException {
                Resource dgmmRes = this.val$resSet.createResource(TransformToGenModel.this.getGenModelURI());
                dgmmRes.getContents().add((Object)genBurdern);
                dgmmRes.save(TransformToGenModel.this.getSaveOptions());
            }
        }.schedule();
    }

    private DiagramRunTimeModelHelper detectRunTimeModel(ResourceSet resSet) {
        Resource drtGenModelRes;
        BasicDiagramRunTimeModelHelper drtModelHelper = null;
        URI specificRTGenModelURI = this.decideOnRunTimeModel();
        if (specificRTGenModelURI != null && (drtGenModelRes = resSet.getResource(specificRTGenModelURI, true)) != null) {
            GenModel drtGenModel = (GenModel)drtGenModelRes.getContents().get(0);
            drtModelHelper = new SpecificDiagramRunTimeModelHelper(drtGenModel);
        }
        if (drtModelHelper == null) {
            drtModelHelper = new BasicDiagramRunTimeModelHelper();
        }
        return drtModelHelper;
    }

    protected Map getSaveOptions() {
        if (this.mySaveOptions == null) {
            this.mySaveOptions = new HashMap();
            this.mySaveOptions.put("ENCODING", "UTF-8");
        }
        return this.mySaveOptions;
    }

    private IStatus validate(Mapping mapping) {
        return BasicDiagnostic.toIStatus((Diagnostic)Diagnostician.INSTANCE.validate((EObject)mapping));
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.myMapFile = (IFile)((IStructuredSelection)selection).getFirstElement();
    }

    private void initDestinationFile() {
        this.myDestFile = null;
        IPath destPath = this.myMapFile.getFullPath().removeFileExtension().addFileExtension("gmfgen");
        final IPath destLocation = destPath.removeLastSegments(1);
        String defFileName = destPath.lastSegment();
        InputDialog dlg = new InputDialog(this.getShell(), "Target model file", "Please specify name of the file to save diagram genmodel to", defFileName, new IInputValidator(){

            public String isValid(String newText) {
                IStatus s = ResourcesPlugin.getWorkspace().validatePath(destLocation.append(newText).toOSString(), 1);
                return s.isOK() ? null : s.getMessage();
            }
        });
        if (dlg.open() != 0) {
            return;
        }
        this.myDestFile = ResourcesPlugin.getWorkspace().getRoot().getFile(destLocation.append(dlg.getValue()));
    }

    public IFile getGenModelFile() {
        return this.myDestFile;
    }

    URI getMapModelURI() {
        return URI.createPlatformResourceURI((String)this.myMapFile.getFullPath().toString());
    }

    URI getGenModelURI() {
        return URI.createPlatformResourceURI((String)this.myDestFile.getFullPath().toString());
    }

    private Shell getShell() {
        return this.myPart.getSite().getShell();
    }

    private URI decideOnRunTimeModel() {
        if (THERE_IS_NO_SPECIFIC_RT.booleanValue()) {
            return null;
        }
        IPath p = this.myMapFile.getFullPath();
        String defValue = p.removeLastSegments(1).append(String.valueOf(p.removeFileExtension().lastSegment()) + "-drt").addFileExtension("genmodel").toString();
        InputDialog dlg = new InputDialog(this.getShell(), "Diagram RunTime Model", "Please specify path to genmodel file that describes specific diagram runtime model, or press Cancel if you don't need one", defValue, null);
        if (dlg.open() == 0) {
            return URI.createPlatformResourceURI((String)dlg.getValue());
        }
        return null;
    }

    private static IPreferenceStore getPreferences() {
        return CodeGenUIPlugin.getDefault().getPreferenceStore();
    }

    private class GenModelDetector {
        private GenModelAccess myGMAccess;

        GenModelDetector() {
        }

        public IStatus find(Shell shell, Mapping mapping) {
            IFile workspaceFile;
            Object next;
            HashSet<EPackage> packages = new HashSet<EPackage>();
            Iterator<Object> it = EcoreUtil.ExternalCrossReferencer.find((EObject)mapping).keySet().iterator();
            while (it.hasNext()) {
                next = it.next();
                if (!(next instanceof EClass)) continue;
                packages.add(((EClass)next).getEPackage());
            }
            it = packages.iterator();
            while (it.hasNext()) {
                next = (EPackage)it.next();
                if (next.getESuperPackage() == null || !EcoreUtil.isAncestor(packages, (EObject)next.getESuperPackage())) continue;
                it.remove();
            }
            if (packages.isEmpty()) {
                MessageDialog.openWarning((Shell)shell, (String)"Mapping without domain model", (String)"Sorry, don't know yet how to deal with mapping that has no domain model");
                return Status.CANCEL_STATUS;
            }
            if (packages.size() == 1) {
                EPackage solePack = (EPackage)packages.iterator().next();
                BasicGenModelAccess gma = new BasicGenModelAccess(solePack);
                gma.initDefault();
                if (gma.load((ResourceSet)new ResourceSetImpl()).isOK()) {
                    gma.unload();
                    this.myGMAccess = gma;
                    return Status.OK_STATUS;
                }
                workspaceFile = this.askGenModelFile(shell, "Can't find genmodel for package " + solePack.getName() + "(" + solePack.getNsURI() + ")");
            } else {
                workspaceFile = this.askGenModelFile(shell, "Need genmodel to cover all referenced domain packages (" + packages.size() + ")");
            }
            if (workspaceFile == null) {
                return Status.CANCEL_STATUS;
            }
            this.myGMAccess = new FileGenModelAccess(workspaceFile);
            return Status.OK_STATUS;
        }

        private IFile askGenModelFile(Shell shell, String message) {
            ResourceSelectionDialog d = new ResourceSelectionDialog(shell, (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), message);
            if (d.open() != 0) {
                return null;
            }
            Object[] result = d.getResult();
            if (result == null || result.length != 1 || !(result[0] instanceof IFile)) {
                MessageDialog.openError((Shell)shell, (String)"GenModel selection", (String)"Needs exactly one .genmodel file");
                return null;
            }
            return (IFile)result[0];
        }

        public GenModel get(ResourceSet resSet) {
            IStatus s = this.myGMAccess.load(resSet);
            if (!s.isOK()) {
                throw new IllegalStateException(s.getMessage());
            }
            return this.myGMAccess.model();
        }
    }
}

