/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.codegen.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.util.CodeGenUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.gmf.codegen.gmfgen.GenChildContainer;
import org.eclipse.gmf.codegen.gmfgen.GenChildNode;
import org.eclipse.gmf.codegen.gmfgen.GenCommonBase;
import org.eclipse.gmf.codegen.gmfgen.GenCompartment;
import org.eclipse.gmf.codegen.gmfgen.GenDiagram;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.codegen.gmfgen.GenEditorView;
import org.eclipse.gmf.codegen.gmfgen.GenExternalNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenLink;
import org.eclipse.gmf.codegen.gmfgen.GenLinkLabel;
import org.eclipse.gmf.codegen.gmfgen.GenNode;
import org.eclipse.gmf.codegen.gmfgen.GenNodeLabel;
import org.eclipse.gmf.codegen.gmfgen.GenTopLevelNode;
import org.eclipse.gmf.codegen.util.CodegenEmitters;
import org.eclipse.gmf.codegen.util.Messages;
import org.eclipse.gmf.common.UnexpectedBehaviourException;
import org.eclipse.gmf.common.codegen.GeneratorBase;

public class Generator
extends GeneratorBase
implements Runnable {
    private final GenEditorGenerator myEditorGen;
    private final GenDiagram myDiagram;
    private CodegenEmitters myEmitters;
    private static Map myCachedURI2EmitterMap = new HashMap();

    public Generator(GenEditorGenerator genModel) {
        this(genModel.getDiagram());
    }

    public Generator(GenDiagram diagram) {
        CodegenEmitters old;
        this.myDiagram = diagram;
        this.myEditorGen = this.myDiagram.getEditorGen();
        URI resourceURI = this.myEditorGen.eResource().getURI();
        if (this.myEditorGen.isDynamicTemplates()) {
            myCachedURI2EmitterMap.remove(resourceURI);
        }
        CodegenEmitters codegenEmitters = old = myCachedURI2EmitterMap.containsKey(resourceURI) ? (CodegenEmitters)((SoftReference)myCachedURI2EmitterMap.get(resourceURI)).get() : null;
        if (old == null) {
            this.myEmitters = new CodegenEmitters(!this.myEditorGen.isDynamicTemplates(), this.myEditorGen.getTemplateDirectory());
            if (!this.myEditorGen.isDynamicTemplates()) {
                myCachedURI2EmitterMap.put(resourceURI, new SoftReference<CodegenEmitters>(this.myEmitters));
            }
        } else {
            this.myEmitters = old;
        }
    }

    protected URL getJMergeControlFile() {
        return this.myEmitters.getJMergeControlFile();
    }

    protected void customRun() throws InterruptedException, JETException, UnexpectedBehaviourException {
        GenNode node;
        this.initializeEditorProject(this.myDiagram.getEditorGen().getPlugin().getID(), this.createReferencedProjectsList());
        this.generateReorientConnectionViewCommand();
        this.generateSemanticHints();
        this.generateAbstractParser();
        this.generateStructuralFeatureParser();
        this.generateStructuralFeaturesParser();
        this.generateBaseItemSemanticEditPolicy();
        this.generateBaseGraphicalNodeEditPolicy();
        this.generateReferenceConnectionEditPolicy();
        this.generateDiagramCanonicalEditPolicy();
        this.generateDiagramItemSemanticEditPolicy();
        Iterator nodes = this.myDiagram.getTopLevelNodes().iterator();
        while (nodes.hasNext()) {
            node = (GenTopLevelNode)nodes.next();
            this.generateNode(node);
        }
        nodes = this.myDiagram.getChildNodes().iterator();
        while (nodes.hasNext()) {
            node = (GenChildNode)nodes.next();
            if (node.isListContainerEntry()) {
                this.generateListContainerNode(node);
                continue;
            }
            this.generateNode(node);
        }
        Iterator compartments = this.myDiagram.getCompartments().iterator();
        while (compartments.hasNext()) {
            GenCompartment compartment = (GenCompartment)compartments.next();
            this.generateCompartment(compartment);
        }
        Iterator it = this.myDiagram.getLinks().iterator();
        while (it.hasNext()) {
            GenLink next = (GenLink)it.next();
            this.generateViewFactory(next);
            this.generateLinkEditPart(next);
            if (next.getModelFacet() != null) {
                this.generateLinkItemSemanticEditPolicy(next);
            }
            Iterator labels = next.getLabels().iterator();
            while (labels.hasNext()) {
                GenLinkLabel label = (GenLinkLabel)labels.next();
                this.generateLinkLabelEditPart(label);
                this.generateLinkLabelTextEditPart(label);
                this.generateLinkLabelViewFactory(label);
                this.generateLinkLabelTextViewFactory(label);
            }
        }
        this.generateViewFactory(this.myDiagram);
        this.generateDiagramEditPart();
        this.generateDiagramExternalNodeLabelEditPart();
        this.generateEditPartFactory();
        this.generateElementTypes();
        this.generateViewProvider();
        this.generateEditPartProvider();
        this.generatePaletteProvider();
        this.generateModelingAssistantProvider();
        this.generatePropertyProvider();
        this.generateIconProvider();
        this.generateParserProvider();
        if (this.myDiagram.isValidationEnabled()) {
            this.generateValidationProvider();
            this.generateMarkerNavigationProvider();
        }
        this.generateInitDiagramFileAction();
        this.generatePalette();
        this.generateDiagramEditorUtil();
        this.generateDiagramFileCreator();
        this.generateVisualIDRegistry();
        this.generateCreationWizard();
        this.generateCreationWizardPage();
        this.generateEditor();
        this.generateCreateShortcutAction();
        this.generateLoadResourceAction();
        this.generateElementChooser();
        this.generateDocumentProvider();
        this.generateActionBarContributor();
        this.generateMatchingStrategy();
        this.generatePreferencesInitializer();
        this.generatePluginClass();
        this.generateBundleManifest();
        this.generatePluginProperties();
        this.generatePluginXml();
        this.generateBuildProperties();
        this.generateShortcutIcon();
    }

    private void generateNode(GenNode node) throws JETException, InterruptedException {
        this.generateNodeEditPart(node);
        Iterator labels = node.getLabels().iterator();
        while (labels.hasNext()) {
            GenNodeLabel label = (GenNodeLabel)labels.next();
            if (label instanceof GenExternalNodeLabel) {
                GenExternalNodeLabel extLabel = (GenExternalNodeLabel)label;
                this.generateExternalNodeLabelEditPart(extLabel);
                this.generateExternalNodeLabelViewFactory(extLabel);
                this.generateExternalNodeLabelTextEditPart(extLabel);
                this.generateExternalNodeLabelTextViewFactory(extLabel);
                continue;
            }
            this.generateNodeLabelEditPart(label);
            this.generateNodeLabelTextViewFactory(label);
        }
        this.generateChildContainer(node);
        this.generateNodeGraphicalNodeEditPolicy(node);
        this.generateNodeItemSemanticEditPolicy(node);
    }

    private void generateListContainerNode(GenNode child) throws JETException, InterruptedException {
        this.generateListContainerNodeEditPart(child);
        this.generateNodeItemSemanticEditPolicy(child);
        this.generateViewFactory(child);
    }

    private void generateCompartment(GenCompartment compartment) throws JETException, InterruptedException {
        this.generateCompartmentEditPart(compartment);
        this.generateCompartmentItemSemanticEditPolicy(compartment);
        this.generateChildContainer(compartment);
    }

    private void generateChildContainer(GenChildContainer childContainer) throws JETException, InterruptedException {
        this.generateViewFactory(childContainer);
        this.generateChildContainerCanonicalEditPolicy(childContainer);
    }

    private void generateReorientConnectionViewCommand() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getReorientConnectionViewCommandEmitter(), this.myDiagram.getEditCommandsPackageName(), this.myDiagram.getReorientConnectionViewCommandClassName(), this.myDiagram);
    }

    private void generateDiagramEditPart() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), this.myDiagram.getEditPartClassName(), this.myDiagram);
    }

    private void generateDiagramExternalNodeLabelEditPart() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramExternalNodeLabelEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), this.myDiagram.getBaseExternalNodeLabelEditPartClassName(), this.myDiagram);
    }

    private void generateNodeEditPart(GenNode genNode) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), genNode.getEditPartClassName(), genNode);
    }

    private void generateNodeLabelEditPart(GenNodeLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeLabelEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), label.getEditPartClassName(), label);
    }

    private void generateExternalNodeLabelEditPart(GenExternalNodeLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getExternalNodeLabelEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), label.getEditPartClassName(), label);
    }

    private void generateExternalNodeLabelTextEditPart(GenExternalNodeLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getExternalNodeLabelTextEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), label.getTextEditPartClassName(), label);
    }

    private void generateListContainerNodeEditPart(GenNode genChildNode) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getChildNodeEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), genChildNode.getEditPartClassName(), genChildNode);
    }

    private void generateCompartmentEditPart(GenCompartment genCompartment) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCompartmentEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), genCompartment.getEditPartClassName(), genCompartment);
    }

    private void generateLinkEditPart(GenLink genLink) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), genLink.getEditPartClassName(), genLink);
    }

    private void generateLinkLabelEditPart(GenLinkLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkLabelEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), label.getEditPartClassName(), label);
    }

    private void generateLinkLabelTextEditPart(GenLinkLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkLabelTextEditPartEmitter(), this.myDiagram.getEditPartsPackageName(), label.getTextEditPartClassName(), label);
    }

    private void generateEditPartFactory() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getEditPartFactoryEmitter(), this.myDiagram.getEditPartsPackageName(), this.myDiagram.getEditPartFactoryClassName(), this.myDiagram);
    }

    private void generateBaseItemSemanticEditPolicy() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getBaseItemSemanticEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), this.myDiagram.getBaseItemSemanticEditPolicyClassName(), this.myDiagram);
    }

    private void generateBaseGraphicalNodeEditPolicy() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getBaseGraphicalNodeEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), this.myDiagram.getBaseGraphicalNodeEditPolicyClassName(), this.myDiagram);
    }

    private void generateReferenceConnectionEditPolicy() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getReferenceConnectionEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), this.myDiagram.getReferenceConnectionEditPolicyClassName(), this.myDiagram);
    }

    private void generateDiagramCanonicalEditPolicy() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramCanonicalEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), this.myDiagram.getCanonicalEditPolicyClassName(), this.myDiagram);
    }

    private void generateChildContainerCanonicalEditPolicy(GenChildContainer genContainer) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getChildContainerCanonicalEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), genContainer.getCanonicalEditPolicyClassName(), genContainer);
    }

    private void generateDiagramItemSemanticEditPolicy() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramItemSemanticEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), this.myDiagram.getItemSemanticEditPolicyClassName(), this.myDiagram);
    }

    private void generateCompartmentItemSemanticEditPolicy(GenCompartment genCompartment) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCompartmentItemSemanticEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), genCompartment.getItemSemanticEditPolicyClassName(), genCompartment);
    }

    private void generateNodeGraphicalNodeEditPolicy(GenNode genNode) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeGraphicalNodeEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), genNode.getGraphicalNodeEditPolicyClassName(), genNode);
    }

    private void generateNodeItemSemanticEditPolicy(GenNode genNode) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getNodeItemSemanticEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), genNode.getItemSemanticEditPolicyClassName(), genNode);
    }

    private void generateLinkItemSemanticEditPolicy(GenLink genLink) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLinkItemSemanticEditPolicyEmitter(), this.myDiagram.getEditPoliciesPackageName(), genLink.getItemSemanticEditPolicyClassName(), genLink);
    }

    private void generateAbstractParser() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getAbstractParserEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getAbstractParserClassName(), this.myDiagram);
    }

    private void generateStructuralFeatureParser() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getStructuralFeatureParserEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getStructuralFeatureParserClassName(), this.myDiagram);
    }

    private void generateStructuralFeaturesParser() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getStructuralFeaturesParserEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getStructuralFeaturesParserClassName(), this.myDiagram);
    }

    private void generateSemanticHints() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getSemanticHintsEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getSemanticHintsClassName(), this.myDiagram);
    }

    private void generateElementTypes() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getElementTypesEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getElementTypesClassName(), this.myDiagram);
    }

    private void generateViewProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getViewProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getNotationViewProviderClassName(), this.myDiagram);
    }

    private void generateEditPartProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getEditPartProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getEditPartProviderClassName(), this.myDiagram);
    }

    private void generatePaletteProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPaletteProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getPaletteProviderClassName(), this.myDiagram);
    }

    private void generateModelingAssistantProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getModelingAssistantProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getModelingAssistantProviderClassName(), this.myDiagram);
    }

    private void generatePropertyProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPropertyProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getPropertyProviderClassName(), this.myDiagram);
    }

    private void generateIconProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getIconProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getIconProviderClassName(), this.myDiagram);
    }

    private void generateParserProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getParserProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getParserProviderClassName(), this.myDiagram);
    }

    private void generateValidationProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getValidationProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getValidationProviderClassName(), this.myDiagram);
    }

    private void generateMarkerNavigationProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getMarkerNavigationProviderEmitter(), this.myDiagram.getProvidersPackageName(), this.myDiagram.getMarkerNavigationProviderClassName(), this.myDiagram);
    }

    private void generateViewFactory(GenCommonBase genElement) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), genElement.getNotationViewFactoryClassName(), genElement);
    }

    private void generateLinkLabelViewFactory(GenLinkLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLabelViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), label.getNotationViewFactoryClassName(), label);
    }

    private void generateLinkLabelTextViewFactory(GenLinkLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLabelTextViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), label.getTextNotationViewFactoryClassName(), label);
    }

    private void generateExternalNodeLabelViewFactory(GenExternalNodeLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLabelViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), label.getNotationViewFactoryClassName(), label);
    }

    private void generateExternalNodeLabelTextViewFactory(GenExternalNodeLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLabelTextViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), label.getTextNotationViewFactoryClassName(), label);
    }

    private void generateNodeLabelTextViewFactory(GenNodeLabel label) throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLabelTextViewFactoryEmitter(), this.myDiagram.getNotationViewFactoriesPackageName(), label.getNotationViewFactoryClassName(), label);
    }

    private void generateInitDiagramFileAction() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getInitDiagramFileActionEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getInitDiagramFileActionClassName(), this.myDiagram);
    }

    private void generatePalette() throws JETException, InterruptedException {
        if (this.myDiagram.getPalette() == null) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getPaletteEmitter(), this.myDiagram.getPalette().getPackageName(), this.myDiagram.getPalette().getFactoryClassName(), this.myDiagram);
    }

    private void generateDiagramEditorUtil() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramEditorUtilEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getDiagramEditorUtilClassName(), this.myDiagram);
    }

    private void generateDiagramFileCreator() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDiagramFileCreatorEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getDiagramFileCreatorClassName(), this.myDiagram);
    }

    private void generateVisualIDRegistry() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getVisualIDRegistryEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getVisualIDRegistryClassName(), this.myDiagram);
    }

    private void generateCreationWizard() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCreationWizardEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getCreationWizardClassName(), this.myDiagram);
    }

    private void generateCreationWizardPage() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getCreationWizardPageEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getCreationWizardPageClassName(), this.myDiagram);
    }

    private void generateEditor() throws JETException, InterruptedException {
        GenEditorView editor = this.myEditorGen.getEditor();
        this.doGenerateJavaClass(this.myEmitters.getEditorEmitter(), editor.getPackageName(), editor.getClassName(), editor);
    }

    private void generateCreateShortcutAction() throws JETException, InterruptedException {
        if (!this.myDiagram.generateCreateShortcutAction()) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getCreateShortcutActionEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getCreateShortcutActionClassName(), this.myDiagram);
    }

    private void generateLoadResourceAction() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getLoadResourceActionEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getLoadResourceActionClassName(), this.myDiagram);
    }

    private void generateElementChooser() throws JETException, InterruptedException {
        if (!this.myDiagram.generateCreateShortcutAction()) {
            return;
        }
        this.doGenerateJavaClass(this.myEmitters.getElementChooserEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getElementChooserClassName(), this.myDiagram);
    }

    private void generateDocumentProvider() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getDocumentProviderEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getDocumentProviderClassName(), this.myDiagram);
    }

    private void generateActionBarContributor() throws JETException, InterruptedException {
        GenEditorView editor = this.myEditorGen.getEditor();
        this.doGenerateJavaClass(this.myEmitters.getActionBarContributorEmitter(), editor.getPackageName(), editor.getActionBarContributorClassName(), editor);
    }

    private void generateMatchingStrategy() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getMatchingStrategyEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getMatchingStrategyClassName(), this.myDiagram);
    }

    private void generatePreferencesInitializer() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPreferencesInitializerEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myDiagram.getPreferenceInitializerClassName(), this.myEditorGen);
    }

    private void generatePluginClass() throws JETException, InterruptedException {
        this.doGenerateJavaClass(this.myEmitters.getPluginClassEmitter(), this.myEditorGen.getEditor().getPackageName(), this.myEditorGen.getPlugin().getActivatorClassName(), this.myEditorGen.getPlugin());
    }

    private void generatePluginXml() throws JETException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getPluginXmlEmitter(), (IPath)new Path("plugin.xml"), this.myDiagram.getEditorGen().getPlugin());
    }

    private void generatePluginProperties() throws JETException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getPluginPropertiesEmitter(), (IPath)new Path("plugin.properties"), this.myDiagram.getEditorGen().getPlugin());
    }

    private void generateBundleManifest() throws JETException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getBundleManifestEmitter(), (IPath)new Path("META-INF/MANIFEST.MF"), this.myDiagram.getEditorGen().getPlugin());
    }

    private void generateBuildProperties() throws JETException, InterruptedException {
        this.doGenerateFile(this.myEmitters.getBuildPropertiesEmitter(), (IPath)new Path("build.properties"), this.myDiagram);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void generateShortcutIcon() throws InterruptedException, JETException {
        if (!this.myDiagram.generateShortcutIcon()) {
            return;
        }
        Path iconPath = new Path("icons/shortcut.gif");
        IProgressMonitor pm = this.getNextStepMonitor();
        try {
            try {
                pm.beginTask(iconPath.lastSegment(), 3);
                IPath containerPath = this.getDestProject().getFullPath().append(iconPath.removeLastSegments(1));
                CodeGenUtil.findOrCreateContainer((IPath)containerPath, (boolean)false, null, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                IFile f = this.getDestProject().getFile((IPath)iconPath);
                if (f.exists()) {
                    f.setContents((InputStream)new ByteArrayInputStream(this.myEmitters.getShortcutImageEmitter().generateGif()), true, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                } else {
                    f.create((InputStream)new ByteArrayInputStream(this.myEmitters.getShortcutImageEmitter().generateGif()), true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
                f.getParent().refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            catch (CoreException ex) {
                this.handleException(ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        {
            Object var5_8 = null;
        }
        pm.done();
    }

    protected void setupProgressMonitor() {
        Counter c = new Counter(this.myDiagram);
        c.setAdditionalOperations(8);
        c.setOperationsPerNode(2);
        c.setOperationsPerListContainerNode(1);
        c.setOperationsPerLink(2);
        this.setupProgressMonitor(Messages.start, c.getTotal());
    }

    protected final List createReferencedProjectsList() {
        return Collections.EMPTY_LIST;
    }

    private static final class Counter {
        private final GenDiagram myDiagram;
        private int myOpsPerNode = 1;
        private int myOpsPerLink = 1;
        private int myOpsPerListContainerNode = 1;
        private int myAdditionalOps = 0;
        private int myOpsPerCompartment = 1;

        Counter(GenDiagram diagram) {
            this.myDiagram = diagram;
        }

        public void setOperationsPerNode(int opsPerNode) {
            this.myOpsPerNode = opsPerNode;
        }

        public void setOperationsPerLink(int opsPerLink) {
            this.myOpsPerLink = opsPerLink;
        }

        public void setOperationsPerListContainerNode(int opsPerChild) {
            this.myOpsPerListContainerNode = opsPerChild;
        }

        public void setOperationsPerCompartment(int opsPerCompartment) {
            this.myOpsPerCompartment = opsPerCompartment;
        }

        public void setAdditionalOperations(int additionalOps) {
            this.myAdditionalOps = additionalOps;
        }

        public int getTotal() {
            int rv = this.myAdditionalOps;
            rv += this.myDiagram.getTopLevelNodes().size() * this.myOpsPerNode;
            rv += this.getChildNodesCount((Collection)this.myDiagram.getChildNodes());
            rv += this.myDiagram.getCompartments().size() * this.myOpsPerCompartment;
            return rv += this.myDiagram.getLinks().size() * this.myOpsPerLink;
        }

        private int getChildNodesCount(Collection nodes) {
            int counter = 0;
            Iterator it = nodes.iterator();
            while (it.hasNext()) {
                GenChildNode nextNode = (GenChildNode)it.next();
                if (nextNode.isListContainerEntry()) {
                    counter += this.myOpsPerNode;
                    continue;
                }
                counter += this.myOpsPerListContainerNode;
            }
            return counter;
        }
    }
}

