/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.doc.ui.actions;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.gmf.internal.bridge.wizards.NewGMFProjectWizard;
import org.eclipse.gmf.internal.doc.ui.Activator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.IWorkbenchWizard;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.ICheatSheetAction;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;
import org.eclipse.ui.dialogs.WizardNewProjectCreationPage;

public class OpenProjectWizardAction
extends Action
implements ICheatSheetAction {
    private static final int SIZING_WIZARD_WIDTH = 500;
    private static final int SIZING_WIZARD_HEIGHT = 500;
    private IFolder folder;

    public OpenProjectWizardAction() {
        super("OpenProjectWizard");
    }

    public void run() {
        this.run(new String[0], null);
    }

    public void run(String[] params, ICheatSheetManager manager) {
        String modelFolderName;
        String projectName = null;
        if (params != null && params.length > 1) {
            projectName = params[0];
            modelFolderName = params[1];
        } else {
            modelFolderName = "model";
        }
        NewGMFProjectWizard wizard = new NewGMFProjectWizard(){

            public boolean performFinish() {
                super.performFinish();
                WizardNewProjectCreationPage page = (WizardNewProjectCreationPage)this.getPage("NewProjectCreationPage");
                OpenProjectWizardAction.this.folder = page.getProjectHandle().getFolder(modelFolderName);
                try {
                    OpenProjectWizardAction.this.folder.create(false, true, null);
                }
                catch (CoreException e) {
                    Activator.log((Exception)((Object)e));
                }
                return true;
            }
        };
        wizard.setInitialProjectName(projectName);
        wizard.setShowDashboard(false);
        if (wizard instanceof IWorkbenchWizard) {
            wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
        }
        WizardDialog dialog = new WizardDialog(Activator.getActiveWorkbenchShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
        this.notifyResult(dialog.getReturnCode() == 0);
    }
}

