/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.edit.policies;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ocl.expressions.ExpressionsFactory;
import org.eclipse.emf.ocl.expressions.VariableDeclaration;
import org.eclipse.emf.ocl.helper.HelperUtil;
import org.eclipse.emf.ocl.helper.IOCLHelper;
import org.eclipse.emf.ocl.parser.EcoreEnvironment;
import org.eclipse.emf.ocl.parser.EcoreEnvironmentFactory;
import org.eclipse.emf.ocl.parser.Environment;
import org.eclipse.emf.ocl.parser.EnvironmentFactory;
import org.eclipse.emf.ocl.parser.EvaluationEnvironment;
import org.eclipse.emf.ocl.query.Query;
import org.eclipse.emf.ocl.query.QueryFactory;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.ecore.editor.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.core.commands.DeleteCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.diagram.ui.commands.EtoolsProxyCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.SemanticEditPolicy;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DuplicateElementsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientReferenceRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.gmf.runtime.notation.View;

public class EcoreBaseItemSemanticEditPolicy
extends SemanticEditPolicy {
    protected Command getSemanticCommand(IEditCommandRequest request) {
        IEditCommandRequest completedRequest = this.completeRequest(request);
        Command semanticCommand = this.getSemanticCommandSwitch(completedRequest);
        if (semanticCommand == null) {
            return UnexecutableCommand.INSTANCE;
        }
        boolean shouldProceed = true;
        if (completedRequest instanceof DestroyRequest) {
            shouldProceed = this.shouldProceed((DestroyRequest)completedRequest);
        }
        if (shouldProceed) {
            if (completedRequest instanceof DestroyRequest) {
                DeleteCommand deleteCommand = new DeleteCommand((View)this.getHost().getModel());
                semanticCommand = semanticCommand.chain((Command)new EtoolsProxyCommand((ICommand)deleteCommand));
            }
            return semanticCommand;
        }
        return UnexecutableCommand.INSTANCE;
    }

    protected Command getSemanticCommandSwitch(IEditCommandRequest req) {
        if (req instanceof CreateRelationshipRequest) {
            return this.getCreateRelationshipCommand((CreateRelationshipRequest)req);
        }
        if (req instanceof CreateElementRequest) {
            return this.getCreateCommand((CreateElementRequest)req);
        }
        if (req instanceof ConfigureRequest) {
            return this.getConfigureCommand((ConfigureRequest)req);
        }
        if (req instanceof DestroyElementRequest) {
            return this.getDestroyElementCommand((DestroyElementRequest)req);
        }
        if (req instanceof DestroyReferenceRequest) {
            return this.getDestroyReferenceCommand((DestroyReferenceRequest)req);
        }
        if (req instanceof DuplicateElementsRequest) {
            return this.getDuplicateCommand((DuplicateElementsRequest)req);
        }
        if (req instanceof GetEditContextRequest) {
            return this.getEditContextCommand((GetEditContextRequest)req);
        }
        if (req instanceof MoveRequest) {
            return this.getMoveCommand((MoveRequest)req);
        }
        if (req instanceof ReorientReferenceRelationshipRequest) {
            return this.getReorientReferenceRelationshipCommand((ReorientReferenceRelationshipRequest)req);
        }
        if (req instanceof ReorientRelationshipRequest) {
            return this.getReorientRelationshipCommand((ReorientRelationshipRequest)req);
        }
        if (req instanceof SetRequest) {
            return this.getSetCommand((SetRequest)req);
        }
        return null;
    }

    protected Command getConfigureCommand(ConfigureRequest req) {
        return null;
    }

    protected Command getCreateRelationshipCommand(CreateRelationshipRequest req) {
        return null;
    }

    protected Command getCreateCommand(CreateElementRequest req) {
        return null;
    }

    protected Command getSetCommand(SetRequest req) {
        return null;
    }

    protected Command getEditContextCommand(GetEditContextRequest req) {
        return null;
    }

    protected Command getDestroyElementCommand(DestroyElementRequest req) {
        return null;
    }

    protected Command getDestroyReferenceCommand(DestroyReferenceRequest req) {
        return null;
    }

    protected Command getDuplicateCommand(DuplicateElementsRequest req) {
        return null;
    }

    protected Command getMoveCommand(MoveRequest req) {
        return null;
    }

    protected Command getReorientReferenceRelationshipCommand(ReorientReferenceRelationshipRequest req) {
        return null;
    }

    protected Command getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return null;
    }

    protected Command getMSLWrapper(ICommand cmd) {
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand modelCmd = new CompositeTransactionalCommand(editingDomain, cmd.getLabel());
        modelCmd.compose((IUndoableOperation)cmd);
        return new EtoolsProxyCommand((ICommand)modelCmd);
    }

    protected EObject getSemanticElement() {
        return ViewUtil.resolveSemanticElement((View)((View)this.getHost().getModel()));
    }

    protected EObject getRelationshipContainer(EObject element, EClass containerClass, IElementType relationshipType) {
        while (element != null) {
            if (containerClass.isSuperTypeOf(element.eClass())) {
                return element;
            }
            element = element.eContainer();
        }
        return null;
    }

    protected static class LinkConstraints {
        public static final LinkConstraints EClassESuperTypes_3004 = new LinkConstraints(new LinkEndConstraint(null, (EClassifier)EcorePackage.eINSTANCE.getEClass()), new LinkEndConstraint("self <> oppositeEnd and not oppositeEnd.eSuperTypes->includes(self) and not self.eAllSuperTypes->includes(oppositeEnd)", (EClassifier)EcorePackage.eINSTANCE.getEClass()));
        private static final String OPPOSITE_END_VAR = "oppositeEnd";
        private VariableDeclaration varOppositeEndToSource;
        private VariableDeclaration varOppositeEndToTarget;
        private Query srcEndInv;
        private Query targetEndInv;

        public LinkConstraints(LinkEndConstraint sourceEnd, LinkEndConstraint targetEnd) {
            if (sourceEnd != null && sourceEnd.context != null && sourceEnd.body != null) {
                if (targetEnd != null && targetEnd.context != null) {
                    this.varOppositeEndToTarget = LinkConstraints.createVar(OPPOSITE_END_VAR, targetEnd.context);
                }
                this.srcEndInv = this.createQuery(sourceEnd, this.varOppositeEndToTarget);
            }
            if (targetEnd != null && targetEnd.context != null && targetEnd.body != null) {
                if (sourceEnd != null && sourceEnd.context != null) {
                    this.varOppositeEndToSource = LinkConstraints.createVar(OPPOSITE_END_VAR, sourceEnd.context);
                }
                this.targetEndInv = this.createQuery(targetEnd, this.varOppositeEndToSource);
            }
        }

        public boolean canCreateLink(CreateRelationshipRequest req, boolean isBackDirected) {
            boolean isSourceAccepted;
            EObject source = req.getSource();
            EObject target = req.getTarget();
            Query sourceConstraint = isBackDirected ? this.targetEndInv : this.srcEndInv;
            Query targetConstraint = null;
            if (req.getTarget() != null) {
                targetConstraint = isBackDirected ? this.srcEndInv : this.targetEndInv;
            }
            boolean bl = isSourceAccepted = sourceConstraint != null ? LinkConstraints.evaluate(sourceConstraint, source, target, false) : true;
            if (isSourceAccepted && targetConstraint != null) {
                return LinkConstraints.evaluate(targetConstraint, target, source, true);
            }
            return isSourceAccepted;
        }

        private Query createQuery(LinkEndConstraint constraint, VariableDeclaration oppositeEndDecl) {
            VariableDeclaration oppositeEndDeclLocal = oppositeEndDecl;
            try {
                IOCLHelper oclHelper = HelperUtil.createOCLHelper((EnvironmentFactory)new EcoreEnvironmentFactory(this, oppositeEndDeclLocal){
                    final /* synthetic */ LinkConstraints this$1;
                    private final /* synthetic */ VariableDeclaration val$oppositeEndDeclLocal;
                    {
                        this.this$1 = linkConstraints;
                        this.val$oppositeEndDeclLocal = variableDeclaration;
                    }

                    public Environment createClassifierContext(Object context) {
                        Environment env = super.createClassifierContext(context);
                        if (this.val$oppositeEndDeclLocal != null) {
                            env.addElement(this.val$oppositeEndDeclLocal.getName(), this.val$oppositeEndDeclLocal, true);
                        }
                        return env;
                    }
                });
                oclHelper.setContext((Object)constraint.context);
                return QueryFactory.eINSTANCE.createQuery(oclHelper.createInvariant(constraint.body));
            }
            catch (Exception e) {
                EcoreDiagramEditorPlugin.getInstance().logError("Link constraint expression error", e);
                return null;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private static boolean evaluate(Query query, Object sourceEnd, Object oppositeEnd, boolean clearEnv) {
            boolean bl;
            EvaluationEnvironment evalEnv = query.getEvaluationEnvironment();
            evalEnv.replace(OPPOSITE_END_VAR, oppositeEnd);
            try {
                try {
                    Object val = query.evaluate(sourceEnd);
                    bl = val instanceof Boolean ? (Boolean)val : false;
                    Object var6_8 = null;
                    if (!clearEnv) return bl;
                }
                catch (Exception e) {
                    EcoreDiagramEditorPlugin.getInstance().logError("Link constraint evaluation error", e);
                    if (evalEnv != null) {
                        evalEnv.clear();
                    }
                    Object var6_9 = null;
                    if (!clearEnv) return false;
                    evalEnv.clear();
                    return false;
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (!clearEnv) throw throwable;
                evalEnv.clear();
                throw throwable;
            }
            evalEnv.clear();
            return bl;
        }

        private static VariableDeclaration createVar(String name, EClassifier type) {
            VariableDeclaration var = ExpressionsFactory.eINSTANCE.createVariableDeclaration();
            var.setName(name);
            var.setType(EcoreEnvironment.getOCLType((EClassifier)type));
            return var;
        }
    }

    static class LinkEndConstraint {
        final EClassifier context;
        final String body;

        LinkEndConstraint(String body, EClassifier context) {
            this.context = context;
            this.body = body;
        }
    }
}

