/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.editor;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.ecore.editor.EcoreDiagramEditorUtil;
import org.eclipse.gmf.ecore.editor.EcoreDiagramFileCreator;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.wizards.EditorWizardPage;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

public class EcoreCreationWizardPage
extends EditorWizardPage {
    public EcoreCreationWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        super("CreationWizardPage", workbench, selection);
        this.setTitle("Create Ecore Diagram");
        this.setDescription("Create a new Ecore diagram.");
    }

    public IFile createAndOpenDiagram(IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean saveDiagram) {
        return EcoreDiagramEditorUtil.createAndOpenDiagram(this.getDiagramFileCreator(), containerPath, fileName, initialContents, kind, dWindow, progressMonitor, this.isOpenNewlyCreatedDiagramEditor(), saveDiagram);
    }

    protected String getDefaultFileName() {
        return "default";
    }

    public DiagramFileCreator getDiagramFileCreator() {
        return EcoreDiagramFileCreator.getInstance();
    }

    protected String getDiagramKind() {
        return "Ecore";
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String fileName = this.getFileName();
            if (fileName == null) {
                return false;
            }
            IPath path = this.getContainerFullPath().append(this.getDiagramFileCreator().appendExtensionToFileName(fileName));
            path = path.removeFileExtension().addFileExtension("ecore");
            if (ResourcesPlugin.getWorkspace().getRoot().exists(path)) {
                this.setErrorMessage("Model File already exists: " + path.lastSegment());
                return false;
            }
            return true;
        }
        return false;
    }
}

