/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.ecore.editor;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.ecore.editor.EcoreDiagramEditorPlugin;
import org.eclipse.gmf.ecore.editor.EcoreVisualIDRegistry;
import org.eclipse.gmf.ecore.providers.EcoreElementTypes;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.preferences.PreferencesHint;
import org.eclipse.gmf.runtime.diagram.core.services.ViewService;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.GMFEditingDomainFactory;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class EcoreInitDiagramFileAction
implements IObjectActionDelegate,
IInputValidator {
    private static final Integer LINK_KEY_3001 = new Integer(3001);
    private static final Integer LINK_KEY_3002 = new Integer(3002);
    private static final Integer LINK_KEY_3003 = new Integer(3003);
    private static final Integer LINK_KEY_3004 = new Integer(3004);
    private IWorkbenchPart myPart;
    private IFile mySelectedModelFile;
    private IStructuredSelection mySelection;
    private Map myLinkVID2EObjectMap = new HashMap();
    private Map myEObject2NodeMap = new HashMap();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.myPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.mySelectedModelFile = null;
        this.mySelection = StructuredSelection.EMPTY;
        action.setEnabled(false);
        if (!(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return;
        }
        this.mySelection = (IStructuredSelection)selection;
        this.mySelectedModelFile = (IFile)((IStructuredSelection)selection).getFirstElement();
        action.setEnabled(true);
    }

    public String isValid(String newText) {
        IStatus status = ResourcesPlugin.getWorkspace().validateName(newText, 1);
        if (!status.isOK()) {
            return status.getMessage();
        }
        if (this.mySelectedModelFile.getParent().getFile(new Path(newText).addFileExtension("editorGen.getDiagramFileExtension()")).exists()) {
            return "File already exists, choose another name";
        }
        return null;
    }

    public void run(IAction action) {
        NewDiagramFileWizard wizard = new NewDiagramFileWizard();
        IDialogSettings pluginDialogSettings = EcoreDiagramEditorPlugin.getInstance().getDialogSettings();
        IDialogSettings initDiagramFileSettings = pluginDialogSettings.getSection("InisDiagramFile");
        if (initDiagramFileSettings == null) {
            initDiagramFileSettings = pluginDialogSettings.addNewSection("InisDiagramFile");
        }
        wizard.setDialogSettings(initDiagramFileSettings);
        wizard.setForcePreviousAndNextButtons(false);
        wizard.setWindowTitle("Initialize new Ecore diagram file");
        WizardDialog dialog = new WizardDialog(this.myPart.getSite().getShell(), (IWizard)wizard);
        dialog.create();
        dialog.getShell().setSize(Math.max(500, dialog.getShell().getSize().x), 500);
        dialog.open();
    }

    private void createEClass_1001Children(View viewObject, EObject modelObject) {
        Node nextNode = this.getCompartment(viewObject, "attributes");
        if (nextNode != null) {
            this.createAttributes_5001Children((View)nextNode, modelObject);
        }
        if ((nextNode = this.getCompartment(viewObject, "operations")) != null) {
            this.createOperations_5002Children((View)nextNode, modelObject);
        }
        if ((nextNode = this.getCompartment(viewObject, "class annotations")) != null) {
            this.createClass_annotations_5003Children((View)nextNode, modelObject);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEPackage_1002Children(View viewObject, EObject modelObject) {
        Node nextNode = this.getCompartment(viewObject, "classes");
        if (nextNode != null) {
            this.createClasses_5004Children((View)nextNode, modelObject);
        }
        if ((nextNode = this.getCompartment(viewObject, "packages")) != null) {
            this.createPackages_5005Children((View)nextNode, modelObject);
        }
        if ((nextNode = this.getCompartment(viewObject, "data types")) != null) {
            this.createData_types_5006Children((View)nextNode, modelObject);
        }
        if ((nextNode = this.getCompartment(viewObject, "enums")) != null) {
            this.createEnums_5007Children((View)nextNode, modelObject);
        }
        if ((nextNode = this.getCompartment(viewObject, "package annotations")) != null) {
            this.createPackage_annotations_5008Children((View)nextNode, modelObject);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEAnnotation_1003Children(View viewObject, EObject modelObject) {
        Node nextNode = this.getCompartment(viewObject, "details");
        if (nextNode != null) {
            this.createDetails_5009Children((View)nextNode, modelObject);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEDataType_1004Children(View viewObject, EObject modelObject) {
        Node nextNode = this.getCompartment(viewObject, "data type annotations");
        if (nextNode != null) {
            this.createData_type_annotations_5010Children((View)nextNode, modelObject);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEEnum_1005Children(View viewObject, EObject modelObject) {
        Node nextNode = this.getCompartment(viewObject, "literals");
        if (nextNode != null) {
            this.createLiterals_5011Children((View)nextNode, modelObject);
        }
        if ((nextNode = this.getCompartment(viewObject, "enum annotations")) != null) {
            this.createEnum_annotations_5012Children((View)nextNode, modelObject);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEAttribute_2001Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEOperation_2002Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEAnnotation_2003Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEClass_2004Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEPackage_2005Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEDataType_2006Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEEnum_2007Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEStringToStringMapEntry_2008Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEEnumLiteral_2009Children(View viewObject, EObject modelObject) {
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createAttributes_5001Children(View viewObject, EObject modelObject) {
        Iterator values = ((EClass)modelObject).getEAttributes().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2001 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEAttribute_2001Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createOperations_5002Children(View viewObject, EObject modelObject) {
        Iterator values = ((EClass)modelObject).getEOperations().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2002 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEOperation_2002Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createClass_annotations_5003Children(View viewObject, EObject modelObject) {
        Iterator values = ((EModelElement)modelObject).getEAnnotations().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2003 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEAnnotation_2003Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createClasses_5004Children(View viewObject, EObject modelObject) {
        Iterator values = ((EPackage)modelObject).getEClassifiers().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2004 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEClass_2004Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createPackages_5005Children(View viewObject, EObject modelObject) {
        Iterator values = ((EPackage)modelObject).getESubpackages().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2005 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEPackage_2005Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createData_types_5006Children(View viewObject, EObject modelObject) {
        Iterator values = ((EPackage)modelObject).getEClassifiers().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2006 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEDataType_2006Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEnums_5007Children(View viewObject, EObject modelObject) {
        Iterator values = ((EPackage)modelObject).getEClassifiers().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2007 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEEnum_2007Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createPackage_annotations_5008Children(View viewObject, EObject modelObject) {
        Iterator values = ((EModelElement)modelObject).getEAnnotations().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2003 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEAnnotation_2003Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createDetails_5009Children(View viewObject, EObject modelObject) {
        Iterator values = ((EAnnotation)modelObject).getDetails().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2008 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEStringToStringMapEntry_2008Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createData_type_annotations_5010Children(View viewObject, EObject modelObject) {
        Iterator values = ((EModelElement)modelObject).getEAnnotations().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2003 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEAnnotation_2003Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createLiterals_5011Children(View viewObject, EObject modelObject) {
        Iterator values = ((EEnum)modelObject).getELiterals().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2009 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEEnumLiteral_2009Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEnum_annotations_5012Children(View viewObject, EObject modelObject) {
        Iterator values = ((EModelElement)modelObject).getEAnnotations().iterator();
        while (values.hasNext()) {
            EObject nextValue = (EObject)values.next();
            int nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (2003 != nodeVID) continue;
            Node nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEAnnotation_2003Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private void createEPackage_79Children(View viewObject, EObject modelObject) {
        Node nextNode;
        int nodeVID;
        EObject nextValue;
        Iterator values = ((EPackage)modelObject).getEClassifiers().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (1001 != nodeVID) continue;
            nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEClass_1001Children((View)nextNode, nextValue);
        }
        values = ((EPackage)modelObject).getESubpackages().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (1002 != nodeVID) continue;
            nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEPackage_1002Children((View)nextNode, nextValue);
        }
        values = ((EModelElement)modelObject).getEAnnotations().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (1003 != nodeVID) continue;
            nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEAnnotation_1003Children((View)nextNode, nextValue);
        }
        values = ((EPackage)modelObject).getEClassifiers().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (1004 != nodeVID) continue;
            nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEDataType_1004Children((View)nextNode, nextValue);
        }
        values = ((EPackage)modelObject).getEClassifiers().iterator();
        while (values.hasNext()) {
            nextValue = (EObject)values.next();
            nodeVID = EcoreVisualIDRegistry.INSTANCE.getNodeVisualID(viewObject, nextValue, "");
            if (1005 != nodeVID) continue;
            nextNode = ViewService.createNode((View)viewObject, (EObject)nextValue, null, (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            this.myEObject2NodeMap.put(nextValue, nextNode);
            this.createEEnum_1005Children((View)nextNode, nextValue);
        }
        this.storeLinks(modelObject, viewObject.getDiagram());
    }

    private Node getCompartment(View node, String name) {
        Iterator it = node.getChildren().iterator();
        while (it.hasNext()) {
            View nextView = (View)it.next();
            if (!(nextView instanceof Node) || !name.equals(nextView.getType())) continue;
            return (Node)nextView;
        }
        return null;
    }

    private void storeLinks(EObject container, Diagram diagram) {
        EClass containerMetaclass = container.eClass();
        this.storeFeatureModelFacetLinks(container, containerMetaclass, diagram);
        this.storeTypeModelFacetLinks(container, containerMetaclass, diagram);
    }

    private void storeTypeModelFacetLinks(EObject container, EClass containerMetaclass, Diagram diagram) {
        EObject dst;
        EClassifier structuralFeatureResult;
        int linkVID;
        EObject nextValue;
        Iterator values;
        EList featureValue;
        if (-1 != containerMetaclass.getFeatureID((EStructuralFeature)EcorePackage.eINSTANCE.getEClass_EStructuralFeatures())) {
            featureValue = ((EClass)container).getEStructuralFeatures();
            values = ((Collection)featureValue).iterator();
            while (values.hasNext()) {
                nextValue = (EObject)values.next();
                linkVID = EcoreVisualIDRegistry.INSTANCE.getLinkWithClassVisualID(nextValue);
                if (3002 != linkVID || !((structuralFeatureResult = ((ETypedElement)nextValue).getEType()) instanceof EObject)) continue;
                dst = (EObject)structuralFeatureResult;
                ((Collection)this.myLinkVID2EObjectMap.get(LINK_KEY_3002)).add(new LinkDescriptor(container, dst, nextValue, diagram));
            }
        }
        if (-1 != containerMetaclass.getFeatureID((EStructuralFeature)EcorePackage.eINSTANCE.getEClass_EStructuralFeatures())) {
            featureValue = ((EClass)container).getEStructuralFeatures();
            values = ((Collection)featureValue).iterator();
            while (values.hasNext()) {
                nextValue = (EObject)values.next();
                linkVID = EcoreVisualIDRegistry.INSTANCE.getLinkWithClassVisualID(nextValue);
                if (3003 != linkVID || !((structuralFeatureResult = ((ETypedElement)nextValue).getEType()) instanceof EObject)) continue;
                dst = (EObject)structuralFeatureResult;
                ((Collection)this.myLinkVID2EObjectMap.get(LINK_KEY_3003)).add(new LinkDescriptor(container, dst, nextValue, diagram));
            }
        }
    }

    private void storeFeatureModelFacetLinks(EObject container, EClass containerMetaclass, Diagram diagram) {
        EObject nextDestination;
        Iterator destinations;
        EList structuralFeatureResult;
        if (-1 != containerMetaclass.getFeatureID((EStructuralFeature)EcorePackage.eINSTANCE.getEAnnotation_References())) {
            structuralFeatureResult = ((EAnnotation)container).getReferences();
            destinations = ((Collection)structuralFeatureResult).iterator();
            while (destinations.hasNext()) {
                nextDestination = (EObject)destinations.next();
                ((Collection)this.myLinkVID2EObjectMap.get(LINK_KEY_3001)).add(new LinkDescriptor(container, nextDestination, (IElementType)EcoreElementTypes.EAnnotationReferences_3001, diagram));
            }
        }
        if (-1 != containerMetaclass.getFeatureID((EStructuralFeature)EcorePackage.eINSTANCE.getEClass_ESuperTypes())) {
            structuralFeatureResult = ((EClass)container).getESuperTypes();
            destinations = ((Collection)structuralFeatureResult).iterator();
            while (destinations.hasNext()) {
                nextDestination = (EObject)destinations.next();
                ((Collection)this.myLinkVID2EObjectMap.get(LINK_KEY_3004)).add(new LinkDescriptor(container, nextDestination, (IElementType)EcoreElementTypes.EClassESuperTypes_3004, diagram));
            }
        }
    }

    private void createLinks() {
        Edge edge;
        LinkDescriptor nextLinkDescriptor;
        Collection linkElements = (Collection)this.myLinkVID2EObjectMap.get(LINK_KEY_3001);
        Iterator it = linkElements.iterator();
        while (it.hasNext()) {
            nextLinkDescriptor = (LinkDescriptor)it.next();
            edge = (Edge)ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)nextLinkDescriptor.getDiagram(), "", -1, EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            if (edge == null) continue;
            edge.setSource((View)((Node)this.myEObject2NodeMap.get(nextLinkDescriptor.getSource())));
            edge.setTarget((View)((Node)this.myEObject2NodeMap.get(nextLinkDescriptor.getDestination())));
        }
        linkElements = (Collection)this.myLinkVID2EObjectMap.get(LINK_KEY_3002);
        it = linkElements.iterator();
        while (it.hasNext()) {
            nextLinkDescriptor = (LinkDescriptor)it.next();
            edge = (Edge)ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)nextLinkDescriptor.getDiagram(), "", -1, EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            if (edge == null) continue;
            edge.setSource((View)((Node)this.myEObject2NodeMap.get(nextLinkDescriptor.getSource())));
            edge.setTarget((View)((Node)this.myEObject2NodeMap.get(nextLinkDescriptor.getDestination())));
        }
        linkElements = (Collection)this.myLinkVID2EObjectMap.get(LINK_KEY_3003);
        it = linkElements.iterator();
        while (it.hasNext()) {
            nextLinkDescriptor = (LinkDescriptor)it.next();
            edge = (Edge)ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)nextLinkDescriptor.getDiagram(), "", -1, EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            if (edge == null) continue;
            edge.setSource((View)((Node)this.myEObject2NodeMap.get(nextLinkDescriptor.getSource())));
            edge.setTarget((View)((Node)this.myEObject2NodeMap.get(nextLinkDescriptor.getDestination())));
        }
        linkElements = (Collection)this.myLinkVID2EObjectMap.get(LINK_KEY_3004);
        it = linkElements.iterator();
        while (it.hasNext()) {
            nextLinkDescriptor = (LinkDescriptor)it.next();
            edge = (Edge)ViewService.getInstance().createEdge(nextLinkDescriptor.getSemanticAdapter(), (View)nextLinkDescriptor.getDiagram(), "", -1, EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
            if (edge == null) continue;
            edge.setSource((View)((Node)this.myEObject2NodeMap.get(nextLinkDescriptor.getSource())));
            edge.setTarget((View)((Node)this.myEObject2NodeMap.get(nextLinkDescriptor.getDestination())));
        }
    }

    static /* synthetic */ Map access$2(EcoreInitDiagramFileAction ecoreInitDiagramFileAction) {
        return ecoreInitDiagramFileAction.myLinkVID2EObjectMap;
    }

    static /* synthetic */ Integer access$3() {
        return LINK_KEY_3001;
    }

    static /* synthetic */ Integer access$4() {
        return LINK_KEY_3002;
    }

    static /* synthetic */ Integer access$5() {
        return LINK_KEY_3003;
    }

    static /* synthetic */ Integer access$6() {
        return LINK_KEY_3004;
    }

    static /* synthetic */ void access$7(EcoreInitDiagramFileAction ecoreInitDiagramFileAction, View view, EObject eObject) {
        ecoreInitDiagramFileAction.createEPackage_79Children(view, eObject);
    }

    static /* synthetic */ void access$8(EcoreInitDiagramFileAction ecoreInitDiagramFileAction) {
        ecoreInitDiagramFileAction.createLinks();
    }

    static /* synthetic */ Map access$9(EcoreInitDiagramFileAction ecoreInitDiagramFileAction) {
        return ecoreInitDiagramFileAction.myEObject2NodeMap;
    }

    private class NewDiagramFileWizard
    extends Wizard {
        private TransactionalEditingDomain myEditingDomain = GMFEditingDomainFactory.INSTANCE.createEditingDomain();
        private WizardNewFileCreationPage myFileCreationPage;

        NewDiagramFileWizard() {
        }

        public void addPages() {
            this.myFileCreationPage = new WizardNewFileCreationPage("Initialize new Ecore diagram file", EcoreInitDiagramFileAction.this.mySelection);
            this.myFileCreationPage.setFileName(EcoreInitDiagramFileAction.this.mySelectedModelFile.getProjectRelativePath().removeFileExtension().addFileExtension("ecore_diagram").lastSegment());
            this.myFileCreationPage.setTitle("Diagram file");
            this.myFileCreationPage.setDescription("Create new diagram and initialize it using specified Ecore model content");
            this.addPage((IWizardPage)this.myFileCreationPage);
        }

        public boolean performFinish() {
            EObject diagramModelObject = this.load();
            if (diagramModelObject == null) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Failed to load user model");
                return false;
            }
            IFile diagramFile = this.myFileCreationPage.createNewFile();
            ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
            Resource diagramResource = resourceSet.createResource(URI.createPlatformResourceURI((String)diagramFile.getFullPath().toString()));
            LinkedList<IFile> affectedFiles = new LinkedList<IFile>();
            affectedFiles.add(EcoreInitDiagramFileAction.this.mySelectedModelFile);
            affectedFiles.add(diagramFile);
            AbstractTransactionalCommand command = new AbstractTransactionalCommand(this, this.myEditingDomain, "Initializing diagram contents", affectedFiles, diagramModelObject, diagramResource){
                final /* synthetic */ NewDiagramFileWizard this$1;
                private final /* synthetic */ EObject val$diagramModelObject;
                private final /* synthetic */ Resource val$diagramResource;
                {
                    this.this$1 = newDiagramFileWizard;
                    this.val$diagramModelObject = eObject;
                    this.val$diagramResource = resource;
                    super($anonymous0, $anonymous1, $anonymous2);
                }

                protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                    int diagramVID = EcoreVisualIDRegistry.INSTANCE.getDiagramVisualID(this.val$diagramModelObject);
                    if (diagramVID != 79) {
                        return CommandResult.newErrorCommandResult((String)"Incorrect model object stored as a root resource object");
                    }
                    EcoreInitDiagramFileAction.access$2(NewDiagramFileWizard.access$0(this.this$1)).put(EcoreInitDiagramFileAction.access$3(), new LinkedList<E>());
                    EcoreInitDiagramFileAction.access$2(NewDiagramFileWizard.access$0(this.this$1)).put(EcoreInitDiagramFileAction.access$4(), new LinkedList<E>());
                    EcoreInitDiagramFileAction.access$2(NewDiagramFileWizard.access$0(this.this$1)).put(EcoreInitDiagramFileAction.access$5(), new LinkedList<E>());
                    EcoreInitDiagramFileAction.access$2(NewDiagramFileWizard.access$0(this.this$1)).put(EcoreInitDiagramFileAction.access$6(), new LinkedList<E>());
                    Diagram diagram = ViewService.createDiagram((EObject)this.val$diagramModelObject, (String)"Ecore", (PreferencesHint)EcoreDiagramEditorPlugin.DIAGRAM_PREFERENCES_HINT);
                    this.val$diagramResource.getContents().add((Object)diagram);
                    EcoreInitDiagramFileAction.access$7(NewDiagramFileWizard.access$0(this.this$1), (View)diagram, this.val$diagramModelObject);
                    EcoreInitDiagramFileAction.access$8(NewDiagramFileWizard.access$0(this.this$1));
                    EcoreInitDiagramFileAction.access$2(NewDiagramFileWizard.access$0(this.this$1)).clear();
                    EcoreInitDiagramFileAction.access$9(NewDiagramFileWizard.access$0(this.this$1)).clear();
                    return CommandResult.newOKCommandResult();
                }
            };
            try {
                OperationHistoryFactory.getOperationHistory().execute((IUndoableOperation)command, (IProgressMonitor)new NullProgressMonitor(), null);
                diagramResource.save(Collections.EMPTY_MAP);
                IDE.openEditor((IWorkbenchPage)EcoreInitDiagramFileAction.this.myPart.getSite().getPage(), (IFile)diagramFile);
            }
            catch (ExecutionException e) {
                EcoreDiagramEditorPlugin.getInstance().logError("Unable to create model and diagram", e);
            }
            catch (IOException ex) {
                EcoreDiagramEditorPlugin.getInstance().logError("Save operation failed for: " + diagramFile.getFullPath().toString(), ex);
            }
            catch (PartInitException ex) {
                EcoreDiagramEditorPlugin.getInstance().logError("Unable to open editor", ex);
            }
            return true;
        }

        private EObject load() {
            ResourceSet resourceSet = this.myEditingDomain.getResourceSet();
            try {
                Resource resource = resourceSet.getResource(URI.createPlatformResourceURI((String)EcoreInitDiagramFileAction.this.mySelectedModelFile.getFullPath().toString()), true);
                return (EObject)resource.getContents().get(0);
            }
            catch (WrappedException ex) {
                EcoreDiagramEditorPlugin.getInstance().logError("Unable to load resource: " + EcoreInitDiagramFileAction.this.mySelectedModelFile.getFullPath().toString(), ex);
                return null;
            }
        }

        static /* synthetic */ EcoreInitDiagramFileAction access$0(NewDiagramFileWizard newDiagramFileWizard) {
            return newDiagramFileWizard.EcoreInitDiagramFileAction.this;
        }
    }

    private class LinkDescriptor {
        private EObject mySource;
        private EObject myDestination;
        private IAdaptable mySemanticAdapter;
        private Diagram myDiagram;
        static /* synthetic */ Class class$0;

        protected LinkDescriptor(EObject source, EObject destination, EObject linkElement, Diagram diagram) {
            this(source, destination, diagram);
            this.mySemanticAdapter = new EObjectAdapter(linkElement);
        }

        protected LinkDescriptor(EObject source, EObject destination, IElementType elementType, Diagram diagram) {
            this(source, destination, diagram);
            IElementType elementTypeCopy = elementType;
            this.mySemanticAdapter = new IAdaptable(this, elementTypeCopy){
                final /* synthetic */ LinkDescriptor this$1;
                private final /* synthetic */ IElementType val$elementTypeCopy;
                {
                    this.this$1 = linkDescriptor;
                    this.val$elementTypeCopy = iElementType;
                }

                public Object getAdapter(Class adapter) {
                    Class<?> clazz = LinkDescriptor.class$0;
                    if (clazz == null) {
                        try {
                            clazz = LinkDescriptor.class$0 = Class.forName("org.eclipse.gmf.runtime.emf.type.core.IElementType");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(adapter)) {
                        return this.val$elementTypeCopy;
                    }
                    return null;
                }
            };
        }

        LinkDescriptor(EObject source, EObject destination, Diagram diagram) {
            this.mySource = source;
            this.myDestination = destination;
            this.myDiagram = diagram;
        }

        protected EObject getSource() {
            return this.mySource;
        }

        protected EObject getDestination() {
            return this.myDestination;
        }

        protected Diagram getDiagram() {
            return this.myDiagram;
        }

        protected IAdaptable getSemanticAdapter() {
            return this.mySemanticAdapter;
        }
    }
}

