/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.emf.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.action.RedoAction;
import org.eclipse.emf.edit.ui.action.UndoAction;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.examples.extlibrary.actions.EXTLibraryExtendedActionBarContributor;
import org.eclipse.emf.examples.extlibrary.presentation.EXTLibraryEditorPlugin;
import org.eclipse.gmf.examples.runtime.emf.constraints.ValidationDelegateClientSelector;
import org.eclipse.gmf.examples.runtime.emf.dialogs.ValidationErrorDialog;
import org.eclipse.gmf.examples.runtime.emf.editor.MSLLibraryEditor;
import org.eclipse.gmf.examples.runtime.emf.internal.l10n.MSLExampleMessages;
import org.eclipse.gmf.examples.runtime.emf.properties.PropertySheetDialog;
import org.eclipse.gmf.runtime.emf.core.edit.MEditingDomain;
import org.eclipse.gmf.runtime.emf.core.edit.MFilter;
import org.eclipse.gmf.runtime.emf.core.edit.MListener;
import org.eclipse.gmf.runtime.emf.core.edit.MRunnable;
import org.eclipse.gmf.runtime.emf.core.edit.MUndoInterval;
import org.eclipse.gmf.runtime.emf.core.exceptions.MSLActionAbandonedException;
import org.eclipse.gmf.runtime.emf.core.util.EObjectUtil;
import org.eclipse.gmf.runtime.emf.core.util.MetaModelUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public class MSLLibraryActionBarContributor
extends EXTLibraryExtendedActionBarContributor {
    private static final String CREATE_ACTION_LABEL = MSLExampleMessages.CreateAction_label;
    private static final String CREATE_ACTION_TITLE = MSLExampleMessages.CreateAction_title;
    private static final String CREATE_ACTION_MESSAGE = MSLExampleMessages.CreateAction_message;
    private static final String CREATE_ACTION_UNDO_MESSAGE = MSLExampleMessages.CreateAction_undoMessage;
    private static final String CREATE_ACTION_WARNING_POSITIVE_INTEGER = MSLExampleMessages.CreateAction_warningPositiveInteger;
    private static final String EDIT_ACTION_UNDO_MESSAGE = MSLExampleMessages.EditAction_undoMessage;
    private static final String ERROR_LIVE_VALIDATION_TITLE = MSLExampleMessages.MSLLibraryActionBarContributor_liveValidationError;
    private static final String DELETE_ACTION_UNDO_MESSAGE = MSLExampleMessages.DeleteAction_undoMessage;
    private static final String PASTE_ACTION_UNDO_MESSAGE = MSLExampleMessages.PasteAction_undoMessage;
    private static final String RESOURCE_NAME = MSLExampleMessages.Resource_name;
    private MListener resourceLoadListener;
    private List undoIntervals = new ArrayList();
    private int pointer = -1;
    private MEditingDomain editingDomain = null;
    private String clipboardString = null;

    private MUndoInterval execute(String label, final Runnable r) {
        ValidationDelegateClientSelector.running = true;
        try {
            MUndoInterval mUndoInterval = this.getEditingDomain().runInUndoInterval(label, new Runnable(){

                public void run() {
                    try {
                        MSLLibraryActionBarContributor.this.getEditingDomain().runAsWrite(new MRunnable(this, r){
                            final /* synthetic */ 6 this$1;
                            private final /* synthetic */ Runnable val$r;
                            {
                                this.this$1 = var1_1;
                                this.val$r = runnable;
                            }

                            public Object run() {
                                this.val$r.run();
                                return null;
                            }
                        });
                    }
                    catch (MSLActionAbandonedException e) {
                        ValidationErrorDialog dialog = new ValidationErrorDialog(MSLLibraryActionBarContributor.this.getShell(), ERROR_LIVE_VALIDATION_TITLE, e.getStatus());
                        dialog.open();
                    }
                }
            });
            Object var3_4 = null;
            ValidationDelegateClientSelector.running = false;
            return mUndoInterval;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            ValidationDelegateClientSelector.running = false;
            throw throwable;
        }
    }

    private AdapterFactoryContentProvider getContentAdapter() {
        MSLLibraryEditor editor = (MSLLibraryEditor)this.getActiveEditor();
        return new AdapterFactoryContentProvider(editor.getAdapterFactory());
    }

    private MEditingDomain getEditingDomain() {
        if (this.editingDomain == null) {
            this.editingDomain = (MEditingDomain)((IEditingDomainProvider)this.getActiveEditor()).getEditingDomain();
        }
        return this.editingDomain;
    }

    private Shell getShell() {
        return this.getPage().getActivePart().getSite().getShell();
    }

    private void addUndoInterval(MUndoInterval undoInterval) {
        if (undoInterval.canUndo() && !undoInterval.isEmpty()) {
            while (this.pointer != this.undoIntervals.size() - 1) {
                this.undoIntervals.remove(this.pointer + 1);
            }
            this.undoIntervals.add(undoInterval);
            ++this.pointer;
        } else {
            this.undoIntervals.clear();
            this.pointer = -1;
        }
        this.update();
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection;
        EObject eObj;
        if (this.resourceLoadListener == null) {
            this.resourceLoadListener = new MListener(this.getEditingDomain(), MFilter.RESOURCE_UNLOADED_FILTER){

                public void onEvent(List events) {
                    MSLLibraryActionBarContributor.this.undoIntervals.clear();
                    MSLLibraryActionBarContributor.this.pointer = -1;
                    MSLLibraryActionBarContributor.this.update();
                }
            };
            this.resourceLoadListener.startListening();
        }
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        if ((eObj = this.extractEObjectFromSelection(selection = event.getSelection())) != null) {
            this.createChildActions = this.generateCreateChildActions(eObj);
            this.createSiblingActions = this.generateCreateSiblingActions(eObj);
        } else {
            this.createChildActions = Collections.EMPTY_SET;
            this.createSiblingActions = Collections.EMPTY_SET;
        }
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    private EObject extractEObjectFromSelection(ISelection selection) {
        Object o;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (o = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            EObject eObj = (EObject)o;
            return eObj;
        }
        return null;
    }

    protected Collection generateCreateChildActions(EObject eObj) {
        ArrayList<MSLCreateAction> actions = new ArrayList<MSLCreateAction>();
        EClass containerEClass = eObj.eClass();
        Iterator i = containerEClass.getEPackage().getEClassifiers().iterator();
        while (i.hasNext()) {
            EClassifier classifier = (EClassifier)i.next();
            if (!(classifier instanceof EClass)) continue;
            EClass eClass = (EClass)classifier;
            EReference feature = MetaModelUtil.findFeature((EClass)containerEClass, (EClass)eClass);
            if (eClass.isAbstract() || feature == null) continue;
            actions.add(new MSLCreateAction(eObj, feature, (EClass)classifier));
        }
        return actions;
    }

    protected Collection generateCreateSiblingActions(EObject eObj) {
        ArrayList<MSLCreateAction> actions = new ArrayList<MSLCreateAction>();
        if (eObj.eContainer() == null) {
            return actions;
        }
        EClass containerEClass = eObj.eContainer().eClass();
        Iterator i = containerEClass.getEPackage().getEClassifiers().iterator();
        while (i.hasNext()) {
            EClassifier classifier = (EClassifier)i.next();
            if (!(classifier instanceof EClass)) continue;
            EClass eClass = (EClass)classifier;
            EReference feature = MetaModelUtil.findFeature((EClass)containerEClass, (EClass)eClass);
            if (eClass.isAbstract() || feature == null) continue;
            actions.add(new MSLCreateAction(eObj.eContainer(), feature, (EClass)classifier));
        }
        return actions;
    }

    public void init(IActionBars actionBars) {
        super.init(actionBars);
        ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
        this.deleteAction = new MSLDeleteAction();
        this.deleteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_DELETE"));
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        this.cutAction = new MSLCutAction();
        this.cutAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_CUT"));
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        this.copyAction = new MSLCopyAction();
        this.copyAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_COPY"));
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        this.pasteAction = new MSLPasteAction();
        this.pasteAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_PASTE"));
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
        this.undoAction = new MSLUndoAction();
        this.undoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_UNDO"));
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        this.redoAction = new MSLRedoAction();
        this.redoAction.setImageDescriptor(sharedImages.getImageDescriptor("IMG_TOOL_REDO"));
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
    }

    public void dispose() {
        super.dispose();
        if (this.resourceLoadListener != null) {
            this.resourceLoadListener.stopListening();
            this.resourceLoadListener = null;
        }
    }

    public void contributeToMenu(IMenuManager menuManager) {
        MenuManager submenuManager = new MenuManager(MSLExampleMessages.MSLLibraryEditor_menu, "org.eclipse.gmf.examples.runtime.emf.extlibraryMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(EXTLibraryEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(EXTLibraryEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager inputMenuManager) {
                inputMenuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    static /* synthetic */ String access$4() {
        return CREATE_ACTION_WARNING_POSITIVE_INTEGER;
    }

    private class MSLCreateAction
    extends Action {
        private EObject container;
        private EReference containmentFeature;
        private EClass newObjectType;

        public MSLCreateAction(EObject container, EReference feature, EClass type) {
            super(NLS.bind((String)CREATE_ACTION_LABEL, (Object[])new Object[]{type.getName()}));
            this.container = container;
            this.containmentFeature = feature;
            this.newObjectType = type;
        }

        public void run() {
            super.run();
            InputDialog dialog = new InputDialog(MSLLibraryActionBarContributor.this.getShell(), CREATE_ACTION_TITLE, NLS.bind((String)CREATE_ACTION_MESSAGE, (Object[])new Object[]{this.newObjectType.getName()}), "1", new IInputValidator(this){
                final /* synthetic */ MSLCreateAction this$1;
                {
                    this.this$1 = mSLCreateAction;
                }

                public String isValid(String newText) {
                    try {
                        if (Integer.parseInt(newText) < 1) {
                            return MSLLibraryActionBarContributor.access$4();
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        return MSLLibraryActionBarContributor.access$4();
                    }
                    return null;
                }
            });
            if (dialog.open() == 0) {
                int number = Integer.parseInt(dialog.getValue());
                MUndoInterval undoInterval = MSLLibraryActionBarContributor.this.execute(NLS.bind((String)CREATE_ACTION_UNDO_MESSAGE, (Object[])new Object[]{new Integer(number), this.newObjectType.getName()}), new Runnable(this, number){
                    final /* synthetic */ MSLCreateAction this$1;
                    private final /* synthetic */ int val$number;
                    {
                        this.this$1 = mSLCreateAction;
                        this.val$number = n;
                    }

                    public void run() {
                        int i = 0;
                        while (i < this.val$number) {
                            EObjectUtil.create((EObject)MSLCreateAction.access$0(this.this$1), (EReference)MSLCreateAction.access$1(this.this$1), (EClass)MSLCreateAction.access$2(this.this$1));
                            ++i;
                        }
                    }
                });
                MSLLibraryActionBarContributor.this.addUndoInterval(undoInterval);
            }
        }

        static /* synthetic */ EObject access$0(MSLCreateAction mSLCreateAction) {
            return mSLCreateAction.container;
        }

        static /* synthetic */ EReference access$1(MSLCreateAction mSLCreateAction) {
            return mSLCreateAction.containmentFeature;
        }

        static /* synthetic */ EClass access$2(MSLCreateAction mSLCreateAction) {
            return mSLCreateAction.newObjectType;
        }
    }

    public static class MSLEditAction
    implements IEditorActionDelegate,
    IActionDelegate2 {
        EObject eObj = null;
        MSLLibraryActionBarContributor actionBarContrib;

        public void setSelectedObject(EObject eObject) {
            this.eObj = eObject;
        }

        public void setActiveEditor(IAction action, IEditorPart targetEditor) {
            if (targetEditor != null) {
                this.actionBarContrib = (MSLLibraryActionBarContributor)((MSLLibraryEditor)targetEditor).getActionBarContributor();
            }
        }

        public void run(IAction action) {
            if (this.eObj == null) {
                return;
            }
            PropertySheetDialog dialog = new PropertySheetDialog(this.actionBarContrib.getShell(), this.actionBarContrib.getContentAdapter(), this.eObj);
            MUndoInterval undoInterval = this.actionBarContrib.execute(NLS.bind((String)EDIT_ACTION_UNDO_MESSAGE, (Object[])new Object[]{EObjectUtil.getName((EObject)this.eObj)}), new Runnable(this, dialog){
                final /* synthetic */ MSLEditAction this$1;
                private final /* synthetic */ PropertySheetDialog val$dialog;
                {
                    this.this$1 = mSLEditAction;
                    this.val$dialog = propertySheetDialog;
                }

                public void run() {
                    this.val$dialog.open();
                }
            });
            if (dialog.getReturnCode() == 1) {
                undoInterval.undo();
            } else {
                this.actionBarContrib.addUndoInterval(undoInterval);
            }
        }

        public void selectionChanged(IAction action, ISelection selection) {
            Object o;
            IStructuredSelection structSel;
            if (selection instanceof IStructuredSelection && (structSel = (IStructuredSelection)selection).size() == 1 && (o = structSel.getFirstElement()) instanceof EObject) {
                this.setSelectedObject((EObject)o);
                action.setEnabled(true);
                return;
            }
            action.setEnabled(false);
        }

        public void init(IAction action) {
        }

        public void dispose() {
        }

        public void runWithEvent(IAction action, Event event) {
            this.run(action);
        }
    }

    private class MSLDeleteAction
    extends DeleteAction {
        private Collection objects;

        MSLDeleteAction() {
        }

        public Command createCommand(Collection selection) {
            return UnexecutableCommand.INSTANCE;
        }

        public boolean updateSelection(IStructuredSelection selection) {
            this.objects = selection.toList();
            return true;
        }

        public void run() {
            MSLLibraryActionBarContributor.this.addUndoInterval(MSLLibraryActionBarContributor.this.execute(DELETE_ACTION_UNDO_MESSAGE, new Runnable(this){
                final /* synthetic */ MSLDeleteAction this$1;
                {
                    this.this$1 = mSLDeleteAction;
                }

                public void run() {
                    Iterator<E> i = MSLDeleteAction.access$0(this.this$1).iterator();
                    while (i.hasNext()) {
                        E o = i.next();
                        if (!(o instanceof EObject)) continue;
                        EObjectUtil.destroy((EObject)((EObject)o));
                    }
                }
            }));
        }

        static /* synthetic */ Collection access$0(MSLDeleteAction mSLDeleteAction) {
            return mSLDeleteAction.objects;
        }
    }

    private class MSLCutAction
    extends CutAction {
        private Collection objects;

        MSLCutAction() {
        }

        public Command createCommand(Collection selection) {
            return UnexecutableCommand.INSTANCE;
        }

        public boolean updateSelection(IStructuredSelection selection) {
            this.objects = selection.toList();
            return true;
        }

        public void run() {
            HashSet objectsToCut = new HashSet();
            Iterator i = this.objects.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof EObject)) continue;
                objectsToCut.add(o);
            }
            MSLLibraryActionBarContributor.this.clipboardString = EObjectUtil.serialize(objectsToCut, (Map)Collections.EMPTY_MAP);
            ((EditingDomainActionBarContributor)MSLLibraryActionBarContributor.this).deleteAction.run();
        }
    }

    private class MSLCopyAction
    extends CopyAction {
        private Collection objects;

        MSLCopyAction() {
        }

        public Command createCommand(Collection selection) {
            return UnexecutableCommand.INSTANCE;
        }

        public boolean updateSelection(IStructuredSelection selection) {
            this.objects = selection.toList();
            return true;
        }

        public void run() {
            HashSet objectsToCopy = new HashSet();
            Iterator i = this.objects.iterator();
            while (i.hasNext()) {
                Object o = i.next();
                if (!(o instanceof EObject)) continue;
                objectsToCopy.add(o);
            }
            MSLLibraryActionBarContributor.this.clipboardString = EObjectUtil.serialize(objectsToCopy, (Map)Collections.EMPTY_MAP);
        }
    }

    private class MSLPasteAction
    extends PasteAction {
        private Object obj;

        MSLPasteAction() {
        }

        public Command createCommand(Collection selection) {
            return UnexecutableCommand.INSTANCE;
        }

        public boolean updateSelection(IStructuredSelection selection) {
            Object o;
            if (selection.size() == 1 && ((o = selection.getFirstElement()) instanceof Resource || o instanceof EObject)) {
                this.obj = o;
            }
            return this.obj != null && MSLLibraryActionBarContributor.this.clipboardString != null;
        }

        public void run() {
            MSLLibraryActionBarContributor.this.addUndoInterval(MSLLibraryActionBarContributor.this.execute(NLS.bind((String)PASTE_ACTION_UNDO_MESSAGE, (Object)this.getName()), new Runnable(this){
                final /* synthetic */ MSLPasteAction this$1;
                {
                    this.this$1 = mSLPasteAction;
                }

                public void run() {
                    if (MSLPasteAction.access$0(this.this$1) instanceof EObject) {
                        EObjectUtil.deserialize((EObject)((EObject)MSLPasteAction.access$0(this.this$1)), (String)MSLLibraryActionBarContributor.access$13(MSLPasteAction.access$1(this.this$1)), (Map)Collections.EMPTY_MAP);
                    } else if (MSLPasteAction.access$0(this.this$1) instanceof Resource) {
                        EObjectUtil.deserialize((Resource)((Resource)MSLPasteAction.access$0(this.this$1)), (String)MSLLibraryActionBarContributor.access$13(MSLPasteAction.access$1(this.this$1)), (Map)Collections.EMPTY_MAP);
                    }
                }
            }));
        }

        private String getName() {
            if (this.obj instanceof EObject) {
                return EObjectUtil.getName((EObject)((EObject)this.obj));
            }
            if (this.obj instanceof Resource) {
                return RESOURCE_NAME;
            }
            return null;
        }

        static /* synthetic */ Object access$0(MSLPasteAction mSLPasteAction) {
            return mSLPasteAction.obj;
        }

        static /* synthetic */ MSLLibraryActionBarContributor access$1(MSLPasteAction mSLPasteAction) {
            return mSLPasteAction.MSLLibraryActionBarContributor.this;
        }
    }

    private class MSLUndoAction
    extends UndoAction {
        MSLUndoAction() {
        }

        public Command createCommand(Collection selection) {
            return UnexecutableCommand.INSTANCE;
        }

        public void update() {
            if (MSLLibraryActionBarContributor.this.pointer > -1) {
                MUndoInterval interval = (MUndoInterval)MSLLibraryActionBarContributor.this.undoIntervals.get(MSLLibraryActionBarContributor.this.pointer);
                this.setText(NLS.bind((String)MSLExampleMessages.Undo_menu_item_label, (Object[])new Object[]{interval.getLabel()}));
                this.setEnabled(interval.canUndo());
            } else {
                this.setText(NLS.bind((String)MSLExampleMessages.Redo_menu_item_label, (Object[])new Object[]{""}));
                this.setEnabled(false);
            }
        }

        public void run() {
            if (MSLLibraryActionBarContributor.this.pointer > -1) {
                MUndoInterval interval = (MUndoInterval)MSLLibraryActionBarContributor.this.undoIntervals.get(MSLLibraryActionBarContributor.this.pointer);
                interval.undo();
                MSLLibraryActionBarContributor mSLLibraryActionBarContributor = MSLLibraryActionBarContributor.this;
                mSLLibraryActionBarContributor.pointer = mSLLibraryActionBarContributor.pointer - 1;
                MSLLibraryActionBarContributor.this.update();
            }
        }
    }

    private class MSLRedoAction
    extends RedoAction {
        MSLRedoAction() {
        }

        public Command createCommand(Collection selection) {
            return UnexecutableCommand.INSTANCE;
        }

        public void update() {
            if (MSLLibraryActionBarContributor.this.pointer >= -1 && MSLLibraryActionBarContributor.this.undoIntervals.size() > MSLLibraryActionBarContributor.this.pointer + 1) {
                MUndoInterval interval = (MUndoInterval)MSLLibraryActionBarContributor.this.undoIntervals.get(MSLLibraryActionBarContributor.this.pointer + 1);
                this.setText(NLS.bind((String)MSLExampleMessages.Redo_menu_item_label, (Object[])new Object[]{interval.getLabel()}));
                this.setEnabled(interval.canRedo());
            } else {
                this.setText(NLS.bind((String)MSLExampleMessages.Redo_menu_item_label, (Object[])new Object[]{""}));
                this.setEnabled(false);
            }
        }

        public void run() {
            if (MSLLibraryActionBarContributor.this.pointer >= -1 && MSLLibraryActionBarContributor.this.undoIntervals.size() > MSLLibraryActionBarContributor.this.pointer + 1) {
                MUndoInterval interval = (MUndoInterval)MSLLibraryActionBarContributor.this.undoIntervals.get(MSLLibraryActionBarContributor.this.pointer + 1);
                interval.redo();
                MSLLibraryActionBarContributor mSLLibraryActionBarContributor = MSLLibraryActionBarContributor.this;
                mSLLibraryActionBarContributor.pointer = mSLLibraryActionBarContributor.pointer + 1;
                MSLLibraryActionBarContributor.this.update();
            }
        }
    }
}

