/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.emf.actions;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.gmf.examples.runtime.emf.internal.l10n.MSLExampleMessages;
import org.eclipse.gmf.runtime.emf.core.edit.MEditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class SetPathmapDelegate
implements IEditorActionDelegate,
IActionDelegate2 {
    protected EditingDomain domain;

    public EditingDomain getEditingDomain() {
        return this.domain;
    }

    public void setEditingDomain(EditingDomain domain) {
        this.domain = domain;
    }

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
        if (targetEditor != null) {
            IEditingDomainProvider provider = (IEditingDomainProvider)targetEditor;
            this.setEditingDomain(provider.getEditingDomain());
        }
    }

    public void run(IAction action) {
        SetPathmapDialog loadResourceDialog = new SetPathmapDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain);
        loadResourceDialog.open();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void init(IAction action) {
    }

    public void dispose() {
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public static class SetPathmapDialog
    extends Dialog {
        public static int CONTROL_OFFSET = 10;
        protected EditingDomain domain;
        protected Text resourceURIField;
        protected Text pathmapNameField;
        protected String resourceURIs;

        public SetPathmapDialog(Shell parent) {
            this(parent, null);
        }

        public SetPathmapDialog(Shell parent, EditingDomain domain) {
            super(parent);
            this.setShellStyle(this.getShellStyle() | 0x400 | 0x10);
            this.domain = domain;
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(MSLExampleMessages.SetPathmapDialog_title);
        }

        protected Control createDialogArea(Composite parent) {
            FormData data;
            boolean resourcesBundleIsAvailable = Platform.getBundle((String)"org.eclipse.core.resources") != null;
            Composite composite = (Composite)super.createDialogArea(parent);
            FormLayout layout = new FormLayout();
            composite.setLayout((Layout)layout);
            GridData data2 = new GridData();
            data2.verticalAlignment = 4;
            data2.grabExcessVerticalSpace = true;
            data2.horizontalAlignment = 4;
            data2.grabExcessHorizontalSpace = true;
            if (!resourcesBundleIsAvailable) {
                data2.widthHint = 330;
            }
            composite.setLayoutData((Object)data2);
            Composite buttonComposite = new Composite(composite, 0);
            data2 = new FormData();
            data2.top = new FormAttachment(0, CONTROL_OFFSET);
            data2.left = new FormAttachment(30, 0);
            data2.right = new FormAttachment(100, -CONTROL_OFFSET);
            buttonComposite.setLayoutData((Object)data2);
            buttonComposite.setLayout((Layout)new FormLayout());
            Label resourceURILabel = new Label(composite, 16384);
            resourceURILabel.setText(MSLExampleMessages.ContainerURI_label);
            FormData data3 = new FormData();
            data3.top = new FormAttachment((Control)buttonComposite, CONTROL_OFFSET, 0x1000000);
            data3.left = new FormAttachment(0, CONTROL_OFFSET);
            resourceURILabel.setLayoutData((Object)data3);
            this.resourceURIField = new Text(composite, 2048);
            data3 = new FormData();
            data3.top = new FormAttachment((Control)buttonComposite, CONTROL_OFFSET);
            data3.left = new FormAttachment(0, CONTROL_OFFSET);
            data3.right = new FormAttachment(100, -CONTROL_OFFSET);
            this.resourceURIField.setLayoutData((Object)data3);
            Label pathmapLabel = new Label(composite, 16384);
            pathmapLabel.setText(MSLExampleMessages.SetPathmapDelegate_pathmapNameLabel);
            FormData data4 = new FormData();
            data4.top = new FormAttachment((Control)this.resourceURIField, CONTROL_OFFSET);
            data4.left = new FormAttachment(0, CONTROL_OFFSET);
            pathmapLabel.setLayoutData((Object)data4);
            this.pathmapNameField = new Text(composite, 2048);
            this.pathmapNameField.setText(MSLExampleMessages.SetPathmapDelegate_pathmapDefaultName);
            data4 = new FormData();
            data4.top = new FormAttachment((Control)pathmapLabel, CONTROL_OFFSET);
            data4.left = new FormAttachment(0, CONTROL_OFFSET);
            data4.right = new FormAttachment(100, -CONTROL_OFFSET);
            this.pathmapNameField.setLayoutData((Object)data4);
            Button resourceURIBrowseFileSystemButton = new Button(buttonComposite, 8);
            resourceURIBrowseFileSystemButton.setText(MSLExampleMessages.BrowseFileSystem_label);
            resourceURIBrowseFileSystemButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                final /* synthetic */ SetPathmapDialog this$1;
                {
                    this.this$1 = setPathmapDialog;
                }

                public void widgetSelected(SelectionEvent event) {
                    DirectoryDialog fileDialog = new DirectoryDialog(this.this$1.getShell());
                    String directoryName = fileDialog.open();
                    if (directoryName != null && directoryName.length() > 0) {
                        String filePath = fileDialog.getFilterPath();
                        this.this$1.resourceURIField.setText(filePath);
                    }
                }
            });
            if (resourcesBundleIsAvailable) {
                Button resourceURIBrowseWorkspaceButton = new Button(buttonComposite, 8);
                data = new FormData();
                data.right = new FormAttachment(100);
                resourceURIBrowseWorkspaceButton.setLayoutData((Object)data);
                data = new FormData();
                data.right = new FormAttachment((Control)resourceURIBrowseWorkspaceButton, -CONTROL_OFFSET);
                resourceURIBrowseFileSystemButton.setLayoutData((Object)data);
                resourceURIBrowseWorkspaceButton.setText(MSLExampleMessages.BrowseWorkspace_label);
                resourceURIBrowseWorkspaceButton.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SetPathmapDialog this$1;
                    {
                        this.this$1 = setPathmapDialog;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        ContainerSelectionDialog containerSelectionDialog = new ContainerSelectionDialog(this.this$1.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, MSLExampleMessages.SelectContainer_label);
                        containerSelectionDialog.open();
                        Object[] result = containerSelectionDialog.getResult();
                        if (result != null) {
                            StringBuffer text = new StringBuffer();
                            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)result[0]);
                            if (resource.getType() == 2 || resource.getType() == 4) {
                                text.append(resource.getLocation().toOSString());
                            }
                            this.this$1.resourceURIField.setText(text.toString());
                        }
                    }
                });
            } else {
                FormData data5 = new FormData();
                data5.right = new FormAttachment(100);
                resourceURIBrowseFileSystemButton.setLayoutData((Object)data5);
            }
            Label separatorLabel = new Label(composite, 258);
            data = new FormData();
            data.top = new FormAttachment((Control)this.pathmapNameField, (int)(1.5 * (double)CONTROL_OFFSET));
            data.left = new FormAttachment(0, -CONTROL_OFFSET);
            data.right = new FormAttachment(100, CONTROL_OFFSET);
            separatorLabel.setLayoutData((Object)data);
            composite.setTabList(new Control[]{this.resourceURIField, this.pathmapNameField, buttonComposite});
            return composite;
        }

        protected void okPressed() {
            this.resourceURIs = this.getResourceURIs();
            if (this.domain != null) {
                ((MEditingDomain)this.domain).setPathVariable(this.pathmapNameField.getText(), URI.createFileURI((String)this.resourceURIs).toString());
            }
            super.okPressed();
        }

        public boolean close() {
            return super.close();
        }

        public String getResourceURIs() {
            return this.resourceURIField != null && !this.resourceURIField.isDisposed() ? this.resourceURIField.getText() : this.resourceURIs;
        }

        public List getURIs() {
            ArrayList<URI> uris = new ArrayList<URI>();
            StringTokenizer stringTokenizer = new StringTokenizer(this.getResourceURIs());
            while (stringTokenizer.hasMoreTokens()) {
                String resourceURI = stringTokenizer.nextToken();
                uris.add(URI.createURI((String)resourceURI));
            }
            return uris;
        }
    }
}

