/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.emf.constraints;

import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.BookCategory;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.validation.AbstractModelConstraint;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.gmf.runtime.emf.core.util.EObjectUtil;

public class TooGenreSpecificConstraint
extends AbstractModelConstraint {
    private static final int MAX = 5;

    public IStatus validate(IValidationContext ctx) {
        Writer writer = (Writer)ctx.getTarget();
        int scifi = 0;
        int mystery = 0;
        int bio = 0;
        EList books = writer.getBooks();
        Iterator i = books.iterator();
        while (i.hasNext()) {
            Book b = (Book)i.next();
            if (b.getCategory() == BookCategory.SCIENCE_FICTION_LITERAL) {
                if (++scifi <= 5) continue;
                return ctx.createFailureStatus(new Object[]{EObjectUtil.getName((EObject)writer), BookCategory.SCIENCE_FICTION_LITERAL.getName()});
            }
            if (b.getCategory() == BookCategory.MYSTERY_LITERAL) {
                if (++mystery <= 5) continue;
                return ctx.createFailureStatus(new Object[]{EObjectUtil.getName((EObject)writer), BookCategory.MYSTERY_LITERAL.getName()});
            }
            if (b.getCategory() != BookCategory.BIOGRAPHY_LITERAL || ++bio <= 5) continue;
            return ctx.createFailureStatus(new Object[]{EObjectUtil.getName((EObject)writer), BookCategory.BIOGRAPHY_LITERAL.getName()});
        }
        return ctx.createSuccessStatus();
    }
}

