/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.emf.metamodel;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.EXTLibraryPackage;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.gmf.runtime.emf.core.services.metamodel.IMetamodelSupport;
import org.eclipse.gmf.runtime.emf.core.util.EObjectUtil;

public class LibraryMetaModel
implements IMetamodelSupport {
    private static final String CORE_LIBRARIES_PATHMAP = "CORE_LIBRARIES";

    public boolean canDestroy(EObject eObject) {
        return true;
    }

    public boolean canContain(EClass eContainer, EReference eReference, EClass eClass) {
        return true;
    }

    public void handleEvent(Notification event) {
        if (!(event.getNotifier() instanceof EObject)) {
            return;
        }
        if (event.getFeature() instanceof EReference && ((EReference)event.getFeature()).isContainment()) {
            if (event.getEventType() == 3) {
                this.autoName((EObject)event.getNotifier(), (EReference)event.getFeature(), (EObject)event.getNewValue());
            } else if (event.getEventType() == 5) {
                this.autoName((EObject)event.getNotifier(), (EReference)event.getFeature(), (Collection)event.getNewValue());
            }
        }
    }

    private void setName(EObject eObj, String name) {
        EClass eCls = eObj.eClass();
        if (eCls == EXTLibraryPackage.eINSTANCE.getLibrary()) {
            ((Library)eObj).setName(name);
        } else if (eCls == EXTLibraryPackage.eINSTANCE.getBook()) {
            ((Book)eObj).setTitle(name);
        } else if (eCls == EXTLibraryPackage.eINSTANCE.getWriter()) {
            ((Writer)eObj).setName(name);
        }
    }

    private String getName(EObject eObj) {
        if (eObj.eClass() == EXTLibraryPackage.eINSTANCE.getBook()) {
            return ((Book)eObj).getTitle();
        }
        return EObjectUtil.getName((EObject)eObj);
    }

    private void autoName(EObject container, EReference reference, EObject eObject) {
        if (reference.isMany()) {
            int max = 1;
            Iterator i = ((Collection)container.eGet((EStructuralFeature)reference)).iterator();
            while (i.hasNext()) {
                int number;
                String name = this.getName((EObject)i.next());
                if (name == null || (number = this.extractNumeric(eObject.eClass().getName(), name)) < max) continue;
                max = number + 1;
            }
            this.setName(eObject, String.valueOf(eObject.eClass().getName()) + max);
        } else {
            this.setName(eObject, eObject.eClass().getName());
        }
    }

    private int extractNumeric(String prefix, String fullName) {
        String suffix;
        if (fullName.startsWith(prefix) && (suffix = fullName.substring(prefix.length(), fullName.length())).length() > 0) {
            try {
                return Integer.parseInt(suffix);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return 0;
    }

    private void autoName(EObject container, EReference reference, Collection objects) {
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            this.autoName(container, reference, eObject);
        }
    }

    public void postProcess(EObject root) {
        root.eResource().getResourceSet().getResource(URI.createURI((String)"pathmap://CORE_LIBRARIES/LibraryOfCongress.extlibrary"), true);
    }
}

