/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.examples.runtime.emf.properties;

import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.gmf.examples.runtime.emf.internal.l10n.MSLExampleMessages;
import org.eclipse.gmf.examples.runtime.emf.properties.PropertySheetViewer;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.views.properties.IPropertySheetEntry;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetEntry;

public class PropertySheetDialog
extends Dialog {
    AdapterFactoryContentProvider contentProvider;
    Object context;

    public PropertySheetDialog(Shell parentShell, AdapterFactoryContentProvider contentProvider, Object context) {
        super(parentShell);
        this.setShellStyle(67696);
        this.contentProvider = contentProvider;
        this.context = context;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(MSLExampleMessages.PropertySheetDialog_title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        AdapterFactoryContentProvider propertySourceProvider = this.contentProvider;
        final PropertySheetViewer propertyViewer = new PropertySheetViewer(composite, 66306, true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        propertyViewer.getControl().setLayoutData((Object)gridData);
        PropertySheetEntry root = new PropertySheetEntry();
        root.setPropertySourceProvider((IPropertySourceProvider)propertySourceProvider);
        propertyViewer.setRootEntry((IPropertySheetEntry)root);
        propertyViewer.setInput(new Object[]{this.context});
        parent.setSize(400, 800);
        final Button reset = new Button(composite, 16384);
        reset.setText(MSLExampleMessages.PropertySheetDialog_resetProperty);
        reset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                propertyViewer.resetProperties();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        reset.setEnabled(false);
        propertyViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                reset.setEnabled(propertyViewer.getActiveCellEditor() != null);
            }
        });
        return composite;
    }
}

