/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.core.internal.listener;

import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.core.util.PackageUtil;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;

public class NotationSemProc
extends TriggerListener {
    private static NotationPackage notation = NotationPackage.eINSTANCE;
    private static Set autoNamedElements = new HashSet();
    private static Set nonAutoNamedElements = new HashSet();

    static {
        autoNamedElements.add(notation.getDiagram());
    }

    protected Command trigger(TransactionalEditingDomain editingDomain, Notification notification) {
        int eventType = notification.getEventType();
        Object notifier = notification.getNotifier();
        Object feature = notification.getFeature();
        Object newValue = notification.getNewValue();
        if (notifier instanceof EObject) {
            EObject eObject = (EObject)notifier;
            if (feature instanceof EReference && ((EReference)feature).isContainment()) {
                if (eventType == 3 && newValue instanceof EObject) {
                    return this.getAutoNameCommand(editingDomain, eObject, (EReference)feature, (EObject)newValue);
                }
                if (eventType == 5 && newValue instanceof Collection) {
                    return this.getAutoNameCommand(editingDomain, eObject, (EReference)feature, (Collection)newValue);
                }
                if ((eventType == 1 || eventType == 2) && newValue instanceof EObject) {
                    return this.getAutoNameCommand(editingDomain, eObject, (EReference)feature, (EObject)newValue);
                }
            }
            if (notification.getEventType() == 4) {
                Edge edge;
                final EObject removedObject = (EObject)notification.getOldValue();
                if (removedObject.eResource() == null) {
                    return new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            NotationSemProc.preProcessDestroy(removedObject);
                        }
                    };
                }
                if (NotationPackage.eINSTANCE.getView_SourceEdges().equals(feature)) {
                    final Edge edge2 = (Edge)notification.getOldValue();
                    if (edge2.getSource() == null) {
                        return new RecordingCommand(editingDomain){

                            protected void doExecute() {
                                EMFCoreUtil.destroy((EObject)edge2);
                            }
                        };
                    }
                } else if (NotationPackage.eINSTANCE.getView_TargetEdges().equals(feature) && (edge = (Edge)notification.getOldValue()).getTarget() == null) {
                    return new RecordingCommand(editingDomain){

                        protected void doExecute() {
                            EMFCoreUtil.destroy((EObject)edge);
                        }
                    };
                }
            }
        }
        return null;
    }

    private Command getAutoNameCommand(TransactionalEditingDomain editingDomain, final EObject container, final EReference reference, final Collection objects) {
        return new RecordingCommand(editingDomain){

            protected void doExecute() {
                NotationSemProc.autoName(container, reference, objects);
            }
        };
    }

    private Command getAutoNameCommand(TransactionalEditingDomain editingDomain, final EObject container, final EReference reference, final EObject eObject) {
        return new RecordingCommand(editingDomain){

            protected void doExecute() {
                NotationSemProc.autoName(container, reference, eObject);
            }
        };
    }

    private static boolean canAutoName(EClass eClass) {
        if (autoNamedElements.contains(eClass)) {
            return true;
        }
        if (nonAutoNamedElements.contains(eClass)) {
            return false;
        }
        Iterator i = eClass.getESuperTypes().iterator();
        while (i.hasNext()) {
            if (!NotationSemProc.canAutoName((EClass)i.next())) continue;
            return true;
        }
        return false;
    }

    private static void autoName(EObject container, EReference reference, Collection objects) {
        Iterator i = objects.iterator();
        while (i.hasNext()) {
            Object object = i.next();
            if (!(object instanceof EObject)) continue;
            EObject eObject = (EObject)object;
            NotationSemProc.autoName(container, reference, eObject);
        }
    }

    private static void autoName(EObject container, EReference reference, EObject eObject) {
        String name = null;
        if (!(eObject instanceof Diagram)) {
            return;
        }
        name = ((Diagram)eObject).getName();
        if (name == null || name.equals("") && NotationSemProc.canAutoName(eObject.eClass())) {
            name = PackageUtil.getLocalizedName((ENamedElement)eObject.eClass());
            if (reference.isMany()) {
                String n;
                HashSet<String> set = new HashSet<String>();
                Iterator i = ((Collection)container.eGet((EStructuralFeature)reference)).iterator();
                while (i.hasNext()) {
                    Object sibling = i.next();
                    if (sibling == null) continue;
                    n = null;
                    if (sibling instanceof Diagram) {
                        n = ((Diagram)sibling).getName();
                    }
                    if (n == null) continue;
                    set.add(n);
                }
                int j = 1;
                while (j <= Integer.MAX_VALUE) {
                    n = String.valueOf(name) + j;
                    if (!set.contains(n)) {
                        name = n;
                        break;
                    }
                    ++j;
                }
            }
            if (eObject instanceof Diagram) {
                ((Diagram)eObject).setName(name);
            }
        }
    }

    private static void preProcessDestroy(EObject eObject) {
        Collection semanticReferencers = EMFCoreUtil.getReferencers((EObject)eObject, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getView_Element()});
        Iterator i = semanticReferencers.iterator();
        while (i.hasNext()) {
            EObject referencer = (EObject)i.next();
            if (referencer == null) continue;
            EMFCoreUtil.destroy((EObject)referencer);
        }
        if (eObject instanceof View) {
            Collection nodeEntryKeys = EMFCoreUtil.getReferencers((EObject)eObject, (EReference[])new EReference[]{NotationPackage.eINSTANCE.getNodeEntry_Key()});
            Iterator i2 = nodeEntryKeys.iterator();
            while (i2.hasNext()) {
                EObject nodeEntry = (EObject)i2.next();
                if (nodeEntry == null) continue;
                EMFCoreUtil.destroy((EObject)nodeEntry);
            }
        }
    }
}

